/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.base.mvel.MVELSalienceExpression;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.NetworkNode;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMemory
extends AbstractBaseLinkedListNode<Memory>
implements Memory {
    protected static transient Logger log = LoggerFactory.getLogger(SegmentMemory.class);
    private long linkedSegmentMask;
    private long allLinkedMaskTest;
    private NetworkNode networkNode;
    private volatile RuleAgendaItem agendaItem;
    private SegmentMemory[] segmentMemories;
    private SegmentMemory segmentMemory;

    public PathMemory(NetworkNode networkNode) {
        this.networkNode = networkNode;
    }

    public NetworkNode getNetworkNode() {
        return this.networkNode;
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.agendaItem;
    }

    public void setAgendaItem(RuleAgendaItem agendaItem) {
        this.agendaItem = agendaItem;
    }

    public void setlinkedSegmentMask(long mask) {
        this.linkedSegmentMask = mask;
    }

    public long getLinkedSegmentMask() {
        return this.linkedSegmentMask;
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public void linkNodeWithoutRuleNotify(long mask) {
        this.linkedSegmentMask |= mask;
    }

    public void linkSegment(long mask, InternalWorkingMemory wm) {
        if (log.isTraceEnabled()) {
            if (NodeTypeEnums.isTerminalNode(this.getNetworkNode())) {
                TerminalNode rtn = (TerminalNode)this.getNetworkNode();
                log.trace("  LinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, rtn.getRule().getName()});
            } else {
                log.trace("  LinkSegment smask={} rmask={} name={}", (Object)mask, (Object)"RiaNode");
            }
        }
        this.linkedSegmentMask |= mask;
        if (this.isRuleLinked()) {
            this.doLinkRule(wm);
        }
    }

    public void doLinkRule(InternalWorkingMemory wm) {
        TerminalNode rtn = (TerminalNode)this.getNetworkNode();
        if (log.isTraceEnabled()) {
            log.trace("    LinkRule name={}", (Object)rtn.getRule().getName());
        }
        if (this.agendaItem == null) {
            int salience = rtn.getRule().getSalience() instanceof MVELSalienceExpression ? 0 : rtn.getRule().getSalience().getValue(null, rtn.getRule(), wm);
            this.agendaItem = ((InternalAgenda)wm.getAgenda()).createRuleAgendaItem(salience, this, rtn);
        }
        this.queueRuleAgendaItem(wm);
    }

    public void doUnlinkRule(InternalWorkingMemory wm) {
        TerminalNode rtn = (TerminalNode)this.getNetworkNode();
        if (log.isTraceEnabled()) {
            log.trace("    UnlinkRule name={}", (Object)rtn.getRule().getName());
        }
        if (this.agendaItem == null) {
            int salience = rtn.getRule().getSalience() instanceof MVELSalienceExpression ? 0 : rtn.getRule().getSalience().getValue(null, rtn.getRule(), wm);
            this.agendaItem = ((InternalAgenda)wm.getAgenda()).createRuleAgendaItem(salience, this, rtn);
        }
        this.queueRuleAgendaItem(wm);
    }

    public void queueRuleAgendaItem(InternalWorkingMemory wm) {
        this.agendaItem.getRuleExecutor().setDirty(true);
        if (!this.agendaItem.isQueued()) {
            InternalRuleFlowGroup rfg = this.agendaItem.getRuleFlowGroup();
            InternalAgendaGroup ag = this.agendaItem.getAgendaGroup();
            if (rfg != null) {
                rfg.addActivation(this.agendaItem);
            } else {
                ag.add(this.agendaItem);
            }
        }
        if (this.agendaItem.getRule().isEager()) {
            ((InternalAgenda)wm.getAgenda()).addEagerRuleAgendaItem(this.agendaItem);
        }
    }

    public void unlinkedSegment(long mask, InternalWorkingMemory wm) {
        if (log.isTraceEnabled()) {
            log.trace("  UnlinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, this});
        }
        if (this.isRuleLinked()) {
            this.doUnlinkRule(wm);
        }
        this.linkedSegmentMask ^= mask;
    }

    public boolean isRuleLinked() {
        return (this.linkedSegmentMask & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    @Override
    public short getNodeType() {
        return 101;
    }

    public SegmentMemory[] getSegmentMemories() {
        return this.segmentMemories;
    }

    public void setSegmentMemories(SegmentMemory[] segmentMemories) {
        this.segmentMemories = segmentMemories;
    }

    @Override
    public SegmentMemory getSegmentMemory() {
        return this.segmentMemory;
    }

    @Override
    public void setSegmentMemory(SegmentMemory sm) {
        this.segmentMemory = sm;
    }

    public String toString() {
        return "[RuleMem " + ((TerminalNode)this.getNetworkNode()).getRule().getName() + "]";
    }
}

