/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.Memory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.RightTupleSets;
import org.drools.core.phreak.RuleNetworkEvaluatorActivation;
import org.drools.core.phreak.SegmentPropagator;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ConditionalBranchEvaluator;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.RiaPathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EvalCondition;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.LeftTupleList;
import org.kie.api.runtime.rule.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleNetworkEvaluator {
    private static final Logger log = LoggerFactory.getLogger(RuleNetworkEvaluator.class);
    private static PhreakJoinNode pJoinNode = new PhreakJoinNode();
    private static PhreakEvalNode pEvalNode = new PhreakEvalNode();
    private static PhreakFromNode pFromNode = new PhreakFromNode();
    private static PhreakNotNode pNotNode = new PhreakNotNode();
    private static PhreakExistsNode pExistsNode = new PhreakExistsNode();
    private static PhreakAccumulateNode pAccNode = new PhreakAccumulateNode();
    private static PhreakBranchNode pBranchNode = new PhreakBranchNode();
    private static PhreakQueryNode pQueryNode = new PhreakQueryNode();
    private static PhreakRuleTerminalNode pRtNode = new PhreakRuleTerminalNode();
    private static int cycle = 0;
    private static PhreakQueryTerminalNode pQtNode = new PhreakQueryTerminalNode();

    public int evaluateNetwork(PathMemory pmem, InternalWorkingMemory wm, RuleNetworkEvaluatorActivation activation) {
        Memory nodeMem;
        NetworkNode node;
        int smemIndex;
        SegmentMemory[] smems = pmem.getSegmentMemories();
        SegmentMemory smem = smems[smemIndex = 0];
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)smem.getRootNode();
        if (liaNode == smem.getTipNode()) {
            smem = smems[++smemIndex];
            node = smem.getRootNode();
            nodeMem = smem.getNodeMemories().getFirst();
        } else {
            node = liaNode.getSinkPropagator().getFirstLeftTupleSink();
            nodeMem = (Memory)smem.getNodeMemories().getFirst().getNext();
        }
        LeftTupleSets srcTuples = smem.getStagedLeftTuples();
        if (log.isTraceEnabled()) {
            log.trace("Rule[name={}] segments={} {}", new Object[]{pmem.getRuleTerminalNode().getRule().getName(), smems.length, srcTuples.toStringSizes()});
        }
        Set<String> visitedRules = pmem.getRuleTerminalNode().getType() == 91 ? new HashSet() : Collections.emptySet();
        LinkedList<StackEntry> stack = new LinkedList<StackEntry>();
        this.eval1(liaNode, pmem, node, nodeMem, smems, smemIndex, srcTuples, wm, stack, visitedRules, true, activation);
        return 0;
    }

    public static String indent(int size) {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sbuilder.append("  ");
        }
        return sbuilder.toString();
    }

    public static int getOffset(NetworkNode node) {
        LeftTupleSource lt = null;
        int offset = 1;
        if (NodeTypeEnums.isTerminalNode(node)) {
            lt = ((TerminalNode)node).getLeftTupleSource();
            ++offset;
        } else {
            lt = node.getType() == 71 ? ((RightInputAdapterNode)node).getLeftTupleSource() : (LeftTupleSource)node;
        }
        while (lt.getType() != 120) {
            ++offset;
            lt = lt.getLeftTupleSource();
        }
        return offset;
    }

    public void eval1(LeftInputAdapterNode liaNode, PathMemory rmem, NetworkNode node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, Set<String> visitedRules, boolean processRian, RuleNetworkEvaluatorActivation activation) {
        while (true) {
            this.eval2(liaNode, rmem, node, nodeMem, smems, smemIndex, trgTuples, wm, stack, visitedRules, processRian, activation);
            if (stack.isEmpty()) break;
            StackEntry entry = stack.removeLast();
            node = entry.getNode();
            nodeMem = entry.getNodeMem();
            trgTuples = entry.getTrgTuples();
            if (node.getType() == 165) {
                trgTuples.addAll(((QueryElementNode.QueryElementNodeMemory)nodeMem).getResultLeftTuples());
            }
            LeftTupleSinkNode sink = entry.getSink();
            rmem = entry.getRmem();
            smems = entry.getSmems();
            smemIndex = entry.getSmemIndex();
            visitedRules = entry.getVisitedRules();
            processRian = !NodeTypeEnums.isBetaNode(node);
            if (entry.isResumeFromNextNode()) {
                SegmentMemory smem = smems[smemIndex];
                if (node != smem.getTipNode()) {
                    LeftTupleSinkNode nextSink = sink.getNextLeftTupleSinkNode();
                    node = nextSink == null ? sink : nextSink;
                    nodeMem = (Memory)nodeMem.getNext();
                } else {
                    SegmentPropagator.propagate(smem, trgTuples, wm);
                    smem = smems[++smemIndex];
                    trgTuples = smem.getStagedLeftTuples();
                    node = (LeftTupleSink)smem.getRootNode();
                    nodeMem = smem.getNodeMemories().getFirst();
                }
            }
            if (!log.isTraceEnabled()) continue;
            int offset = RuleNetworkEvaluator.getOffset(node);
            log.trace("{} Resume {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), node.toString(), trgTuples.toStringSizes()});
        }
    }

    public void eval2(LeftInputAdapterNode liaNode, PathMemory rmem, NetworkNode node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, InternalWorkingMemory wm, LinkedList<StackEntry> stack, Set<String> visitedRules, boolean processRian, RuleNetworkEvaluatorActivation activation) {
        SegmentMemory smem = smems[smemIndex];
        block12: while (true) {
            LeftTupleSets srcTuples = trgTuples;
            if (log.isTraceEnabled()) {
                int offset = RuleNetworkEvaluator.getOffset(node);
                log.trace("{} {} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), ++cycle, node.toString(), srcTuples.toStringSizes()});
            }
            if (NodeTypeEnums.isTerminalNode(node)) {
                TerminalNode rtn = rmem.getRuleTerminalNode();
                if (node.getType() == 91) {
                    pQtNode.doNode((QueryTerminalNode)rtn, wm, srcTuples, stack);
                } else {
                    pRtNode.doNode(rtn, wm, srcTuples, activation);
                }
                return;
            }
            if (71 == node.getType()) {
                this.doRiaNode2(wm, srcTuples, (RightInputAdapterNode)node, stack);
                return;
            }
            LeftTupleSets stagedLeftTuples = node == smem.getTipNode() && smem.getFirst() != null ? ((SegmentMemory)smem.getFirst()).getStagedLeftTuples() : null;
            LeftTupleSinkNode sink = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink();
            trgTuples = new LeftTupleSets();
            if (NodeTypeEnums.isBetaNode(node)) {
                BetaNode betaNode = (BetaNode)node;
                BetaMemory bm = null;
                AccumulateNode.AccumulateMemory am = null;
                if (211 == node.getType()) {
                    am = (AccumulateNode.AccumulateMemory)nodeMem;
                    bm = am.getBetaMemory();
                } else {
                    bm = (BetaMemory)nodeMem;
                }
                if (processRian && betaNode.isRightInputIsRiaNode()) {
                    this.doRiaNode(wm, liaNode, rmem, srcTuples, betaNode, sink, smems, smemIndex, nodeMem, bm, stack, visitedRules, activation);
                    return;
                }
                switch (node.getType()) {
                    case 181: {
                        pJoinNode.doNode((JoinNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 191: {
                        pNotNode.doNode((NotNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 201: {
                        pExistsNode.doNode((ExistsNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 211: {
                        pAccNode.doNode((AccumulateNode)node, sink, am, wm, srcTuples, trgTuples, stagedLeftTuples);
                    }
                }
            } else {
                switch (node.getType()) {
                    case 131: {
                        pEvalNode.doNode((EvalConditionNode)node, (EvalConditionNode.EvalMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 151: {
                        pFromNode.doNode((FromNode)node, (FromNode.FromMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 165: {
                        QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)nodeMem;
                        if (srcTuples.isEmpty() && qmem.getResultLeftTuples().isEmpty()) break;
                        QueryElementNode qnode = (QueryElementNode)node;
                        if (visitedRules == Collections.emptySet()) {
                            visitedRules = new HashSet<String>();
                        }
                        visitedRules.add(qnode.getQueryElement().getQueryName());
                        trgTuples.addAll(qmem.getResultLeftTuples());
                        if (srcTuples.isEmpty()) break;
                        StackEntry stackEntry = new StackEntry(liaNode, node, sink, rmem, nodeMem, smems, smemIndex, trgTuples, visitedRules, true);
                        stack.add(stackEntry);
                        pQueryNode.doNode(qnode, (QueryElementNode.QueryElementNodeMemory)nodeMem, stackEntry, sink, wm, srcTuples);
                        SegmentMemory qsmem = ((QueryElementNode.QueryElementNodeMemory)nodeMem).getQuerySegmentMemory();
                        List<PathMemory> qrmems = qsmem.getPathMemories();
                        for (int i = qrmems.size() - 1; i >= 0; --i) {
                            PathMemory qrmem;
                            rmem = qrmem = qrmems.get(i);
                            smems = qrmem.getSegmentMemories();
                            smem = smems[smemIndex = 0];
                            liaNode = (LeftInputAdapterNode)smem.getRootNode();
                            if (liaNode == smem.getTipNode()) {
                                smem = smems[++smemIndex];
                                node = smem.getRootNode();
                                nodeMem = smem.getNodeMemories().getFirst();
                            } else {
                                node = liaNode.getSinkPropagator().getFirstLeftTupleSink();
                                nodeMem = (Memory)smem.getNodeMemories().getFirst().getNext();
                            }
                            trgTuples = smem.getStagedLeftTuples();
                            if (i == 0 || trgTuples.isEmpty()) continue;
                            stackEntry = new StackEntry(liaNode, node, null, rmem, nodeMem, smems, smemIndex, trgTuples, visitedRules, false);
                            if (log.isTraceEnabled()) {
                                int offset = RuleNetworkEvaluator.getOffset(stackEntry.getNode());
                                log.trace("{} ORQueue branch={} {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), i, stackEntry.getNode().toString(), trgTuples.toStringSizes()});
                            }
                            stack.add(stackEntry);
                        }
                        processRian = true;
                        continue block12;
                    }
                    case 167: {
                        pBranchNode.doNode((ConditionalBranchNode)node, (ConditionalBranchNode.ConditionalBranchMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples, activation);
                    }
                }
            }
            if (node != smem.getTipNode()) {
                LeftTupleSinkNode nextSink = sink.getNextLeftTupleSinkNode();
                node = nextSink == null ? sink : nextSink;
                nodeMem = (Memory)nodeMem.getNext();
            } else {
                SegmentPropagator.propagate(smem, trgTuples, wm);
                smem = smems[++smemIndex];
                trgTuples = smem.getStagedLeftTuples();
                if (log.isTraceEnabled()) {
                    log.trace("Segment {}", (Object)smemIndex);
                }
                node = (LeftTupleSink)smem.getRootNode();
                nodeMem = smem.getNodeMemories().getFirst();
            }
            processRian = true;
        }
    }

    private void doRiaNode(InternalWorkingMemory wm, LeftInputAdapterNode liaNode, PathMemory rmem, LeftTupleSets srcTuples, BetaNode betaNode, LeftTupleSinkNode sink, SegmentMemory[] smems, int smemIndex, Memory nodeMem, BetaMemory bm, LinkedList<StackEntry> stack, Set<String> visitedRules, RuleNetworkEvaluatorActivation activation) {
        RiaPathMemory pathMem = bm.getRiaRuleMemory();
        SegmentMemory[] subnetworkSmems = pathMem.getSegmentMemories();
        SegmentMemory subSmem = null;
        int i = 0;
        while (subSmem == null) {
            subSmem = subnetworkSmems[i];
            ++i;
        }
        StackEntry stackEntry = new StackEntry(liaNode, betaNode, sink, rmem, nodeMem, smems, smemIndex, srcTuples, visitedRules, false);
        stack.add(stackEntry);
        if (log.isTraceEnabled()) {
            int offset = RuleNetworkEvaluator.getOffset(betaNode);
            log.trace("{} RiaQueue {} {}", new Object[]{RuleNetworkEvaluator.indent(offset), betaNode.toString(), srcTuples.toStringSizes()});
        }
        this.eval2(liaNode, pathMem, (LeftTupleSink)subSmem.getRootNode(), subSmem.getNodeMemories().getFirst(), subnetworkSmems, subSmem.getPos(), subSmem.getStagedLeftTuples(), wm, stack, visitedRules, true, activation);
    }

    private void doRiaNode2(InternalWorkingMemory wm, LeftTupleSets srcTuples, RightInputAdapterNode riaNode, LinkedList<StackEntry> stack) {
        RightTupleSets rightTuples;
        RightTuple rightTuple;
        LeftTuple next;
        ObjectSink[] sinks = riaNode.getSinkPropagator().getSinks();
        BetaNode betaNode = (BetaNode)sinks[0];
        Memory nodeMem = wm.getNodeMemory(betaNode);
        BetaMemory bm = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)nodeMem).getBetaMemory() : (BetaMemory)nodeMem;
        BetaNode[] bns = null;
        BetaMemory[] bms = null;
        int length = sinks.length;
        if (length > 1) {
            bns = new BetaNode[sinks.length - 1];
            bms = new BetaMemory[sinks.length - 1];
            for (int i = 1; i < length; ++i) {
                bns[i - 1] = (BetaNode)sinks[i];
                Memory nodeMem2 = wm.getNodeMemory(bns[i - 1]);
                bms[i - 1] = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)nodeMem2).getBetaMemory() : (BetaMemory)nodeMem2;
            }
        }
        --length;
        LeftTuple leftTuple = srcTuples.getInsertFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            PropagationContext pctx = leftTuple.getPropagationContext();
            InternalFactHandle handle = riaNode.createFactHandle(leftTuple, pctx, wm);
            RightTuple rightTuple2 = new RightTuple(handle, betaNode);
            leftTuple.setObject(rightTuple2);
            rightTuple2.setPropagationContext(pctx);
            bm.getStagedRightTuples().addInsert(rightTuple2);
            if (bns != null) {
                for (int i = 0; i < length; ++i) {
                    rightTuple2 = new RightTuple(handle, bns[i]);
                    rightTuple2.setPropagationContext(pctx);
                    bms[i].getStagedRightTuples().addInsert(rightTuple2);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = srcTuples.getDeleteFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            rightTuple = (RightTuple)leftTuple.getObject();
            rightTuples = bm.getStagedRightTuples();
            switch (rightTuple.getStagedType()) {
                case 1: {
                    rightTuples.removeInsert(rightTuple);
                    break;
                }
                case 2: {
                    rightTuples.removeUpdate(rightTuple);
                }
            }
            rightTuples.addDelete(rightTuple);
            if (bns != null) {
                for (int i = 0; i < length; ++i) {
                    rightTuple = rightTuple.getHandleNext();
                    rightTuples = bms[i].getStagedRightTuples();
                    switch (rightTuple.getStagedType()) {
                        case 1: {
                            rightTuples.removeInsert(rightTuple);
                            break;
                        }
                        case 2: {
                            rightTuples.removeUpdate(rightTuple);
                        }
                    }
                    rightTuples.addDelete(rightTuple);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = srcTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            rightTuple = (RightTuple)leftTuple.getObject();
            rightTuples = bm.getStagedRightTuples();
            switch (rightTuple.getStagedType()) {
                case 1: {
                    rightTuples.removeInsert(rightTuple);
                    break;
                }
                case 2: {
                    rightTuples.removeUpdate(rightTuple);
                }
            }
            rightTuples.addUpdate(rightTuple);
            if (bns != null) {
                for (int i = 0; i < length; ++i) {
                    rightTuple = rightTuple.getHandleNext();
                    rightTuples = bms[i].getStagedRightTuples();
                    switch (rightTuple.getStagedType()) {
                        case 1: {
                            rightTuples.removeInsert(rightTuple);
                            break;
                        }
                        case 2: {
                            rightTuples.removeUpdate(rightTuple);
                        }
                    }
                    rightTuples.addUpdate(rightTuple);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        srcTuples.resetAll();
    }

    public boolean isRuleNetworkEvaluatorActivation() {
        return true;
    }

    private static void findLeftTupleBlocker(BetaNode betaNode, RightTupleMemory rtm, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTuple leftTuple, FastIterator it, PropagationContext context, boolean useLeftMemory) {
        RightTuple rightTuple = betaNode.getFirstRightTuple(leftTuple, rtm, null, it);
        while (rightTuple != null) {
            RightTuple nextRight = (RightTuple)it.next(rightTuple);
            if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                leftTuple.setBlocker(rightTuple);
                if (useLeftMemory) {
                    rightTuple.addBlocked(leftTuple);
                    break;
                }
                if (!betaNode.isRightInputIsRiaNode()) break;
                rtm.remove(rightTuple);
            }
            rightTuple = nextRight;
        }
    }

    public static LeftTuple deleteLeftChild(LeftTuple childLeftTuple, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
            }
        }
        LeftTuple next = childLeftTuple.getLeftParentNext();
        trgLeftTuples.addDelete(childLeftTuple);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return next;
    }

    public static LeftTuple deleteRightChild(LeftTuple childLeftTuple, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
            }
        }
        LeftTuple next = childLeftTuple.getRightParentNext();
        trgLeftTuples.addDelete(childLeftTuple);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return next;
    }

    public static void dpUpdatesReorderLeftMemory(BetaMemory bm, LeftTupleSets srcLeftTuples) {
        LeftTuple next;
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            ltm.remove(leftTuple);
            leftTuple = next;
        }
        leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            ltm.add(leftTuple);
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                LeftTuple childNext = childLeftTuple.getLeftParentNext();
                childLeftTuple.reAddRight();
                childLeftTuple = childNext;
            }
            leftTuple = next;
        }
    }

    public static void dpUpdatesExistentialReorderLeftMemory(BetaMemory bm, LeftTupleSets srcLeftTuples) {
        LeftTuple next;
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            if (leftTuple.getMemory() != null) {
                ltm.remove(leftTuple);
            }
            leftTuple = next;
        }
        leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            if (leftTuple.getBlocker() == null) {
                ltm.add(leftTuple);
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getLeftParentNext();
                    childLeftTuple.reAddRight();
                    childLeftTuple = childNext;
                }
            }
            leftTuple = next;
        }
    }

    public static void dpUpdatesReorderRightMemory(BetaMemory bm, RightTupleSets srcRightTuples) {
        RightTuple next;
        RightTupleMemory rtm = bm.getRightTupleMemory();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rightTuple.setTempRightTupleMemory(rightTuple.getMemory());
                rtm.remove(rightTuple);
            }
            rightTuple = next;
        }
        rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getTempRightTupleMemory() != null) {
                rtm.add(rightTuple);
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getRightParentNext();
                    childLeftTuple.reAddLeft();
                    childLeftTuple = childNext;
                }
            }
            rightTuple = next;
        }
    }

    public static void dpUpdatesExistentialReorderRightMemory(BetaMemory bm, BetaNode betaNode, RightTupleSets srcRightTuples) {
        RightTuple tempRightTuple;
        RightTuple next;
        RightTupleMemory rtm = bm.getRightTupleMemory();
        boolean resumeFromCurrent = !betaNode.isIndexedUnificationJoin() && !rtm.getIndexType().isComparison();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                if (resumeFromCurrent) {
                    rightTuple.setTempRightTupleMemory(rightTuple.getMemory());
                    if (rightTuple.getBlocked() != null) {
                        for (tempRightTuple = (RightTuple)rightTuple.getNext(); tempRightTuple != null && tempRightTuple.getStagedType() != 0; tempRightTuple = (RightTuple)tempRightTuple.getNext()) {
                        }
                        if (tempRightTuple == null) {
                            for (tempRightTuple = (RightTuple)rightTuple.getPrevious(); tempRightTuple != null && tempRightTuple.getStagedType() != 0; tempRightTuple = (RightTuple)tempRightTuple.getPrevious()) {
                            }
                        }
                        rightTuple.setTempNextRightTuple(tempRightTuple);
                    }
                }
                rightTuple.setTempBlocked(rightTuple.getBlocked());
                rightTuple.nullBlocked();
                rtm.remove(rightTuple);
            }
            rightTuple = next;
        }
        rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            if (rightTuple.getTempRightTupleMemory() != null) {
                rtm.add(rightTuple);
                if (resumeFromCurrent) {
                    tempRightTuple = rightTuple.getTempNextRightTuple();
                    if (rightTuple.getBlocked() != null && tempRightTuple == null && rightTuple.getMemory() == rightTuple.getTempRightTupleMemory()) {
                        rightTuple.setTempNextRightTuple(rightTuple);
                    }
                }
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getRightParentNext();
                    childLeftTuple.reAddLeft();
                    childLeftTuple = childNext;
                }
            }
            rightTuple = next;
        }
    }

    public static boolean useLeftMemory(LeftTupleSource tupleSource, LeftTuple leftTuple) {
        Object object;
        boolean useLeftMemory = true;
        if (!(tupleSource.isLeftTupleMemoryEnabled() || (object = leftTuple.getRootLeftTuple().getLastHandle().getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        return useLeftMemory;
    }

    public static class PhreakQueryTerminalNode {
        public void doNode(QueryTerminalNode qtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LinkedList<StackEntry> stack) {
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(qtnNode, wm, srcLeftTuples, stack);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(qtnNode, wm, srcLeftTuples, stack);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(qtnNode, wm, srcLeftTuples, stack);
            }
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(QueryTerminalNode qtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LinkedList<StackEntry> stack) {
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext pCtx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, leftTuple.getPropagationContext());
                LeftTuple rootEntry = leftTuple.getRootLeftTuple();
                DroolsQuery dquery = (DroolsQuery)rootEntry.getLastHandle().getObject();
                dquery.setQuery(qtnNode.getQuery());
                if (dquery.getStackEntry() != null) {
                    PhreakQueryTerminalNode.checkAndTriggerQueryReevaluation(wm, stack, rootEntry, dquery);
                }
                dquery.getQueryResultCollector().rowAdded(qtnNode.getQuery(), leftTuple, pCtx, wm);
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftUpdates(QueryTerminalNode qtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LinkedList<StackEntry> stack) {
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext pCtx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, leftTuple.getPropagationContext());
                LeftTuple rootEntry = leftTuple;
                while (rootEntry.getParent() != null) {
                    rootEntry = rootEntry.getParent();
                }
                DroolsQuery dquery = (DroolsQuery)rootEntry.getLastHandle().getObject();
                dquery.setQuery(qtnNode.getQuery());
                if (dquery.getStackEntry() != null) {
                    PhreakQueryTerminalNode.checkAndTriggerQueryReevaluation(wm, stack, rootEntry, dquery);
                }
                dquery.getQueryResultCollector().rowUpdated(qtnNode.getQuery(), leftTuple, pCtx, wm);
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftDeletes(QueryTerminalNode qtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LinkedList<StackEntry> stack) {
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext pCtx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, leftTuple.getPropagationContext());
                LeftTuple rootEntry = leftTuple;
                while (rootEntry.getParent() != null) {
                    rootEntry = rootEntry.getParent();
                }
                DroolsQuery dquery = (DroolsQuery)rootEntry.getLastHandle().getObject();
                dquery.setQuery(qtnNode.getQuery());
                if (dquery.getStackEntry() != null) {
                    PhreakQueryTerminalNode.checkAndTriggerQueryReevaluation(wm, stack, rootEntry, dquery);
                }
                dquery.getQueryResultCollector().rowRemoved(qtnNode.getQuery(), leftTuple, pCtx, wm);
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public static void checkAndTriggerQueryReevaluation(InternalWorkingMemory wm, LinkedList<StackEntry> stack, LeftTuple rootEntry, DroolsQuery dquery) {
            StackEntry stackEntry = dquery.getStackEntry();
            if (!PhreakQueryTerminalNode.isAdded(stack, stackEntry)) {
                if (stackEntry.getLiaNode() == rootEntry.getLeftTupleSink().getLeftTupleSource()) {
                    stack.add(stackEntry);
                } else {
                    List<PathMemory> rmems = dquery.getRuleMemories();
                    if (rmems != null) {
                        int length = rmems.size();
                        for (int i = 0; i < length; ++i) {
                            PathMemory rmem = rmems.get(i);
                            rmem.doLinkRule(wm);
                        }
                    }
                }
            }
        }

        public static boolean isAdded(LinkedList<StackEntry> stack, StackEntry stackEntry) {
            return stackEntry == null || stackEntry.getPrevious() != null || stackEntry.getNext() != null || stack.getFirst() == stackEntry;
        }
    }

    public static class PhreakRuleTerminalNode {
        public void doNode(TerminalNode rtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, RuleNetworkEvaluatorActivation activation) {
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(rtnNode, wm, srcLeftTuples, activation);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(rtnNode, wm, srcLeftTuples, activation);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(rtnNode, wm, srcLeftTuples, activation);
            }
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(TerminalNode rtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, RuleNetworkEvaluatorActivation ruleNetworkEvaluatorActivation) {
            boolean declarativeAgendaEnabled = ruleNetworkEvaluatorActivation.isDeclarativeAgendaEnabled();
            InternalAgenda agenda = (InternalAgenda)wm.getAgenda();
            int salience = 0;
            if (declarativeAgendaEnabled && rtnNode.getType() == 101) {
                salience = rtnNode.getRule().getSalience().getValue(null, null, null);
            }
            LeftTupleList tupleList = ruleNetworkEvaluatorActivation.getLeftTupleList();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                tupleList.add(leftTuple);
                leftTuple.increaseActivationCountForEvents();
                if (declarativeAgendaEnabled) {
                    PropagationContext pctx = leftTuple.getPropagationContext();
                    AgendaItem item = agenda.createAgendaItem(leftTuple, salience, pctx, rtnNode, ruleNetworkEvaluatorActivation);
                    item.setActivated(true);
                    leftTuple.setObject(item);
                    agenda.insertAndStageActivation(item);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftUpdates(TerminalNode rtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, RuleNetworkEvaluatorActivation ruleNetworkEvaluatorActivation) {
            boolean declarativeAgendaEnabled = ruleNetworkEvaluatorActivation.isDeclarativeAgendaEnabled();
            InternalAgenda agenda = (InternalAgenda)wm.getAgenda();
            LeftTupleList tupleList = ruleNetworkEvaluatorActivation.getLeftTupleList();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                boolean reAdd = true;
                AgendaItem item = null;
                if (declarativeAgendaEnabled && leftTuple.getObject() != null && (item = (AgendaItem)leftTuple.getObject()).getBlockers() != null && !item.getBlockers().isEmpty()) {
                    reAdd = false;
                }
                if (reAdd && leftTuple.getMemory() == null) {
                    tupleList.add(leftTuple);
                }
                if (declarativeAgendaEnabled) {
                    agenda.modifyActivation(item, item.isActive());
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftDeletes(TerminalNode rtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, RuleNetworkEvaluatorActivation activation) {
            LeftTupleList tupleList = activation.getLeftTupleList();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                if (leftTuple.getMemory() != null) {
                    tupleList.remove(leftTuple);
                }
                rtnNode.retractLeftTuple(leftTuple, leftTuple.getPropagationContext(), wm);
                leftTuple.clearStaged();
                leftTuple.setObject(null);
                leftTuple = next;
            }
        }
    }

    public static class PhreakFromNode {
        public void doNode(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(fromNode, fm, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(fromNode, fm, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(fromNode, fm, sink, wm, srcLeftTuples, trgLeftTuples);
            }
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            BetaMemory bm = fm.getBetaMemory();
            ContextEntry[] context = bm.getContext();
            BetaConstraints betaConstraints = fromNode.getBetaConstraints();
            AlphaNodeFieldConstraint[] alphaConstraints = fromNode.getAlphaConstraints();
            DataProvider dataProvider = fromNode.getDataProvider();
            Class<?> resultClass = fromNode.getResultClass();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext propagationContext = leftTuple.getPropagationContext();
                LinkedHashMap<Object, RightTuple> matches = null;
                boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(fromNode, leftTuple);
                if (useLeftMemory) {
                    fm.betaMemory.getLeftTupleMemory().add(leftTuple);
                    matches = new LinkedHashMap<Object, RightTuple>();
                    leftTuple.setObject(matches);
                }
                betaConstraints.updateFromTuple(context, wm, leftTuple);
                Iterator it = dataProvider.getResults(leftTuple, wm, propagationContext, fm.providerContext);
                while (it.hasNext()) {
                    Object object = it.next();
                    if (object == null || !resultClass.isAssignableFrom(object.getClass())) continue;
                    RightTuple rightTuple = fromNode.createRightTuple(leftTuple, propagationContext, wm, object);
                    this.checkConstraintsAndPropagate(sink, leftTuple, rightTuple, alphaConstraints, betaConstraints, propagationContext, wm, fm, bm, context, useLeftMemory, trgLeftTuples, null);
                    if (!useLeftMemory) continue;
                    fromNode.addToCreatedHandlesMap(matches, rightTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            betaConstraints.resetTuple(context);
        }

        public void doLeftUpdates(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            BetaMemory bm = fm.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] context = bm.getContext();
            BetaConstraints betaConstraints = fromNode.getBetaConstraints();
            AlphaNodeFieldConstraint[] alphaConstraints = fromNode.getAlphaConstraints();
            DataProvider dataProvider = fromNode.getDataProvider();
            Class<?> resultClass = fromNode.getResultClass();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext propagationContext = leftTuple.getPropagationContext();
                Map previousMatches = (Map)leftTuple.getObject();
                HashMap<Object, RightTuple> newMatches = new HashMap<Object, RightTuple>();
                leftTuple.setObject(newMatches);
                betaConstraints.updateFromTuple(context, wm, leftTuple);
                FastIterator rightIt = LinkedList.fastIterator;
                Iterator it = dataProvider.getResults(leftTuple, wm, propagationContext, fm.providerContext);
                while (it.hasNext()) {
                    Object object = it.next();
                    if (object == null || !resultClass.isAssignableFrom(object.getClass())) continue;
                    RightTuple rightTuple = (RightTuple)previousMatches.remove(object);
                    if (rightTuple == null) {
                        rightTuple = fromNode.createRightTuple(leftTuple, propagationContext, wm, object);
                    } else if (rightIt.next(rightTuple) != null) {
                        previousMatches.put(object, (RightTuple)rightIt.next(rightTuple));
                        rightTuple.setNext(null);
                    }
                    this.checkConstraintsAndPropagate(sink, leftTuple, rightTuple, alphaConstraints, betaConstraints, propagationContext, wm, fm, bm, context, true, trgLeftTuples, null);
                    fromNode.addToCreatedHandlesMap(newMatches, rightTuple);
                }
                Iterator i$ = previousMatches.values().iterator();
                while (i$.hasNext()) {
                    RightTuple rightTuple;
                    RightTuple current = rightTuple = (RightTuple)i$.next();
                    while (current != null) {
                        LeftTuple childLeftTuple = current.getFirstChild();
                        childLeftTuple.unlinkFromLeftParent();
                        childLeftTuple.unlinkFromRightParent();
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        childLeftTuple.setPropagationContext(propagationContext);
                        trgLeftTuples.addDelete(childLeftTuple);
                        current = (RightTuple)rightIt.next(current);
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            betaConstraints.resetTuple(context);
        }

        public void doLeftDeletes(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            BetaMemory bm = fm.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                ltm.remove(leftTuple);
                Map matches = (Map)leftTuple.getObject();
                if (leftTuple.getFirstChild() != null) {
                    LeftTuple childLeftTuple = leftTuple.getFirstChild();
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                PhreakFromNode.unlinkCreatedHandles(leftTuple);
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public static void unlinkCreatedHandles(LeftTuple leftTuple) {
            Map matches = (Map)leftTuple.getObject();
            FastIterator rightIt = LinkedList.fastIterator;
            Iterator i$ = matches.values().iterator();
            while (i$.hasNext()) {
                RightTuple rightTuple;
                RightTuple current = rightTuple = (RightTuple)i$.next();
                while (current != null) {
                    RightTuple next = (RightTuple)rightIt.next(current);
                    current.unlinkFromRightParent();
                    current = next;
                }
            }
        }

        protected void checkConstraintsAndPropagate(LeftTupleSink sink, LeftTuple leftTuple, RightTuple rightTuple, AlphaNodeFieldConstraint[] alphaConstraints, BetaConstraints betaConstraints, PropagationContext propagationContext, InternalWorkingMemory wm, FromNode.FromMemory fm, BetaMemory bm, ContextEntry[] context, boolean useLeftMemory, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean isAllowed = true;
            if (alphaConstraints != null) {
                int length = alphaConstraints.length;
                for (int i = 0; i < length; ++i) {
                    if (alphaConstraints[i].isAllowed(rightTuple.getFactHandle(), wm, fm.alphaContexts[i])) continue;
                    isAllowed = false;
                    break;
                }
            }
            if (isAllowed && betaConstraints.isAllowedCachedLeft(context, rightTuple.getFactHandle())) {
                if (rightTuple.firstChild == null) {
                    LeftTuple childLeftTuple = sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, useLeftMemory);
                    childLeftTuple.setPropagationContext(propagationContext);
                    trgLeftTuples.addInsert(childLeftTuple);
                } else {
                    LeftTuple childLeftTuple = rightTuple.firstChild;
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    childLeftTuple.setPropagationContext(propagationContext);
                    trgLeftTuples.addUpdate(childLeftTuple);
                }
            } else {
                LeftTuple childLeftTuple = rightTuple.firstChild;
                if (childLeftTuple != null) {
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    childLeftTuple.setPropagationContext(propagationContext);
                    trgLeftTuples.addDelete(childLeftTuple);
                }
            }
        }
    }

    public static class PhreakBranchNode {
        public void doNode(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples, RuleNetworkEvaluatorActivation activation) {
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(branchNode, cbm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples, activation);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(branchNode, cbm, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples, activation);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(branchNode, cbm, sink, wm, srcLeftTuples, trgLeftTuples, activation);
            }
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, RuleNetworkEvaluatorActivation activation) {
            ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
            LeftTupleList tupleList = activation.getLeftTupleList();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                boolean breaking = false;
                ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, wm, cbm.context);
                boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(branchNode, leftTuple);
                if (conditionalExecution != null) {
                    RuleTerminalNode rtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                    LeftTuple branchedLeftTuple = rtn.createLeftTuple(leftTuple, rtn, leftTuple.getPropagationContext(), useLeftMemory);
                    leftTuple.setObject(branchedLeftTuple);
                    tupleList.add(branchedLeftTuple);
                    breaking = conditionalExecution.isBreaking();
                }
                if (!breaking) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useLeftMemory));
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftUpdates(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples, RuleNetworkEvaluatorActivation activation) {
            ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
            LeftTupleList tupleList = activation.getLeftTupleList();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                LeftTuple rtnLeftTuple = (LeftTuple)leftTuple.getObject();
                LeftTuple mainLeftTuple = leftTuple.getFirstChild();
                RuleTerminalNode oldRtn = null;
                if (rtnLeftTuple != null) {
                    oldRtn = (RuleTerminalNode)rtnLeftTuple.getSink();
                }
                ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, wm, cbm.context);
                RuleTerminalNode newRtn = null;
                boolean breaking = false;
                if (conditionalExecution != null) {
                    newRtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                    breaking = conditionalExecution.isBreaking();
                }
                if (oldRtn != null) {
                    if (newRtn == null) {
                        if (rtnLeftTuple.getMemory() != null) {
                            tupleList.remove(rtnLeftTuple);
                        }
                        oldRtn.retractLeftTuple(rtnLeftTuple, rtnLeftTuple.getPropagationContext(), wm);
                    } else if (newRtn == oldRtn) {
                        if (rtnLeftTuple.getMemory() != null) {
                            tupleList.remove(rtnLeftTuple);
                        }
                        tupleList.add(rtnLeftTuple);
                    } else {
                        if (rtnLeftTuple.getMemory() != null) {
                            tupleList.remove(rtnLeftTuple);
                        }
                        oldRtn.retractLeftTuple(rtnLeftTuple, rtnLeftTuple.getPropagationContext(), wm);
                        rtnLeftTuple = newRtn.createLeftTuple(leftTuple, newRtn, leftTuple.getPropagationContext(), true);
                        leftTuple.setObject(rtnLeftTuple);
                        tupleList.add(rtnLeftTuple);
                    }
                } else if (newRtn != null) {
                    rtnLeftTuple = newRtn.createLeftTuple(leftTuple, newRtn, leftTuple.getPropagationContext(), true);
                    leftTuple.setObject(rtnLeftTuple);
                    tupleList.add(rtnLeftTuple);
                }
                if (mainLeftTuple != null) {
                    switch (mainLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(mainLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(mainLeftTuple);
                        }
                    }
                    if (!breaking) {
                        trgLeftTuples.addUpdate(mainLeftTuple);
                    } else {
                        trgLeftTuples.addDelete(mainLeftTuple);
                    }
                } else if (!breaking) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true));
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftDeletes(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples, RuleNetworkEvaluatorActivation activation) {
            LeftTupleList tupleList = activation.getLeftTupleList();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                LeftTuple rtnLeftTuple = (LeftTuple)leftTuple.getObject();
                LeftTuple mainLeftTuple = leftTuple.getFirstChild();
                if (rtnLeftTuple != null) {
                    RuleTerminalNode rtn = (RuleTerminalNode)rtnLeftTuple.getSink();
                    if (rtnLeftTuple.getMemory() != null) {
                        tupleList.remove(rtnLeftTuple);
                    }
                    rtn.retractLeftTuple(rtnLeftTuple, rtnLeftTuple.getPropagationContext(), wm);
                }
                if (mainLeftTuple != null) {
                    switch (mainLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(mainLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(mainLeftTuple);
                        }
                    }
                    trgLeftTuples.addDelete(mainLeftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }
    }

    public static class PhreakQueryNode {
        public void doNode(QueryElementNode queryNode, QueryElementNode.QueryElementNodeMemory qmem, StackEntry stackEntry, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples) {
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(qmem, wm, srcLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(queryNode, qmem, sink, wm, srcLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(queryNode, qmem, stackEntry, wm, srcLeftTuples);
            }
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(QueryElementNode queryNode, QueryElementNode.QueryElementNodeMemory qmem, StackEntry stackEntry, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext pCtx = leftTuple.getPropagationContext();
                InternalFactHandle handle = queryNode.createFactHandle(pCtx, wm, leftTuple);
                DroolsQuery dquery = queryNode.createDroolsQuery(leftTuple, handle, stackEntry, qmem.getSegmentMemory().getPathMemories(), qmem.getResultLeftTuples(), stackEntry.getSink(), wm);
                LeftInputAdapterNode lian = (LeftInputAdapterNode)qmem.getQuerySegmentMemory().getRootNode();
                LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)qmem.getQuerySegmentMemory().getNodeMemories().get(0);
                LeftInputAdapterNode.doInsertObject(handle, pCtx, lian, wm, lm, false, dquery.isOpen());
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftUpdates(QueryElementNode queryNode, QueryElementNode.QueryElementNodeMemory qmem, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                InternalFactHandle fh = (InternalFactHandle)leftTuple.getObject();
                DroolsQuery dquery = (DroolsQuery)fh.getObject();
                Object[] argTemplate = queryNode.getQueryElement().getArgTemplate();
                Object[] args = new Object[argTemplate.length];
                System.arraycopy(argTemplate, 0, args, 0, args.length);
                int[] declIndexes = queryNode.getQueryElement().getDeclIndexes();
                int length = declIndexes.length;
                for (int i = 0; i < length; ++i) {
                    Object o;
                    Declaration declr = (Declaration)argTemplate[declIndexes[i]];
                    Object tupleObject = leftTuple.get(declr).getObject();
                    if (tupleObject instanceof DroolsQuery) {
                        ArrayElementReader arrayReader = (ArrayElementReader)declr.getExtractor();
                        o = ((DroolsQuery)tupleObject).getVariables()[arrayReader.getIndex()] != null ? Variable.v : declr.getValue(wm, tupleObject);
                    } else {
                        o = declr.getValue(wm, tupleObject);
                    }
                    args[declIndexes[i]] = o;
                }
                int[] varIndexes = queryNode.getQueryElement().getVariableIndexes();
                int length2 = varIndexes.length;
                for (int i = 0; i < length2; ++i) {
                    if (argTemplate[varIndexes[i]] != Variable.v) continue;
                    args[varIndexes[i]] = Variable.v;
                }
                dquery.setParameters(args);
                ((QueryElementNode.UnificationNodeViewChangedEventListener)dquery.getQueryResultCollector()).setVariables(varIndexes);
                LeftInputAdapterNode lian = (LeftInputAdapterNode)qmem.getQuerySegmentMemory().getRootNode();
                if (dquery.isOpen()) {
                    LeftTuple childLeftTuple = fh.getFirstLeftTuple();
                    LeftInputAdapterNode.doUpdateObject(childLeftTuple, childLeftTuple.getPropagationContext(), wm, lian, false, qmem.getQuerySegmentMemory());
                } else {
                    if (fh.getFirstLeftTuple() != null) {
                        throw new RuntimeException("defensive programming while testing");
                    }
                    LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)qmem.getQuerySegmentMemory().getNodeMemories().get(0);
                    LeftInputAdapterNode.doInsertObject(fh, leftTuple.getPropagationContext(), lian, wm, lm, false, dquery.isOpen());
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftDeletes(QueryElementNode.QueryElementNodeMemory qmem, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                InternalFactHandle fh = (InternalFactHandle)leftTuple.getObject();
                DroolsQuery dquery = (DroolsQuery)fh.getObject();
                if (dquery.isOpen()) {
                    LeftInputAdapterNode lian = (LeftInputAdapterNode)qmem.getQuerySegmentMemory().getRootNode();
                    LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)qmem.getQuerySegmentMemory().getNodeMemories().get(0);
                    LeftTuple childLeftTuple = fh.getFirstLeftTuple();
                    LeftInputAdapterNode.doDeleteObject(childLeftTuple, childLeftTuple.getPropagationContext(), qmem.getQuerySegmentMemory(), wm, lian, false, lm);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }
    }

    public static class PhreakEvalNode {
        public void doNode(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(evalNode, em, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(evalNode, em, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(evalNode, em, sink, wm, srcLeftTuples, trgLeftTuples);
            }
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            EvalCondition condition = evalNode.getCondition();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                boolean allowed = condition.isAllowed(leftTuple, wm, em.context);
                if (allowed) {
                    boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(evalNode, leftTuple);
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useLeftMemory));
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftUpdates(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            EvalCondition condition = evalNode.getCondition();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple childLeftTuple;
                LeftTuple next = leftTuple.getStagedNext();
                boolean wasPropagated = leftTuple.getFirstChild() != null;
                boolean allowed = condition.isAllowed(leftTuple, wm, em.context);
                if (allowed) {
                    if (wasPropagated) {
                        childLeftTuple = leftTuple.getFirstChild();
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        trgLeftTuples.addUpdate(childLeftTuple);
                    } else {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true));
                    }
                } else if (wasPropagated) {
                    childLeftTuple = leftTuple.getFirstChild();
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    trgLeftTuples.addDelete(childLeftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftDeletes(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                if (childLeftTuple != null) {
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    trgLeftTuples.addDelete(childLeftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }
    }

    public static class PhreakAccumulateNode {
        public void doNode(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTuple next;
            boolean useLeftMemory = true;
            RightTupleSets srcRightTuples = am.getBetaMemory().getStagedRightTuples();
            LeftTupleSets tempLeftTuples = new LeftTupleSets();
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(accNode, am, wm, srcLeftTuples, trgLeftTuples);
            }
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(accNode, am, wm, srcRightTuples, tempLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluator.dpUpdatesReorderLeftMemory(am.getBetaMemory(), srcLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluator.dpUpdatesReorderRightMemory(am.getBetaMemory(), srcRightTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(accNode, sink, am, wm, srcLeftTuples, tempLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(accNode, sink, am, wm, srcRightTuples, tempLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(accNode, sink, am, wm, srcRightTuples, tempLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(accNode, sink, am, wm, srcLeftTuples, tempLeftTuples);
            }
            Accumulate accumulate = accNode.getAccumulate();
            LeftTuple leftTuple = tempLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                next = leftTuple.getStagedNext();
                this.evaluateResultConstraints(accNode, sink, accumulate, leftTuple, leftTuple.getPropagationContext(), wm, am, (AccumulateNode.AccumulateContext)leftTuple.getObject(), useLeftMemory, trgLeftTuples, stagedLeftTuples);
                leftTuple.clearStaged();
                leftTuple = next;
            }
            leftTuple = tempLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                next = leftTuple.getStagedNext();
                this.evaluateResultConstraints(accNode, sink, accumulate, leftTuple, leftTuple.getPropagationContext(), wm, am, (AccumulateNode.AccumulateContext)leftTuple.getObject(), useLeftMemory, trgLeftTuples, stagedLeftTuples);
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcRightTuples.resetAll();
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            Accumulate accumulate = accNode.getAccumulate();
            BetaMemory bm = am.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = accNode.getRawConstraints();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(accNode, leftTuple);
                if (useLeftMemory) {
                    ltm.add(leftTuple);
                }
                PropagationContext context = leftTuple.getPropagationContext();
                AccumulateNode.AccumulateContext accresult = new AccumulateNode.AccumulateContext();
                leftTuple.setObject(accresult);
                accresult.context = accumulate.createContext();
                accumulate.init(am.workingMemoryContext, accresult.context, leftTuple, wm);
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                FastIterator rightIt = accNode.getRightIterator(rtm);
                RightTuple rightTuple = accNode.getFirstRightTuple(leftTuple, rtm, null, rightIt);
                while (rightTuple != null) {
                    RightTuple nextRightTuple = (RightTuple)rightIt.next(rightTuple);
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (constraints.isAllowedCachedLeft(contextEntry, handle)) {
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accresult, useLeftMemory);
                        if (!useLeftMemory && accNode.isRightInputIsRiaNode()) {
                            rtm.remove(rightTuple);
                        }
                    }
                    rightTuple = nextRightTuple;
                }
                leftTuple.clearStaged();
                trgLeftTuples.addInsert(leftTuple);
                constraints.resetTuple(contextEntry);
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            Accumulate accumulate = accNode.getAccumulate();
            BetaMemory bm = am.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = accNode.getRawConstraints();
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                FastIterator leftIt = accNode.getLeftIterator(ltm);
                LeftTuple leftTuple = accNode.getFirstLeftTuple(rightTuple, ltm, context, leftIt);
                while (leftTuple != null) {
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accctx, true);
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                    }
                    leftTuple = (LeftTuple)leftIt.next(leftTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftUpdates(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            BetaMemory bm = am.getBetaMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            Accumulate accumulate = accNode.getAccumulate();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = accNode.getRawConstraints();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                PropagationContext context = leftTuple.getPropagationContext();
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                FastIterator rightIt = accNode.getRightIterator(rtm);
                RightTuple rightTuple = accNode.getFirstRightTuple(leftTuple, rtm, null, rightIt);
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                if (childLeftTuple != null && rtm.isIndexed() && !rightIt.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
                    PhreakAccumulateNode.removePreviousMatchesForLeftTuple(accNode, accumulate, leftTuple, wm, am, accctx, true);
                    childLeftTuple = null;
                }
                if (rightTuple != null) {
                    this.doLeftUpdatesProcessChildren(accNode, am, wm, bm, accumulate, constraints, rightIt, leftTuple, accctx, rightTuple, childLeftTuple);
                }
                leftTuple.clearStaged();
                trgLeftTuples.addUpdate(leftTuple);
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        private void doLeftUpdatesProcessChildren(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, BetaMemory bm, Accumulate accumulate, BetaConstraints constraints, FastIterator rightIt, LeftTuple leftTuple, AccumulateNode.AccumulateContext accctx, RightTuple rightTuple, LeftTuple childLeftTuple) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (constraints.isAllowedCachedLeft(bm.getContext(), handle)) {
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accctx, true);
                    }
                    rightTuple = (RightTuple)rightIt.next(rightTuple);
                }
            } else {
                boolean isDirty = false;
                while (rightTuple != null) {
                    LeftTuple temp;
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (constraints.isAllowedCachedLeft(bm.getContext(), handle)) {
                        if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                            PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, childLeftTuple, null, wm, am, accctx, true);
                        } else {
                            temp = childLeftTuple.getLeftParentNext();
                            childLeftTuple.reAddRight();
                            childLeftTuple = temp;
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                        temp = childLeftTuple.getLeftParentNext();
                        PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, wm, am, accctx, false);
                        childLeftTuple = temp;
                        isDirty = !accumulate.supportsReverse();
                    }
                    rightTuple = (RightTuple)rightIt.next(rightTuple);
                }
                if (isDirty) {
                    PhreakAccumulateNode.reaccumulateForLeftTuple(accNode, accumulate, leftTuple, wm, am, accctx);
                }
            }
        }

        public void doRightUpdates(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            BetaMemory bm = am.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = accNode.getRawConstraints();
            Accumulate accumulate = accNode.getAccumulate();
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                PropagationContext context = rightTuple.getPropagationContext();
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                FastIterator leftIt = accNode.getLeftIterator(ltm);
                LeftTuple leftTuple = accNode.getFirstLeftTuple(rightTuple, ltm, context, leftIt);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                if (childLeftTuple != null && ltm.isIndexed() && !leftIt.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
                    PhreakAccumulateNode.removePreviousMatchesForRightTuple(accNode, accumulate, rightTuple, context, wm, am, childLeftTuple, trgLeftTuples);
                    childLeftTuple = null;
                }
                if (leftTuple != null) {
                    if (leftTuple.getStagedType() == 0) {
                        trgLeftTuples.addUpdate(leftTuple);
                    }
                    this.doRightUpdatesProcessChildren(accNode, am, wm, bm, constraints, accumulate, leftIt, rightTuple, childLeftTuple, leftTuple, trgLeftTuples);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        private void doRightUpdatesProcessChildren(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, BetaMemory bm, BetaConstraints constraints, Accumulate accumulate, FastIterator leftIt, RightTuple rightTuple, LeftTuple childLeftTuple, LeftTuple leftTuple, LeftTupleSets trgLeftTuples) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    if (constraints.isAllowedCachedRight(bm.getContext(), leftTuple)) {
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accctx, true);
                    }
                    leftTuple = (LeftTuple)leftIt.next(leftTuple);
                }
            } else {
                while (leftTuple != null) {
                    if (constraints.isAllowedCachedRight(bm.getContext(), leftTuple)) {
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        LeftTuple temp = null;
                        if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                            temp = childLeftTuple.getRightParentNext();
                            PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, wm, am, accctx, true);
                            childLeftTuple = temp;
                        }
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, childLeftTuple, wm, am, accctx, true);
                        if (temp != null) {
                            childLeftTuple = temp;
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                        LeftTuple temp = childLeftTuple.getRightParentNext();
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, wm, am, accctx, true);
                        childLeftTuple = temp;
                    }
                    leftTuple = (LeftTuple)leftIt.next(leftTuple);
                }
            }
        }

        public void doLeftDeletes(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            BetaMemory bm = am.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            Accumulate accumulate = accNode.getAccumulate();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                    AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                    leftTuple.setObject(null);
                    PhreakAccumulateNode.removePreviousMatchesForLeftTuple(accNode, accumulate, leftTuple, wm, am, accctx, false);
                    if (accctx.propagated) {
                        trgLeftTuples.addDelete(accctx.resultLeftTuple);
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doRightDeletes(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            RightTupleMemory rtm = am.getBetaMemory().getRightTupleMemory();
            Accumulate accumulate = accNode.getAccumulate();
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                if (rightTuple.getMemory() != null) {
                    rtm.remove(rightTuple);
                    if (rightTuple.getFirstChild() != null) {
                        LeftTuple match = rightTuple.getFirstChild();
                        while (match != null) {
                            LeftTuple nextLeft = match.getRightParentNext();
                            LeftTuple leftTuple = match.getLeftParent();
                            AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                            PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, match, wm, am, accctx, true);
                            if (leftTuple.getStagedType() == 0) {
                                trgLeftTuples.addUpdate(leftTuple);
                            }
                            match.unlinkFromLeftParent();
                            match = nextLeft;
                        }
                    }
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
        }

        public void evaluateResultConstraints(AccumulateNode accNode, LeftTupleSink sink, Accumulate accumulate, LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx, boolean useLeftMemory, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            Object[] result;
            Object[] resultArray = accumulate.getResult(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
            Object object = result = accumulate.isMultiFunction() ? resultArray : resultArray[0];
            if (result == null) {
                return;
            }
            if (accctx.getResultFactHandle() == null) {
                InternalFactHandle handle = accNode.createResultFactHandle(context, workingMemory, leftTuple, result);
                accctx.setResultFactHandle(handle);
                accctx.setResultLeftTuple(sink.createLeftTuple(handle, leftTuple, sink));
            } else {
                accctx.getResultFactHandle().setObject(result);
            }
            AlphaNodeFieldConstraint[] resultConstraints = accNode.getResultConstraints();
            BetaConstraints resultBinder = accNode.getResultBinder();
            boolean isAllowed = result != null;
            int length = resultConstraints.length;
            for (int i = 0; isAllowed && i < length; ++i) {
                if (resultConstraints[i].isAllowed(accctx.resultFactHandle, workingMemory, memory.alphaContexts[i])) continue;
                isAllowed = false;
            }
            if (isAllowed) {
                resultBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
                if (!resultBinder.isAllowedCachedLeft(memory.resultsContext, accctx.getResultFactHandle())) {
                    isAllowed = false;
                }
                resultBinder.resetTuple(memory.resultsContext);
            }
            LeftTuple childLeftTuple = accctx.getResultLeftTuple();
            childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
            if (accctx.propagated) {
                switch (childLeftTuple.getStagedType()) {
                    case 1: {
                        stagedLeftTuples.removeInsert(childLeftTuple);
                        break;
                    }
                    case 2: {
                        stagedLeftTuples.removeUpdate(childLeftTuple);
                    }
                }
                if (isAllowed) {
                    trgLeftTuples.addUpdate(childLeftTuple);
                } else {
                    trgLeftTuples.addDelete(childLeftTuple);
                    accctx.propagated = false;
                }
            } else if (isAllowed) {
                trgLeftTuples.addInsert(childLeftTuple);
                accctx.propagated = true;
            }
        }

        public static void addMatch(AccumulateNode accNode, Accumulate accumulate, LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, InternalWorkingMemory wm, AccumulateNode.AccumulateMemory am, AccumulateNode.AccumulateContext accresult, boolean useLeftMemory) {
            LeftTuple tuple = leftTuple;
            InternalFactHandle handle = rightTuple.getFactHandle();
            if (accNode.isUnwrapRightObject()) {
                tuple = (LeftTuple)handle.getObject();
            }
            accumulate.accumulate(am.workingMemoryContext, accresult.context, tuple, handle, wm);
            if (useLeftMemory) {
                accNode.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, accNode, true);
            }
        }

        public static void removeMatch(AccumulateNode accNode, Accumulate accumulate, RightTuple rightTuple, LeftTuple match, InternalWorkingMemory wm, AccumulateNode.AccumulateMemory am, AccumulateNode.AccumulateContext accctx, boolean reaccumulate) {
            LeftTuple leftTuple = match.getLeftParent();
            match.unlinkFromLeftParent();
            match.unlinkFromRightParent();
            InternalFactHandle handle = rightTuple.getFactHandle();
            LeftTuple tuple = leftTuple;
            if (accNode.isUnwrapRightObject()) {
                tuple = (LeftTuple)handle.getObject();
            }
            if (accumulate.supportsReverse()) {
                accumulate.reverse(am.workingMemoryContext, accctx.context, tuple, handle, wm);
            } else if (reaccumulate) {
                PhreakAccumulateNode.reaccumulateForLeftTuple(accNode, accumulate, leftTuple, wm, am, accctx);
            }
        }

        public static void reaccumulateForLeftTuple(AccumulateNode accNode, Accumulate accumulate, LeftTuple leftTuple, InternalWorkingMemory wm, AccumulateNode.AccumulateMemory am, AccumulateNode.AccumulateContext accctx) {
            accumulate.init(am.workingMemoryContext, accctx.context, leftTuple, wm);
            for (LeftTuple childMatch = leftTuple.getFirstChild(); childMatch != null; childMatch = childMatch.getLeftParentNext()) {
                InternalFactHandle childHandle = childMatch.getRightParent().getFactHandle();
                LeftTuple tuple = leftTuple;
                if (accNode.isUnwrapRightObject()) {
                    tuple = (LeftTuple)childHandle.getObject();
                    childHandle = tuple.getLastHandle();
                }
                accumulate.accumulate(am.workingMemoryContext, accctx.context, tuple, childHandle, wm);
            }
        }

        public static void removePreviousMatchesForRightTuple(AccumulateNode accNode, Accumulate accumulate, RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, LeftTuple firstChild, LeftTupleSets trgLeftTuples) {
            LeftTuple match = firstChild;
            while (match != null) {
                LeftTuple next = match.getRightParentNext();
                LeftTuple leftTuple = match.getLeftParent();
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, match, workingMemory, memory, accctx, true);
                if (leftTuple.getStagedType() == 0) {
                    trgLeftTuples.addUpdate(leftTuple);
                }
                match = next;
            }
        }

        public static void removePreviousMatchesForLeftTuple(AccumulateNode accNode, Accumulate accumulate, LeftTuple leftTuple, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx, boolean reInit) {
            LeftTuple match = leftTuple.getFirstChild();
            while (match != null) {
                LeftTuple next = match.getLeftParentNext();
                match.unlinkFromRightParent();
                match.unlinkFromLeftParent();
                match = next;
            }
            if (reInit) {
                accumulate.init(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
            }
        }
    }

    public static class PhreakExistsNode {
        public void doNode(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            RightTupleSets srcRightTuples = bm.getStagedRightTuples();
            if (srcLeftTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluator.dpUpdatesExistentialReorderLeftMemory(bm, srcLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluator.dpUpdatesExistentialReorderRightMemory(bm, existsNode, srcRightTuples);
            }
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(existsNode, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(existsNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(existsNode, sink, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(existsNode, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(existsNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(existsNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
            }
            srcRightTuples.resetAll();
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                FastIterator it = existsNode.getRightIterator(rtm);
                PropagationContext context = leftTuple.getPropagationContext();
                boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(existsNode, leftTuple);
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RuleNetworkEvaluator.findLeftTupleBlocker(existsNode, rtm, contextEntry, constraints, leftTuple, it, context, useLeftMemory);
                if (leftTuple.getBlocker() != null) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getBlocker().getPropagationContext(), useLeftMemory));
                } else if (useLeftMemory) {
                    ltm.add(leftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                FastIterator it = existsNode.getLeftIterator(ltm);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = existsNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)it.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, rightTuple.getPropagationContext(), true));
                    }
                    leftTuple = temp;
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftUpdates(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemory = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple childLeftTuple;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                FastIterator rightIt = existsNode.getRightIterator(rtm);
                RightTuple firstRightTuple = existsNode.getFirstRightTuple(leftTuple, rtm, null, rightIt);
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    if (leftTuple.getMemory() != null) {
                        ltm.remove(leftTuple);
                    }
                } else if (rtm.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
                    blocker.removeBlocked(leftTuple);
                    blocker = null;
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                if (blocker == null || !constraints.isAllowedCachedLeft(contextEntry, blocker.getFactHandle())) {
                    if (blocker != null) {
                        blocker.removeBlocked(leftTuple);
                    }
                    RightTuple newBlocker = firstRightTuple;
                    while (newBlocker != null) {
                        if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)rightIt.next(newBlocker);
                    }
                }
                if (leftTuple.getBlocker() == null) {
                    ltm.add(leftTuple);
                    if (leftTuple.getFirstChild() != null && leftTuple.getFirstChild() != null && (childLeftTuple = leftTuple.getFirstChild()) != null) {
                        childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                } else if (leftTuple.getFirstChild() == null) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getBlocker().getPropagationContext(), tupleMemory));
                } else if (leftTuple.getFirstChild() != null) {
                    for (childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        childLeftTuple.setPropagationContext(leftTuple.getBlocker().getPropagationContext());
                        trgLeftTuples.addUpdate(childLeftTuple);
                        childLeftTuple.reAddRight();
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightUpdates(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            boolean iterateFromStart = existsNode.isIndexedUnificationJoin() || rtm.getIndexType().isComparison();
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                FastIterator leftIt = existsNode.getLeftIterator(ltm);
                PropagationContext context = rightTuple.getPropagationContext();
                LeftTuple firstLeftTuple = existsNode.getFirstLeftTuple(rightTuple, ltm, context, leftIt);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple firstBlocked = rightTuple.getTempBlocked();
                LeftTuple leftTuple = firstLeftTuple;
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, rightTuple.getPropagationContext(), true));
                    }
                    leftTuple = temp;
                }
                if (firstBlocked != null) {
                    RightTuple rootBlocker = rightTuple.getTempNextRightTuple();
                    if (rootBlocker == null) {
                        iterateFromStart = true;
                    }
                    FastIterator rightIt = existsNode.getRightIterator(rtm);
                    LeftTuple leftTuple2 = firstBlocked;
                    while (leftTuple2 != null) {
                        LeftTuple temp = leftTuple2.getBlockedNext();
                        leftTuple2.clearBlocker();
                        if (leftTuple2.getStagedType() == 2) {
                            leftTuple2.setBlocker(rightTuple);
                            rightTuple.addBlocked(leftTuple2);
                            leftTuple2 = temp;
                            continue;
                        }
                        constraints.updateFromTuple(contextEntry, wm, leftTuple2);
                        if (iterateFromStart) {
                            rootBlocker = existsNode.getFirstRightTuple(leftTuple2, rtm, null, rightIt);
                        }
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (leftTuple2.getStagedType() != 3 && newBlocker.getStagedType() != 3 && constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple2.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple2);
                                break;
                            }
                            newBlocker = (RightTuple)rightIt.next(newBlocker);
                        }
                        if (leftTuple2.getBlocker() == null) {
                            ltm.add(leftTuple2);
                            LeftTuple childLeftTuple = leftTuple2.getFirstChild();
                            if (childLeftTuple != null) {
                                childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                                childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                            }
                        }
                        leftTuple2 = temp;
                    }
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftDeletes(ExistsNode existsNode, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    if (leftTuple.getMemory() != null) {
                        ltm.remove(leftTuple);
                    }
                } else {
                    LeftTuple childLeftTuple;
                    if (leftTuple.getFirstChild() != null && (childLeftTuple = leftTuple.getFirstChild()) != null) {
                        childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                    blocker.removeBlocked(leftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doRightDeletes(ExistsNode existsNode, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            RightTupleMemory rtm = bm.getRightTupleMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple rootBlocker;
                RightTuple next = rightTuple.getStagedNext();
                FastIterator it = existsNode.getRightIterator(rtm);
                boolean useComparisonIndex = rtm.getIndexType().isComparison();
                RightTuple rightTuple2 = rootBlocker = useComparisonIndex ? null : (RightTuple)it.next(rightTuple);
                if (rightTuple.getMemory() != null) {
                    rtm.remove(rightTuple);
                }
                if (rightTuple.getBlocked() != null) {
                    PropagationContext context = rightTuple.getPropagationContext();
                    LeftTuple leftTuple = rightTuple.getBlocked();
                    while (leftTuple != null) {
                        LeftTuple temp = leftTuple.getBlockedNext();
                        leftTuple.clearBlocker();
                        if (leftTuple.getStagedType() == 2) {
                            leftTuple = temp;
                            continue;
                        }
                        constraints.updateFromTuple(contextEntry, wm, leftTuple);
                        if (useComparisonIndex) {
                            rootBlocker = rtm.getFirst(leftTuple, null, it);
                        }
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple);
                                break;
                            }
                            newBlocker = (RightTuple)it.next(newBlocker);
                        }
                        if (leftTuple.getBlocker() == null) {
                            ltm.add(leftTuple);
                            LeftTuple childLeftTuple = leftTuple.getFirstChild();
                            if (childLeftTuple != null) {
                                childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                                childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                            }
                        }
                        leftTuple = temp;
                    }
                }
                rightTuple.nullBlocked();
                rightTuple.clearStaged();
                rightTuple = next;
            }
        }
    }

    public static class PhreakNotNode {
        public void doNode(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            RightTupleSets srcRightTuples = bm.getStagedRightTuples();
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(notNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluator.dpUpdatesExistentialReorderLeftMemory(bm, srcLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluator.dpUpdatesExistentialReorderRightMemory(bm, notNode, srcRightTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(notNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(notNode, sink, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(notNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(notNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(notNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
            }
            srcRightTuples.resetAll();
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                FastIterator it = notNode.getRightIterator(rtm);
                PropagationContext context = leftTuple.getPropagationContext();
                boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(notNode, leftTuple);
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RuleNetworkEvaluator.findLeftTupleBlocker(notNode, rtm, contextEntry, constraints, leftTuple, it, context, useLeftMemory);
                if (leftTuple.getBlocker() == null) {
                    if (useLeftMemory) {
                        ltm.add(leftTuple);
                    }
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useLeftMemory));
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            LeftTupleSets stagedLeftTuples = null;
            if (!bm.getSegmentMemory().isEmpty()) {
                stagedLeftTuples = ((SegmentMemory)bm.getSegmentMemory().getFirst()).getStagedLeftTuples();
            }
            PhreakNotNode.unlinkNotNodeOnRightInsert(notNode, bm, wm);
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                FastIterator it = notNode.getLeftIterator(ltm);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = notNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)it.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        if (childLeftTuple != null) {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public static void unlinkNotNodeOnRightInsert(NotNode notNode, BetaMemory bm, InternalWorkingMemory wm) {
            if (bm.getSegmentMemory().isSegmentLinked() && !notNode.isRightInputIsRiaNode() && notNode.isEmptyBetaConstraints()) {
                bm.unlinkNode(wm);
            }
        }

        public void doLeftUpdates(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                FastIterator rightIt = notNode.getRightIterator(rtm);
                RightTuple firstRightTuple = notNode.getFirstRightTuple(leftTuple, rtm, null, rightIt);
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    if (leftTuple.getMemory() != null) {
                        ltm.remove(leftTuple);
                    }
                } else if (rtm.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
                    blocker.removeBlocked(leftTuple);
                    blocker = null;
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                if (blocker == null || !constraints.isAllowedCachedLeft(contextEntry, blocker.getFactHandle())) {
                    if (blocker != null) {
                        blocker.removeBlocked(leftTuple);
                    }
                    RightTuple newBlocker = firstRightTuple;
                    while (newBlocker != null) {
                        if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)rightIt.next(newBlocker);
                    }
                    LeftTuple childLeftTuple = leftTuple.getFirstChild();
                    if (leftTuple.getBlocker() != null) {
                        if (childLeftTuple != null) {
                            childLeftTuple.setPropagationContext(leftTuple.getBlocker().getPropagationContext());
                            RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    } else if (childLeftTuple == null) {
                        ltm.add(leftTuple);
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true));
                    } else {
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        ltm.add(leftTuple);
                        trgLeftTuples.addUpdate(childLeftTuple);
                        childLeftTuple.reAddLeft();
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightUpdates(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            boolean iterateFromStart = notNode.isIndexedUnificationJoin() || rtm.getIndexType().isComparison();
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                FastIterator leftIt = notNode.getLeftIterator(ltm);
                LeftTuple firstLeftTuple = notNode.getFirstLeftTuple(rightTuple, ltm, context, leftIt);
                LeftTuple firstBlocked = rightTuple.getTempBlocked();
                LeftTuple leftTuple = firstLeftTuple;
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        if (childLeftTuple != null) {
                            childLeftTuple.setPropagationContext(rightTuple.getPropagationContext());
                            RuleNetworkEvaluator.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
                if (firstBlocked != null) {
                    RightTuple rootBlocker = rightTuple.getTempNextRightTuple();
                    if (rootBlocker == null) {
                        iterateFromStart = true;
                    }
                    FastIterator rightIt = notNode.getRightIterator(rtm);
                    LeftTuple leftTuple2 = firstBlocked;
                    while (leftTuple2 != null) {
                        LeftTuple temp = leftTuple2.getBlockedNext();
                        leftTuple2.clearBlocker();
                        if (leftTuple2.getStagedType() == 2) {
                            leftTuple2.setBlocker(rightTuple);
                            rightTuple.addBlocked(leftTuple2);
                            leftTuple2 = temp;
                            continue;
                        }
                        constraints.updateFromTuple(contextEntry, wm, leftTuple2);
                        if (iterateFromStart) {
                            rootBlocker = notNode.getFirstRightTuple(leftTuple2, rtm, null, rightIt);
                        }
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (leftTuple2.getStagedType() != 3 && newBlocker.getStagedType() != 3 && constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple2.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple2);
                                break;
                            }
                            newBlocker = (RightTuple)rightIt.next(newBlocker);
                        }
                        if (leftTuple2.getBlocker() == null) {
                            ltm.add(leftTuple2);
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple2, sink, rightTuple.getPropagationContext(), true));
                        }
                        leftTuple2 = temp;
                    }
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
            constraints.resetTuple(contextEntry);
        }

        public void doLeftDeletes(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    LeftTuple childLeftTuple;
                    if (leftTuple.getMemory() != null) {
                        ltm.remove(leftTuple);
                    }
                    if ((childLeftTuple = leftTuple.getFirstChild()) != null) {
                        RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                } else {
                    blocker.removeBlocked(leftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doRightDeletes(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple rootBlocker;
                RightTuple next = rightTuple.getStagedNext();
                FastIterator it = notNode.getRightIterator(rtm);
                boolean useComparisonIndex = rtm.getIndexType().isComparison();
                RightTuple rightTuple2 = rootBlocker = useComparisonIndex ? null : (RightTuple)it.next(rightTuple);
                if (rightTuple.getMemory() != null) {
                    rtm.remove(rightTuple);
                }
                if (rightTuple.getBlocked() != null) {
                    PropagationContext context = rightTuple.getPropagationContext();
                    LeftTuple leftTuple = rightTuple.getBlocked();
                    while (leftTuple != null) {
                        LeftTuple temp = leftTuple.getBlockedNext();
                        leftTuple.clearBlocker();
                        if (leftTuple.getStagedType() == 2) {
                            leftTuple = temp;
                            continue;
                        }
                        constraints.updateFromTuple(contextEntry, wm, leftTuple);
                        if (useComparisonIndex) {
                            rootBlocker = rtm.getFirst(leftTuple, null, it);
                        }
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple);
                                break;
                            }
                            newBlocker = (RightTuple)it.next(newBlocker);
                        }
                        if (leftTuple.getBlocker() == null) {
                            ltm.add(leftTuple);
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, rightTuple.getPropagationContext(), true));
                        }
                        leftTuple = temp;
                    }
                }
                rightTuple.nullBlocked();
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }
    }

    public static class PhreakJoinNode {
        public void doNode(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            RightTupleSets srcRightTuples = bm.getStagedRightTuples();
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(joinNode, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(joinNode, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluator.dpUpdatesReorderLeftMemory(bm, srcLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluator.dpUpdatesReorderRightMemory(bm, srcRightTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(joinNode, sink, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(joinNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(joinNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(joinNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
            }
            srcRightTuples.resetAll();
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(joinNode, leftTuple);
                if (useLeftMemory) {
                    ltm.add(leftTuple);
                }
                FastIterator it = joinNode.getRightIterator(rtm);
                PropagationContext context = leftTuple.getPropagationContext();
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, null, it);
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, useLeftMemory));
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                FastIterator it = joinNode.getLeftIterator(ltm);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                while (leftTuple != null) {
                    if (leftTuple.getStagedType() != 2 && constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, true));
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                FastIterator it = joinNode.getRightIterator(rtm);
                RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, null, it);
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                if (childLeftTuple != null && rtm.isIndexed() && !it.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                if (rightTuple != null) {
                    this.doLeftUpdatesProcessChildren(childLeftTuple, leftTuple, rightTuple, stagedLeftTuples, contextEntry, constraints, sink, it, trgLeftTuples);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public LeftTuple doLeftUpdatesProcessChildren(LeftTuple childLeftTuple, LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSets stagedLeftTuples, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, LeftTupleSets trgLeftTuples) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, true));
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
            } else {
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, true));
                        } else {
                            switch (childLeftTuple.getStagedType()) {
                                case 1: {
                                    stagedLeftTuples.removeInsert(childLeftTuple);
                                    break;
                                }
                                case 2: {
                                    stagedLeftTuples.removeUpdate(childLeftTuple);
                                }
                            }
                            trgLeftTuples.addUpdate(childLeftTuple);
                            childLeftTuple.reAddRight();
                            childLeftTuple = childLeftTuple.getLeftParentNext();
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                        childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
            }
            return childLeftTuple;
        }

        public void doRightUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                PropagationContext context = rightTuple.getPropagationContext();
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                FastIterator it = joinNode.getLeftIterator(ltm);
                LeftTuple leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                if (childLeftTuple != null && ltm.isIndexed() && !it.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluator.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                if (leftTuple != null) {
                    this.doRightUpdatesProcessChildren(childLeftTuple, leftTuple, rightTuple, stagedLeftTuples, contextEntry, constraints, sink, it, trgLeftTuples);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public LeftTuple doRightUpdatesProcessChildren(LeftTuple childLeftTuple, LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSets stagedLeftTuples, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, LeftTupleSets trgLeftTuples) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    if (leftTuple.getStagedType() != 2 && constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, true));
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            } else {
                while (leftTuple != null) {
                    if (leftTuple.getStagedType() != 2) {
                        if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                            if (childLeftTuple == null || childLeftTuple.getLeftParent() != leftTuple) {
                                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, true));
                            } else {
                                switch (childLeftTuple.getStagedType()) {
                                    case 1: {
                                        stagedLeftTuples.removeInsert(childLeftTuple);
                                        break;
                                    }
                                    case 2: {
                                        stagedLeftTuples.removeUpdate(childLeftTuple);
                                    }
                                }
                                trgLeftTuples.addUpdate(childLeftTuple);
                                childLeftTuple.reAddLeft();
                                childLeftTuple = childLeftTuple.getRightParentNext();
                            }
                        } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                            childLeftTuple = RuleNetworkEvaluator.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            }
            return childLeftTuple;
        }

        public void doLeftDeletes(JoinNode joinNode, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                }
                if (leftTuple.getFirstChild() != null) {
                    LeftTuple childLeftTuple = leftTuple.getFirstChild();
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doRightDeletes(JoinNode joinNode, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            RightTupleMemory rtm = bm.getRightTupleMemory();
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                if (rightTuple.getMemory() != null) {
                    rtm.remove(rightTuple);
                }
                if (rightTuple.getFirstChild() != null) {
                    LeftTuple childLeftTuple = rightTuple.getFirstChild();
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluator.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
        }
    }

    public static class StackEntry
    extends AbstractBaseLinkedListNode<StackEntry> {
        private LeftInputAdapterNode liaNode;
        private NetworkNode node;
        private LeftTupleSinkNode sink;
        private PathMemory rmem;
        private Memory nodeMem;
        private SegmentMemory[] smems;
        private int smemIndex;
        private LeftTupleSets trgTuples;
        private Set<String> visitedRules;
        private boolean resumeFromNextNode;

        public StackEntry(LeftInputAdapterNode liaNode, NetworkNode node, LeftTupleSinkNode sink, PathMemory rmem, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, Set<String> visitedRules, boolean resumeFromNextNode) {
            this.liaNode = liaNode;
            this.node = node;
            this.sink = sink;
            this.rmem = rmem;
            this.nodeMem = nodeMem;
            this.smems = smems;
            this.smemIndex = smemIndex;
            this.trgTuples = trgTuples;
            this.visitedRules = visitedRules;
            this.resumeFromNextNode = resumeFromNextNode;
        }

        public LeftInputAdapterNode getLiaNode() {
            return this.liaNode;
        }

        public NetworkNode getNode() {
            return this.node;
        }

        public PathMemory getRmem() {
            return this.rmem;
        }

        public Memory getNodeMem() {
            return this.nodeMem;
        }

        public SegmentMemory[] getSmems() {
            return this.smems;
        }

        public int getSmemIndex() {
            return this.smemIndex;
        }

        public LeftTupleSets getTrgTuples() {
            return this.trgTuples;
        }

        public LeftTupleSinkNode getSink() {
            return this.sink;
        }

        public Set<String> getVisitedRules() {
            return this.visitedRules;
        }

        public boolean isResumeFromNextNode() {
            return this.resumeFromNextNode;
        }
    }
}

