/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.RightTupleList;

public class RightTupleIndexHashTable
extends AbstractHashTable
implements RightTupleMemory {
    private static final long serialVersionUID = 510L;
    public static final int PRIME = 31;
    private transient FieldIndexHashTableFullIterator tupleValueFullIterator;
    private transient FullFastIterator fullFastIterator;
    private int startResult;
    private int factSize;
    private AbstractHashTable.Index index;

    public RightTupleIndexHashTable() {
    }

    public RightTupleIndexHashTable(AbstractHashTable.FieldIndex[] index) {
        this(128, 0.75f, index);
    }

    public RightTupleIndexHashTable(int capacity, float loadFactor, AbstractHashTable.FieldIndex[] index) {
        super(capacity, loadFactor);
        this.startResult = 31;
        int length = index.length;
        for (int i = 0; i < length; ++i) {
            this.startResult += 31 * this.startResult + index[i].getExtractor().getIndex();
        }
        switch (index.length) {
            case 0: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            }
            case 1: {
                this.index = new AbstractHashTable.SingleIndex(index, this.startResult);
                break;
            }
            case 2: {
                this.index = new AbstractHashTable.DoubleCompositeIndex(index, this.startResult);
                break;
            }
            case 3: {
                this.index = new AbstractHashTable.TripleCompositeIndex(index, this.startResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.startResult = in.readInt();
        this.factSize = in.readInt();
        this.index = (AbstractHashTable.Index)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.startResult);
        out.writeInt(this.factSize);
        out.writeObject(this.index);
    }

    public void init(Entry[] table, int size, int factSize) {
        this.table = table;
        this.size = size;
        this.factSize = factSize;
    }

    @Override
    public RightTuple getFirst(LeftTuple leftTuple, InternalFactHandle factHandle, FastIterator rightTupleIterator) {
        RightTupleList bucket = this.get(leftTuple, factHandle);
        if (bucket != null) {
            return bucket.first;
        }
        return null;
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    @Override
    public Entry getBucket(Object object) {
        int hashCode = this.index.hashCodeOf(object);
        int index = RightTupleIndexHashTable.indexOf(hashCode, this.table.length);
        return this.table[index];
    }

    @Override
    public Iterator iterator() {
        if (this.tupleValueFullIterator == null) {
            this.tupleValueFullIterator = new FieldIndexHashTableFullIterator(this);
        } else {
            this.tupleValueFullIterator.reset();
        }
        return this.tupleValueFullIterator;
    }

    @Override
    public int getResizeHashcode(Entry entry) {
        return entry.hashCode();
    }

    @Override
    public FastIterator fastIterator() {
        return LinkedList.fastIterator;
    }

    @Override
    public FastIterator fullFastIterator() {
        if (this.fullFastIterator == null) {
            this.fullFastIterator = new FullFastIterator(this.table);
        } else {
            this.fullFastIterator.reset();
        }
        return this.fullFastIterator;
    }

    @Override
    public FastIterator fullFastIterator(RightTuple rightTuple) {
        int hashCode = this.index.hashCodeOf(rightTuple.getFactHandle().getObject());
        int row = RightTupleIndexHashTable.indexOf(hashCode, this.table.length);
        return new FullFastIterator(this.table, row);
    }

    @Override
    public Entry[] toArray() {
        Entry[] result = new Entry[this.factSize];
        int index = 0;
        for (int i = 0; i < this.table.length; ++i) {
            RightTupleList bucket = (RightTupleList)this.table[i];
            while (bucket != null) {
                for (RightTuple entry = bucket.first; entry != null; entry = entry.getNext()) {
                    result[index++] = entry;
                }
                bucket = (RightTupleList)bucket.next;
            }
        }
        return result;
    }

    @Override
    public void add(RightTuple rightTuple) {
        RightTupleList entry = this.getOrCreate(rightTuple.getFactHandle().getObject());
        entry.add(rightTuple);
        ++this.factSize;
    }

    @Override
    public void removeAdd(RightTuple rightTuple) {
        RightTupleList memory = rightTuple.getMemory();
        memory.remove(rightTuple);
        int newHashCode = this.index.hashCodeOf(rightTuple.getFactHandle().getObject());
        if (newHashCode == memory.hashCode()) {
            memory.add(rightTuple);
            return;
        }
        --this.factSize;
        if (memory.first == null) {
            RightTupleList current;
            int index = RightTupleIndexHashTable.indexOf(memory.hashCode(), this.table.length);
            RightTupleList previous = null;
            for (current = (RightTupleList)this.table[index]; current != memory; current = (RightTupleList)current.getNext()) {
                previous = current;
            }
            if (previous != null) {
                previous.next = current.next;
            } else {
                this.table[index] = current.next;
            }
            --this.size;
        }
        this.add(rightTuple);
    }

    @Override
    public void remove(RightTuple rightTuple) {
        RightTupleList memory = rightTuple.getMemory();
        memory.remove(rightTuple);
        --this.factSize;
        if (memory.first == null) {
            RightTupleList current;
            int index = RightTupleIndexHashTable.indexOf(memory.hashCode(), this.table.length);
            RightTupleList previous = null;
            for (current = (RightTupleList)this.table[index]; current != memory; current = (RightTupleList)current.getNext()) {
                previous = current;
            }
            if (previous != null) {
                previous.next = current.next;
            } else {
                this.table[index] = current.next;
            }
            --this.size;
        }
        rightTuple.setNext(null);
        rightTuple.setPrevious(null);
    }

    @Override
    public boolean contains(RightTuple rightTuple) {
        Object object = rightTuple.getFactHandle().getObject();
        int hashCode = this.index.hashCodeOf(object);
        int index = RightTupleIndexHashTable.indexOf(hashCode, this.table.length);
        RightTupleList current = (RightTupleList)this.table[index];
        while (current != null) {
            if (current.matches(object, hashCode)) {
                return true;
            }
            current = (RightTupleList)current.next;
        }
        return false;
    }

    public RightTupleList get(LeftTuple tuple, InternalFactHandle factHandle) {
        RightTupleList entry;
        int hashCode = this.index.hashCodeOf(tuple);
        int index = RightTupleIndexHashTable.indexOf(hashCode, this.table.length);
        for (entry = (RightTupleList)this.table[index]; entry != null; entry = (RightTupleList)entry.getNext()) {
            if (!entry.matches(tuple, hashCode, factHandle)) continue;
            return entry;
        }
        return entry;
    }

    private RightTupleList getOrCreate(Object object) {
        int hashCode = this.index.hashCodeOf(object);
        int index = RightTupleIndexHashTable.indexOf(hashCode, this.table.length);
        RightTupleList entry = (RightTupleList)this.table[index];
        while (entry != null) {
            if (entry.matches(object, hashCode)) {
                return entry;
            }
            entry = (RightTupleList)entry.next;
        }
        if (entry == null) {
            entry = new RightTupleList(this.index, hashCode);
            entry.next = this.table[index];
            this.table[index] = entry;
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length);
            }
        }
        return entry;
    }

    private RightTupleList get(Object object) {
        int hashCode = this.index.hashCodeOf(object);
        int index = RightTupleIndexHashTable.indexOf(hashCode, this.table.length);
        RightTupleList entry = (RightTupleList)this.table[index];
        while (entry != null) {
            if (entry.matches(object, hashCode)) {
                return entry;
            }
            entry = (RightTupleList)entry.next;
        }
        return entry;
    }

    @Override
    public int size() {
        return this.factSize;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Entry[] arr$ = this.table;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (Entry entry = arr$[i$]; entry != null; entry = entry.getNext()) {
                RightTupleList bucket = (RightTupleList)entry;
                for (RightTuple rightTuple = bucket.getFirst(); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
                    builder.append(rightTuple);
                }
            }
        }
        return builder.toString();
    }

    @Override
    public RightTupleMemory.IndexType getIndexType() {
        return RightTupleMemory.IndexType.EQUAL;
    }

    public static class FieldIndexHashTableFullIterator
    implements Iterator {
        private AbstractHashTable hashTable;
        private Entry[] table;
        private int row;
        private int length;
        private RightTupleList list;
        private RightTuple rightTuple;

        public FieldIndexHashTableFullIterator(AbstractHashTable hashTable) {
            this.hashTable = hashTable;
            this.reset();
        }

        public Object next() {
            while (this.row <= this.length) {
                while (this.list == null) {
                    if (this.row < this.length) {
                        this.list = (RightTupleList)this.table[this.row];
                        ++this.row;
                    } else {
                        return null;
                    }
                    if (this.list == null) continue;
                    this.rightTuple = this.list.getFirst();
                    return this.rightTuple;
                }
                this.rightTuple = (RightTuple)this.rightTuple.getNext();
                if (this.rightTuple != null) {
                    return this.rightTuple;
                }
                this.list = (RightTupleList)this.list.getNext();
                if (this.list == null) continue;
                this.rightTuple = this.list.getFirst();
                return this.rightTuple;
            }
            return null;
        }

        public void reset() {
            this.table = this.hashTable.getTable();
            this.length = this.table.length;
            this.row = 0;
            this.list = null;
            this.rightTuple = null;
        }
    }

    public static class FullFastIterator
    implements FastIterator {
        private Entry[] table;
        private int row;

        public FullFastIterator(Entry[] table, int row) {
            this.table = table;
            this.row = row + 1;
        }

        public FullFastIterator(Entry[] table) {
            this.table = table;
            this.row = 0;
        }

        @Override
        public Entry next(Entry object) {
            RightTuple rightTuple = (RightTuple)object;
            RightTupleList list = null;
            if (rightTuple != null) {
                list = rightTuple.getMemory();
            }
            int length = this.table.length;
            while (this.row <= length) {
                while (list == null) {
                    if (this.row < length) {
                        list = (RightTupleList)this.table[this.row];
                        ++this.row;
                    } else {
                        return null;
                    }
                    if (list == null) continue;
                    rightTuple = list.getFirst();
                    return rightTuple;
                }
                if ((rightTuple = (RightTuple)rightTuple.getNext()) != null) {
                    return rightTuple;
                }
                if ((list = (RightTupleList)list.getNext()) == null) continue;
                rightTuple = list.getFirst();
                return rightTuple;
            }
            return null;
        }

        @Override
        public boolean isFullIterator() {
            return true;
        }

        public void reset() {
            this.row = 0;
        }
    }
}

