/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.PriorityQueue;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.WindowTuple;
import org.drools.core.reteoo.WindowTupleList;
import org.drools.core.rule.Behavior;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.PointInTimeTrigger;

public class SlidingTimeWindow
implements Externalizable,
Behavior {
    private long size;
    public static final BehaviorJob job = new BehaviorJob();

    public SlidingTimeWindow() {
        this(0L);
    }

    public SlidingTimeWindow(long size) {
        this.size = size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.size);
    }

    @Override
    public Behavior.BehaviorType getType() {
        return Behavior.BehaviorType.TIME_WINDOW;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public Object createContext() {
        return new SlidingTimeWindowContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean assertFact(WindowNode.WindowMemory memory, Object context, InternalFactHandle fact, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = (EventFactHandle)fact;
        PriorityQueue<EventFactHandle> priorityQueue = queue.queue;
        synchronized (priorityQueue) {
            queue.queue.add(handle);
            if (queue.queue.peek() == handle) {
                SlidingTimeWindow.updateNextExpiration(handle, workingMemory, memory, this, queue);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retractFact(WindowNode.WindowMemory memory, Object context, InternalFactHandle fact, InternalWorkingMemory workingMemory) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = (EventFactHandle)fact;
        PriorityQueue<EventFactHandle> priorityQueue = queue.queue;
        synchronized (priorityQueue) {
            if (queue.expiringHandle != handle) {
                if (queue.queue.peek() == handle) {
                    queue.queue.poll();
                    SlidingTimeWindow.updateNextExpiration(queue.queue.peek(), workingMemory, memory, this, queue);
                } else {
                    queue.queue.remove(handle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireFacts(WindowNode.WindowMemory memory, Object context, InternalWorkingMemory workingMemory) {
        TimerService clock = workingMemory.getTimerService();
        long currentTime = clock.getCurrentTime();
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        EventFactHandle handle = queue.queue.peek();
        PriorityQueue<EventFactHandle> priorityQueue = queue.queue;
        synchronized (priorityQueue) {
            while (handle != null && this.isExpired(currentTime, handle)) {
                queue.expiringHandle = handle;
                queue.queue.remove();
                if (handle.isValid()) {
                    PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 5, null, null, handle);
                    WindowTupleList list = (WindowTupleList)memory.events.get(handle);
                    WindowTuple tuple = list.getFirstWindowTuple();
                    while (tuple != null) {
                        tuple.getRightTupleSink().retractRightTuple(tuple, propagationContext, workingMemory);
                        propagationContext.evaluateActionQueue(workingMemory);
                        ((RightTuple)tuple).unlinkFromRightParent();
                        tuple = list.getFirstWindowTuple();
                    }
                }
                queue.expiringHandle = null;
                handle = queue.queue.peek();
            }
        }
        SlidingTimeWindow.updateNextExpiration(handle, workingMemory, memory, this, queue);
    }

    private boolean isExpired(long currentTime, EventFactHandle handle) {
        return handle.getStartTimestamp() + this.size <= currentTime;
    }

    private static void updateNextExpiration(InternalFactHandle fact, InternalWorkingMemory workingMemory, WindowNode.WindowMemory memory, SlidingTimeWindow stw, Object context) {
        TimerService clock = workingMemory.getTimerService();
        if (fact != null) {
            long nextTimestamp = ((EventFactHandle)fact).getStartTimestamp() + stw.getSize();
            BehaviorJobContext jobctx = new BehaviorJobContext(workingMemory, stw, memory, context);
            JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
            jobctx.setJobHandle(handle);
        }
    }

    @Override
    public long getExpirationOffset() {
        return this.size;
    }

    public String toString() {
        return "SlidingTimeWindow( size=" + this.size + " )";
    }

    public static class BehaviorExpireWMAction
    implements WorkingMemoryAction {
        private final Behavior behavior;
        private final Object context;
        private final WindowNode.WindowMemory memory;

        public BehaviorExpireWMAction(Behavior behavior, WindowNode.WindowMemory memory, Object context) {
            this.behavior = behavior;
            this.memory = memory;
            this.context = context;
        }

        public BehaviorExpireWMAction(MarshallerReaderContext inCtx) throws IOException {
            int sinkId = inCtx.readInt();
            WindowNode windowNode = (WindowNode)inCtx.sinks.get(sinkId);
            this.memory = (WindowNode.WindowMemory)inCtx.wm.getNodeMemory(windowNode);
            Object[] behaviorContext = (Object[])this.memory.behaviorContext;
            int i = inCtx.readInt();
            this.behavior = (SlidingTimeWindow)windowNode.getBehaviors()[i];
            this.context = (SlidingTimeWindowContext)behaviorContext[i];
        }

        public BehaviorExpireWMAction(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            int sinkId = _action.getBehaviorExpire().getNodeId();
            WindowNode windowNode = (WindowNode)context.sinks.get(sinkId);
            this.memory = (WindowNode.WindowMemory)context.wm.getNodeMemory(windowNode);
            Object[] behaviorContext = (Object[])this.memory.behaviorContext;
            int i = 0;
            this.behavior = (SlidingTimeWindow)windowNode.getBehaviors()[i];
            this.context = (SlidingTimeWindowContext)behaviorContext[i];
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            this.behavior.expireFacts(this.memory, this.context, workingMemory);
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }

        @Override
        public void write(MarshallerWriteContext outputCtx) throws IOException {
            outputCtx.writeShort(8);
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)this.context;
            EventFactHandle handle = slCtx.getQueue().peek();
            outputCtx.writeInt(handle.getId());
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext outputCtx) {
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)this.context;
            ProtobufMessages.ActionQueue.BehaviorExpire _be = ProtobufMessages.ActionQueue.BehaviorExpire.newBuilder().setNodeId(slCtx.getQueue().peek().getId()).build();
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.BEHAVIOR_EXPIRE).setBehaviorExpire(_be).build();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    public static class BehaviorJob
    implements Job {
        @Override
        public void execute(JobContext ctx) {
            BehaviorJobContext context = (BehaviorJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction(new BehaviorExpireWMAction(context.behavior, context.memory, context.behaviorContext));
        }
    }

    public static class BehaviorJobContext
    implements JobContext,
    Externalizable {
        public InternalWorkingMemory workingMemory;
        public Behavior behavior;
        public Object behaviorContext;
        public WindowNode.WindowMemory memory;
        public JobHandle handle;

        public BehaviorJobContext(InternalWorkingMemory workingMemory, Behavior behavior, WindowNode.WindowMemory memory, Object behaviorContext) {
            this.workingMemory = workingMemory;
            this.behavior = behavior;
            this.memory = memory;
            this.behaviorContext = behaviorContext;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.handle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    public static class BehaviorJobContextTimerInputMarshaller
    implements TimersInputMarshaller {
        @Override
        public void read(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
            int sinkId = inCtx.readInt();
            WindowNode windowNode = (WindowNode)inCtx.sinks.get(sinkId);
            WindowNode.WindowMemory memory = (WindowNode.WindowMemory)inCtx.wm.getNodeMemory(windowNode);
            Object[] behaviorContext = (Object[])memory.behaviorContext;
            int i = inCtx.readInt();
        }

        @Override
        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws ClassNotFoundException {
            int i = _timer.getBehavior().getHandleId();
        }
    }

    public static class BehaviorJobContextTimerOutputMarshaller
    implements TimersOutputMarshaller {
        @Override
        public void write(JobContext jobCtx, MarshallerWriteContext outputCtx) throws IOException {
            outputCtx.writeShort(51);
            BehaviorJobContext bjobCtx = (BehaviorJobContext)jobCtx;
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)bjobCtx.behaviorContext;
            EventFactHandle handle = slCtx.getQueue().peek();
            outputCtx.writeInt(handle.getId());
        }

        @Override
        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            BehaviorJobContext bjobCtx = (BehaviorJobContext)jobCtx;
            SlidingTimeWindowContext slCtx = (SlidingTimeWindowContext)bjobCtx.behaviorContext;
            EventFactHandle handle = slCtx.getQueue().peek();
            return ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.BEHAVIOR).setBehavior(ProtobufMessages.Timers.BehaviorTimer.newBuilder().setHandleId(handle.getId()).build()).build();
        }
    }

    public static class SlidingTimeWindowContext
    implements Externalizable {
        public PriorityQueue<EventFactHandle> queue = new PriorityQueue(16);
        public EventFactHandle expiringHandle;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.queue = (PriorityQueue)in.readObject();
            this.expiringHandle = (EventFactHandle)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.queue);
            out.writeObject(this.expiringHandle);
        }

        public PriorityQueue<EventFactHandle> getQueue() {
            return this.queue;
        }

        public void setQueue(PriorityQueue<EventFactHandle> queue) {
            this.queue = queue;
        }

        public EventFactHandle getExpiringHandle() {
            return this.expiringHandle;
        }

        public void setExpiringTuple(EventFactHandle expiringHandle) {
            this.expiringHandle = expiringHandle;
        }
    }
}

