/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import java.util.HashMap;
import java.util.Map;
import org.drools.common.BaseNode;
import org.drools.common.InternalRuleBase;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.PropagationQueuingNode;
import org.drools.reteoo.QueryRiaFixerNode;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.RuleTerminalNode;

public class RuleBaseNodes {
    public static Map<Integer, BaseNode> getNodeMap(InternalRuleBase ruleBase) {
        HashMap<Integer, BaseNode> nodes = new HashMap<Integer, BaseNode>();
        RuleBaseNodes.buildNodeMap(ruleBase, nodes);
        return nodes;
    }

    private static void buildNodeMap(InternalRuleBase ruleBase, Map<Integer, BaseNode> nodes) {
        for (ObjectTypeNode sink : ruleBase.getRete().getObjectTypeNodes()) {
            nodes.put(sink.getId(), sink);
            RuleBaseNodes.addObjectSink(ruleBase, sink, nodes);
        }
    }

    private static void addObjectSink(InternalRuleBase ruleBase, ObjectSink sink, Map<Integer, BaseNode> nodes) {
        if (sink instanceof PropagationQueuingNode) {
            nodes.put(sink.getId(), (BaseNode)((Object)sink));
        }
        if (sink instanceof LeftTupleSource) {
            LeftTupleSource node = (LeftTupleSource)((Object)sink);
            for (LeftTupleSink leftTupleSink : node.getSinkPropagator().getSinks()) {
                RuleBaseNodes.addLeftTupleSink(ruleBase, leftTupleSink, nodes);
            }
        } else {
            ObjectSource node = (ObjectSource)((Object)sink);
            for (ObjectSink objectSink : node.getSinkPropagator().getSinks()) {
                RuleBaseNodes.addObjectSink(ruleBase, objectSink, nodes);
            }
        }
    }

    private static void addLeftTupleSink(InternalRuleBase ruleBase, LeftTupleSink sink, Map<Integer, BaseNode> nodes) {
        if (sink instanceof QueryRiaFixerNode) {
            nodes.put(sink.getId(), (LeftTupleSource)((Object)sink));
            RuleBaseNodes.addLeftTupleSink(ruleBase, ((QueryRiaFixerNode)sink).getBetaNode(), nodes);
        } else if (sink instanceof LeftTupleSource) {
            nodes.put(sink.getId(), (LeftTupleSource)((Object)sink));
            for (LeftTupleSink leftTupleSink : ((LeftTupleSource)((Object)sink)).getSinkPropagator().getSinks()) {
                RuleBaseNodes.addLeftTupleSink(ruleBase, leftTupleSink, nodes);
            }
        } else if (sink instanceof ObjectSource) {
            nodes.put(sink.getId(), (ObjectSource)((Object)sink));
            for (ObjectSink objectSink : ((ObjectSource)((Object)sink)).getSinkPropagator().getSinks()) {
                RuleBaseNodes.addObjectSink(ruleBase, objectSink, nodes);
            }
        } else if (sink instanceof RuleTerminalNode) {
            nodes.put(sink.getId(), (RuleTerminalNode)sink);
        } else if (sink instanceof QueryTerminalNode) {
            nodes.put(sink.getId(), (QueryTerminalNode)sink);
        }
    }
}

