/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.factmodel.BuildUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.factmodel.traits.MapWrapper;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitPropertyWrapperClassBuilder;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitRegistry;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.WriteAccessor;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

public class TraitMapPropertyWrapperClassBuilderImpl
implements TraitPropertyWrapperClassBuilder,
Serializable {
    private transient Map<String, FieldDefinition> aliases;
    private transient ClassDefinition trait;
    private transient TraitRegistry traitRegistry;

    @Override
    public void init(ClassDefinition trait, TraitRegistry traitRegistry) {
        this.trait = trait;
        this.traitRegistry = traitRegistry;
    }

    @Override
    public byte[] buildClass(ClassDefinition core) throws IOException, IntrospectionException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        FieldVisitor fv;
        ClassWriter cw = new ClassWriter(1);
        long mask = this.traitRegistry.getFieldMask(this.trait.getName(), core.getDefinedClass().getName());
        String name = TraitFactory.getPropertyWrapperName(this.trait, core);
        String internalWrapper = BuildUtils.getInternalType(name);
        String descrCore = Type.getDescriptor(core.getDefinedClass());
        String internalCore = Type.getInternalName(core.getDefinedClass());
        this.aliases = new HashMap<String, FieldDefinition>();
        for (FieldDefinition tfld : this.trait.getFieldsDefinitions()) {
            String alias;
            FieldDefinition coreField;
            if (!tfld.hasAlias() || (coreField = core.getField(alias = tfld.getAlias())) == null) continue;
            this.aliases.put(tfld.getName(), coreField);
        }
        cw.visit(49, 33, internalWrapper, Type.getDescriptor(Object.class) + Type.getDescriptor(Map.class) + Type.getDescriptor(MapWrapper.class), Type.getInternalName(Object.class), new String[]{Type.getInternalName(Map.class), Type.getInternalName(MapWrapper.class), Type.getInternalName(Serializable.class)});
        cw.visitInnerClass(Type.getInternalName(Map.Entry.class), Type.getInternalName(Map.class), "Entry", 1545);
        for (FieldDefinition fld : core.getFieldsDefinitions()) {
            fv = cw.visitField(9, fld.getName() + "_reader", Type.getDescriptor(InternalReadAccessor.class), null, null);
            fv.visitEnd();
            fv = cw.visitField(9, fld.getName() + "_writer", Type.getDescriptor(WriteAccessor.class), null, null);
            fv.visitEnd();
        }
        fv = cw.visitField(0, "object", descrCore, null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "map", Type.getDescriptor(Map.class), "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + descrCore + Type.getDescriptor(Map.class) + ")V", "(" + descrCore + "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, internalWrapper, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, internalCore, "setDynamicProperties", "(" + Type.getDescriptor(Map.class) + ")V");
        int stackSize = this.initSoftFields(mv, this.trait, mask, 2);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        this.buildSize((ClassVisitor)cw, name, core.getClassName(), this.trait, core, mask);
        this.buildIsEmpty((ClassVisitor)cw, name, core.getClassName(), this.trait, core, mask);
        this.buildGet((ClassVisitor)cw, name, core.getClassName(), this.trait, core, mask);
        this.buildPut((ClassVisitor)cw, name, core.getClassName(), this.trait, core, mask);
        this.buildClear(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildRemove(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildContainsKey(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildContainsValue(cw, name, core.getClassName(), this.trait, core, mask);
        this.buildKeyset((ClassVisitor)cw, name, core.getClassName(), this.trait, core, mask);
        this.buildValues((ClassVisitor)cw, name, core.getClassName(), this.trait, core, mask);
        this.buildEntryset((ClassVisitor)cw, name, core.getClassName(), this.trait, core, mask);
        this.buildCommonMethods((ClassVisitor)cw, name);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void invokeRemove(MethodVisitor mv, String wrapperName, ClassDefinition core, String fieldName, FieldDefinition field) {
        mv.visitLdcInsn((Object)fieldName);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(String.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        TraitFactory.invokeExtractor(mv, wrapperName, this.trait, core, field);
        if (BuildUtils.isPrimitive(field.getTypeName())) {
            TraitFactory.valueOf(mv, field.getTypeName());
        }
        mv.visitVarInsn(58, 2);
        TraitFactory.invokeInjector(mv, wrapperName, this.trait, core, field, true, 1);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitLabel(l1);
    }

    private void buildRemove(ClassWriter cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "remove", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            this.invokeRemove(mv, wrapperName, core, field.getName(), field);
        }
        for (String alias : this.aliases.keySet()) {
            this.invokeRemove(mv, wrapperName, core, alias, this.aliases.get(alias));
        }
        int j = 0;
        int stack = 0;
        for (FieldDefinition field : trait.getFieldsDefinitions()) {
            boolean isSoftField = TraitRegistry.isSoftField(field, j++, mask);
            if (!isSoftField) continue;
            stack = Math.max(stack, BuildUtils.sizeOf(field.getTypeName()));
            mv.visitLdcInsn((Object)field.getName());
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, Type.getInternalName(String.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
            Label l2 = new Label();
            mv.visitJumpInsn(153, l2);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
            mv.visitLdcInsn((Object)field.getName());
            mv.visitMethodInsn(185, Type.getInternalName(Map.class), "get", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
            mv.visitVarInsn(58, 2);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
            mv.visitLdcInsn((Object)field.getName());
            mv.visitInsn(BuildUtils.zero(field.getTypeName()));
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitMethodInsn(185, Type.getInternalName(Map.class), "put", "(" + Type.getDescriptor(Object.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
            mv.visitInsn(87);
            mv.visitVarInsn(25, 2);
            mv.visitInsn(176);
            mv.visitLabel(l2);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "remove", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private int initSoftFields(MethodVisitor mv, ClassDefinition trait, long mask, int varNum) {
        int j = 0;
        int stackSize = 0;
        for (FieldDefinition field : trait.getFieldsDefinitions()) {
            boolean isSoftField = TraitRegistry.isSoftField(field, j++, mask);
            if (!isSoftField) continue;
            mv.visitVarInsn(25, varNum);
            mv.visitLdcInsn((Object)field.getName());
            mv.visitInsn(BuildUtils.zero(field.getTypeName()));
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
                int size = BuildUtils.sizeOf(field.getTypeName());
                stackSize = Math.max(stackSize, size);
            } else {
                stackSize = Math.max(stackSize, 2);
            }
            mv.visitMethodInsn(185, Type.getInternalName(Map.class), "put", "(" + Type.getDescriptor(Object.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
            mv.visitInsn(87);
        }
        return stackSize;
    }

    private void buildClear(ClassWriter cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        boolean hasPrimitiveFields = false;
        boolean hasObjectFields = false;
        MethodVisitor mv = cw.visitMethod(1, "clear", "()V", null, null);
        mv.visitCode();
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            if (field.isKey()) continue;
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                hasPrimitiveFields = true;
            } else {
                hasObjectFields = true;
            }
            TraitFactory.invokeInjector(mv, wrapperName, trait, core, field, true, 1);
        }
        int stack = 2;
        if (hasPrimitiveFields) {
            ++stack;
        }
        if (hasObjectFields) {
            ++stack;
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "clear", "()V");
        int num = this.initSoftFields(mv, trait, mask, 0);
        stack += num;
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildContainsValue(ClassWriter cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "containsValue", "(" + Type.getDescriptor(Object.class) + ")Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        Label l99 = new Label();
        mv.visitJumpInsn(199, l99);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            if (BuildUtils.isPrimitive(field.getTypeName())) continue;
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            Label l1 = new Label();
            mv.visitJumpInsn(199, l1);
            mv.visitInsn(4);
            mv.visitInsn(172);
            mv.visitLabel(l1);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitInsn(1);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "containsValue", "(" + Type.getDescriptor(Object.class) + ")Z");
        mv.visitInsn(172);
        mv.visitLabel(l99);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitMethodInsn(182, Type.getInternalName(Object.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
            Label l0 = new Label();
            mv.visitJumpInsn(153, l0);
            mv.visitInsn(4);
            mv.visitInsn(172);
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "containsValue", "(" + Type.getDescriptor(Object.class) + ")Z");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void invokeContainsKey(MethodVisitor mv, String fieldName) {
        mv.visitLdcInsn((Object)fieldName);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(String.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l0);
    }

    private void buildContainsKey(ClassWriter cw, String name, String className, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(name);
        MethodVisitor mv = cw.visitMethod(1, "containsKey", "(" + Type.getDescriptor(Object.class) + ")Z", null, null);
        mv.visitCode();
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            this.invokeContainsKey(mv, field.getName());
        }
        for (String alias : this.aliases.keySet()) {
            this.invokeContainsKey(mv, alias);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "containsKey", "(" + Type.getDescriptor(Object.class) + ")Z");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildSize(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "size", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "size", "()I");
        int n = core.getFieldsDefinitions().size();
        for (int j = 0; j < n; ++j) {
            mv.visitInsn(4);
            mv.visitInsn(96);
        }
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildIsEmpty(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        boolean hasHardFields = core.getFieldsDefinitions().size() > 0;
        MethodVisitor mv = cw.visitMethod(1, "isEmpty", "()Z", null, null);
        mv.visitCode();
        if (!hasHardFields) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
            mv.visitMethodInsn(185, Type.getInternalName(Map.class), "isEmpty", "()Z");
        } else {
            mv.visitInsn(3);
        }
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void invokeGet(MethodVisitor mv, String wrapperName, ClassDefinition core, String fieldName, FieldDefinition field) {
        mv.visitLdcInsn((Object)fieldName);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(String.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        TraitFactory.invokeExtractor(mv, wrapperName, this.trait, core, field);
        if (BuildUtils.isPrimitive(field.getTypeName())) {
            TraitFactory.valueOf(mv, field.getTypeName());
        }
        mv.visitInsn(176);
        mv.visitLabel(l0);
    }

    private void buildGet(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "get", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        if (core.getFieldsDefinitions().size() > 0) {
            for (FieldDefinition field : core.getFieldsDefinitions()) {
                this.invokeGet(mv, wrapperName, core, field.getName(), field);
            }
        }
        for (String alias : this.aliases.keySet()) {
            this.invokeGet(mv, wrapperName, core, alias, this.aliases.get(alias));
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "get", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void invokePut(MethodVisitor mv, String wrapperName, ClassDefinition core, String fieldName, FieldDefinition field) {
        mv.visitLdcInsn((Object)fieldName);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(String.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitVarInsn(25, 2);
        if (BuildUtils.isPrimitive(field.getTypeName())) {
            TraitFactory.promote(mv, field.getTypeName());
            mv.visitVarInsn(BuildUtils.storeType(field.getTypeName()), 3);
            TraitFactory.invokeInjector(mv, wrapperName, this.trait, core, field, false, 3);
        } else {
            TraitFactory.invokeInjector(mv, wrapperName, this.trait, core, field, false, 2);
        }
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitLabel(l1);
    }

    private void buildPut(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "put", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        if (core.getFieldsDefinitions().size() > 0) {
            for (FieldDefinition field : core.getFieldsDefinitions()) {
                this.invokePut(mv, wrapperName, core, field.getName(), field);
            }
        }
        for (String alias : this.aliases.keySet()) {
            this.invokePut(mv, wrapperName, core, alias, this.aliases.get(alias));
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "put", "(" + Type.getDescriptor(Object.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildEntryset(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "entrySet", "()" + Type.getDescriptor(Set.class), "()Ljava/util/Set<Ljava/util/Map$Entry<Ljava/lang/String;Ljava/lang/Object;>;>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(HashSet.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(HashSet.class), "<init>", "()V");
        mv.visitVarInsn(58, 1);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)field.getName());
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitMethodInsn(184, Type.getInternalName(TraitProxy.class), "buildEntry", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Map.Entry.class));
            mv.visitMethodInsn(185, Type.getInternalName(Set.class), "add", "(" + Type.getDescriptor(Object.class) + ")Z");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "entrySet", "()" + Type.getDescriptor(Set.class));
        mv.visitMethodInsn(185, Type.getInternalName(Set.class), "addAll", "(" + Type.getDescriptor(Collection.class) + ")Z");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildKeyset(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "keySet", "()" + Type.getDescriptor(Set.class), "()Ljava/util/Set<Ljava/lang/String;>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(HashSet.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(HashSet.class), "<init>", "()V");
        mv.visitVarInsn(58, 1);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn((Object)field.getName());
            mv.visitMethodInsn(185, Type.getInternalName(Set.class), "add", "(" + Type.getDescriptor(Object.class) + ")Z");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "keySet", "()" + Type.getDescriptor(Set.class));
        mv.visitMethodInsn(185, Type.getInternalName(Set.class), "addAll", "(" + Type.getDescriptor(Collection.class) + ")Z");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void buildValues(ClassVisitor cw, String wrapperName, String coreName, ClassDefinition trait, ClassDefinition core, long mask) {
        String internalWrapper = BuildUtils.getInternalType(wrapperName);
        MethodVisitor mv = cw.visitMethod(1, "values", "()" + Type.getDescriptor(Collection.class), "()Ljava/util/Collection<Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(ArrayList.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(ArrayList.class), "<init>", "()V");
        mv.visitVarInsn(58, 1);
        for (FieldDefinition field : core.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            TraitFactory.invokeExtractor(mv, wrapperName, trait, core, field);
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                TraitFactory.valueOf(mv, field.getTypeName());
            }
            mv.visitMethodInsn(185, Type.getInternalName(Collection.class), "add", "(" + Type.getDescriptor(Object.class) + ")Z");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalWrapper, "map", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "values", "()" + Type.getDescriptor(Collection.class));
        mv.visitMethodInsn(185, Type.getInternalName(Collection.class), "addAll", "(" + Type.getDescriptor(Collection.class) + ")Z");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void buildCommonMethods(ClassVisitor cw, String wrapper) {
        MethodVisitor mv = cw.visitMethod(4161, "put", "(" + Type.getDescriptor(Object.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(String.class));
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(wrapper), "put", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "equals", "(" + Type.getDescriptor(Object.class) + ")Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(166, l0);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(MapWrapper.class));
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapper), "map", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(185, Type.getInternalName(MapWrapper.class), "getInnerMap", "()" + Type.getDescriptor(Map.class));
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapper), "map", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "hashCode", "()I");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getInnerMap", "()" + Type.getDescriptor(Map.class), "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapper), "map", Type.getDescriptor(Map.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "putAll", "(" + Type.getDescriptor(Map.class) + ")V", "(Ljava/util/Map<+Ljava/lang/String;+Ljava/lang/Object;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "keySet", "()" + Type.getDescriptor(Set.class));
        mv.visitMethodInsn(185, Type.getInternalName(Set.class), "iterator", "()" + Type.getDescriptor(Iterator.class));
        mv.visitVarInsn(58, 2);
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(185, Type.getInternalName(Iterator.class), "hasNext", "()Z");
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(185, Type.getInternalName(Iterator.class), "next", "()" + Type.getDescriptor(Object.class));
        mv.visitTypeInsn(192, Type.getInternalName(String.class));
        mv.visitVarInsn(58, 3);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "get", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitMethodInsn(182, BuildUtils.getInternalType(wrapper), "put", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitInsn(87);
        mv.visitJumpInsn(167, l0);
        mv.visitLabel(l1);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "toString", "()" + Type.getDescriptor(String.class), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", "()V");
        mv.visitLdcInsn((Object)"[[");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(StringBuilder.class));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(wrapper), "entrySet", "()" + Type.getDescriptor(Set.class));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(StringBuilder.class));
        mv.visitLdcInsn((Object)"]]");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(StringBuilder.class));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "toString", "()" + Type.getDescriptor(String.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

