/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.drools.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.Traitable;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.factmodel.traits.VetoableTypedMap;

@Traitable
public class Entity
implements TraitableBean<Entity, Entity>,
Serializable {
    private String id;
    private Map<String, Object> __$$dynamic_properties_map$$;
    private Map<String, Thing<Entity>> __$$dynamic_traits_map$$;

    public Entity() {
        this.id = UUID.randomUUID().toString();
    }

    public Entity(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this.__$$dynamic_properties_map$$;
    }

    @Override
    public void setDynamicProperties(Map map) {
        this.__$$dynamic_properties_map$$ = map;
    }

    @Override
    public void setTraitMap(Map map) {
        this.__$$dynamic_traits_map$$ = new VetoableTypedMap(map);
    }

    @Override
    public Map<String, Thing<Entity>> getTraitMap() {
        return this.__$$dynamic_traits_map$$;
    }

    @Override
    public void addTrait(String type, Thing proxy) throws LogicalTypeInconsistencyException {
        ((VetoableTypedMap)this.getTraitMap()).putSafe(type, proxy);
    }

    @Override
    public Thing getTrait(String type) {
        return this.getTraitMap().get(type);
    }

    @Override
    public boolean hasTrait(String type) {
        return this.isTraitMapInitialized() && this.getTraitMap().containsKey(type);
    }

    @Override
    public Thing removeTrait(String type) {
        if (this.isTraitMapInitialized()) {
            return this.getTraitMap().remove(type);
        }
        return null;
    }

    @Override
    public Collection<String> getTraits() {
        if (this.isTraitMapInitialized()) {
            return this.getTraitMap().keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public void denyTrait(Class trait) throws LogicalTypeInconsistencyException {
        ((VetoableTypedMap)this.__$$dynamic_traits_map$$).addToVetoable(trait);
    }

    @Override
    public void allowTrait(Class trait) {
        ((VetoableTypedMap)this.__$$dynamic_traits_map$$).removeFromVetoable(trait);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity that = (Entity)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean isTraitMapInitialized() {
        return this.__$$dynamic_traits_map$$ != null;
    }
}

