/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.reteoo.LeftTuple;

public class LeftTupleSets {
    private LeftTuple insertFirst;
    private int insertSize;
    private LeftTuple deleteFirst;
    private int deleteSize;
    private LeftTuple updateFirst;
    private int updateSize;

    public LeftTuple getInsertFirst() {
        return this.insertFirst;
    }

    public LeftTuple getDeleteFirst() {
        return this.deleteFirst;
    }

    public LeftTuple getUpdateFirst() {
        return this.updateFirst;
    }

    public void resetInsert() {
        this.insertFirst = null;
        this.insertSize = 0;
    }

    public void resetDelete() {
        this.deleteFirst = null;
        this.deleteSize = 0;
    }

    public void resetUpdate() {
        this.updateFirst = null;
        this.updateSize = 0;
    }

    public void resetAll() {
        this.resetInsert();
        this.resetDelete();
        this.resetUpdate();
    }

    public int insertSize() {
        return this.insertSize;
    }

    public int deleteSize() {
        return this.insertSize;
    }

    public int updateSize() {
        return this.updateSize;
    }

    public void addInsert(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)1);
        if (this.insertFirst == null) {
            this.insertFirst = leftTuple;
        } else {
            leftTuple.setStagedNext(this.insertFirst);
            this.insertFirst.setStagePrevious(leftTuple);
            this.insertFirst = leftTuple;
        }
        ++this.insertSize;
    }

    public void addDelete(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)3);
        if (this.deleteFirst == null) {
            this.deleteFirst = leftTuple;
        } else {
            leftTuple.setStagedNext(this.deleteFirst);
            this.deleteFirst.setStagePrevious(leftTuple);
            this.deleteFirst = leftTuple;
        }
        ++this.deleteSize;
    }

    public void addUpdate(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)2);
        if (this.updateFirst == null) {
            this.updateFirst = leftTuple;
        } else {
            leftTuple.setStagedNext(this.updateFirst);
            this.updateFirst.setStagePrevious(leftTuple);
            this.updateFirst = leftTuple;
        }
        ++this.updateSize;
    }

    public void removeInsert(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.insertFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.insertFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        --this.insertSize;
        leftTuple.clearStaged();
    }

    public void removeDelete(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.deleteFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.deleteFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        --this.deleteSize;
        leftTuple.clearStaged();
    }

    public void removeUpdate(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.updateFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.updateFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        leftTuple.clearStaged();
        --this.updateSize;
    }

    public void addAllInserts(LeftTupleSets tupleSets) {
        if (this.insertFirst == null) {
            this.insertFirst = tupleSets.getInsertFirst();
            this.insertSize = tupleSets.insertSize;
        } else {
            LeftTuple last = null;
            for (LeftTuple current = this.insertFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            LeftTuple leftTuple = tupleSets.getInsertFirst();
            last.setStagedNext(leftTuple);
            leftTuple.setStagePrevious(leftTuple);
            this.insertSize += tupleSets.insertSize();
        }
    }

    public void addAllDeletes(LeftTupleSets tupleSets) {
        if (this.deleteFirst == null) {
            this.deleteFirst = tupleSets.getDeleteFirst();
            this.deleteSize = tupleSets.deleteSize;
        } else {
            LeftTuple last = null;
            for (LeftTuple current = this.deleteFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            LeftTuple leftTuple = tupleSets.getDeleteFirst();
            last.setStagedNext(leftTuple);
            leftTuple.setStagePrevious(leftTuple);
            this.deleteSize += tupleSets.deleteSize();
        }
    }

    public void addAllUpdates(LeftTupleSets tupleSets) {
        if (this.updateFirst == null) {
            this.updateFirst = tupleSets.getUpdateFirst();
            this.updateSize = tupleSets.updateSize;
        } else {
            LeftTuple last = null;
            for (LeftTuple current = this.updateFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            LeftTuple leftTuple = tupleSets.getUpdateFirst();
            last.setStagedNext(leftTuple);
            leftTuple.setStagePrevious(leftTuple);
            this.updateSize += tupleSets.updateSize();
        }
    }

    public void addAll(LeftTupleSets source) {
        this.addAllInserts(source);
        this.addAllDeletes(source);
        this.addAllUpdates(source);
    }

    public void clear() {
        LeftTuple next;
        LeftTuple leftTuple = this.getInsertFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = this.getDeleteFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = this.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            leftTuple.clearStaged();
            leftTuple = next;
        }
        this.resetAll();
    }

    public String toStringSizes() {
        return "TupleSets[insertSize=" + this.insertSize + ", deleteSize=" + this.deleteSize + ", updateSize=" + this.updateSize + "]";
    }

    public String toString() {
        LeftTuple leftTuple;
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("Inserted:\n");
        for (leftTuple = this.getInsertFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            sbuilder.append(" " + leftTuple + "\n");
        }
        sbuilder.append("Deleted:\n");
        for (leftTuple = this.getDeleteFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            sbuilder.append(" " + leftTuple + "\n");
        }
        sbuilder.append("Updated:\n");
        for (leftTuple = this.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            sbuilder.append(" " + leftTuple + "\n");
        }
        return sbuilder.toString();
    }
}

