/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.kie.runtime.rule.AccumulateFunction;

public class CountAccumulateFunction
implements AccumulateFunction {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Serializable createContext() {
        return new CountData();
    }

    public void init(Serializable context) throws Exception {
        CountData data = (CountData)context;
        data.count = 0L;
    }

    public void accumulate(Serializable context, Object value) {
        CountData data = (CountData)context;
        ++data.count;
    }

    public void reverse(Serializable context, Object value) throws Exception {
        CountData data = (CountData)context;
        --data.count;
    }

    public Object getResult(Serializable context) throws Exception {
        CountData data = (CountData)context;
        return new Long(data.count);
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return Number.class;
    }

    protected static class CountData
    implements Externalizable {
        public long count = 0L;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.count = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.count);
        }
    }
}

