/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.beliefsystem.BeliefSet;
import org.drools.common.AbstractRuleBase;
import org.drools.common.AgendaItem;
import org.drools.common.DefaultAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemoryActions;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.LogicalDependency;
import org.drools.common.ObjectTypeConfigurationRegistry;
import org.drools.common.SimpleLogicalDependency;
import org.drools.common.TruthMaintenanceSystemHelper;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.factmodel.traits.CoreWrapper;
import org.drools.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.kie.event.rule.ActivationUnMatchListener;
import org.kie.runtime.Channel;
import org.kie.runtime.KieRuntime;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.process.NodeInstance;
import org.kie.runtime.process.NodeInstanceContainer;
import org.kie.runtime.process.ProcessContext;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.WorkflowProcessInstance;
import org.kie.runtime.rule.Match;
import org.kie.runtime.rule.Session;
import org.kie.runtime.rule.SessionEntryPoint;

public class DefaultKnowledgeHelper
implements KnowledgeHelper,
Externalizable {
    private static final long serialVersionUID = 510L;
    private Activation activation;
    private Tuple tuple;
    private InternalWorkingMemoryActions workingMemory;
    private IdentityHashMap<Object, FactHandle> identityMap;
    private LinkedList<LogicalDependency> previousJustified;
    private LinkedList<LogicalDependency> previousBlocked;

    public DefaultKnowledgeHelper() {
    }

    public DefaultKnowledgeHelper(WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.identityMap = null;
    }

    public DefaultKnowledgeHelper(Activation activation, WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.activation = activation;
        this.identityMap = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.activation = (Activation)in.readObject();
        this.tuple = (Tuple)in.readObject();
        this.workingMemory = (InternalWorkingMemoryActions)in.readObject();
        this.identityMap = (IdentityHashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.activation);
        out.writeObject(this.tuple);
        out.writeObject(this.workingMemory);
        out.writeObject(this.identityMap);
    }

    @Override
    public void setActivation(Activation agendaItem) {
        this.activation = agendaItem;
        this.previousJustified = agendaItem.getLogicalDependencies();
        this.previousBlocked = agendaItem.getBlocked();
        agendaItem.setLogicalDependencies(null);
        agendaItem.setBlocked(null);
        this.tuple = agendaItem.getTuple();
    }

    @Override
    public void reset() {
        this.activation = null;
        this.tuple = null;
        this.identityMap = null;
        this.previousJustified = null;
        this.previousBlocked = null;
    }

    public LinkedList<LogicalDependency> getpreviousJustified() {
        return this.previousJustified;
    }

    public void blockMatch(Match act) {
        AgendaItem targetMatch = (AgendaItem)act;
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (targetMatch != dep.getJustified()) continue;
                this.previousJustified.remove(dep);
                break;
            }
        }
        if (dep == null) {
            dep = new SimpleLogicalDependency(this.activation, targetMatch);
        }
        this.activation.addBlocked(dep);
        if (targetMatch.getBlockers().size() == 1 && targetMatch.isActive()) {
            targetMatch.remove();
            if (targetMatch.getActivationGroupNode() != null) {
                targetMatch.getActivationGroupNode().getActivationGroup().removeActivation(targetMatch);
            }
            if (targetMatch.getActivationNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)targetMatch.getActivationNode().getParentContainer();
                ruleFlowGroup.removeActivation(targetMatch);
            }
        }
    }

    public void unblockAllMatches(Match act) {
        AgendaItem targetMatch = (AgendaItem)act;
        boolean wasBlocked = targetMatch.getBlockers() != null && !targetMatch.getBlockers().isEmpty();
        LinkedListEntry entry = targetMatch.getBlockers().getFirst();
        while (entry != null) {
            LinkedListEntry tmp = (LinkedListEntry)entry.getNext();
            LogicalDependency dep = entry.getObject();
            ((AgendaItem)dep.getJustifier()).removeBlocked(dep);
            entry = tmp;
        }
        if (wasBlocked) {
            ((DefaultAgenda)this.workingMemory.getAgenda()).getStageActivationsGroup().addActivation(targetMatch);
        }
    }

    @Override
    public FactHandle insert(Object object) {
        return this.insert(object, false);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) throws FactException {
        FactHandle handle = this.workingMemory.insert(object, null, dynamic, false, this.activation.getRule(), this.activation);
        if (this.identityMap != null) {
            this.getIdentityMap().put(object, handle);
        }
        return handle;
    }

    @Override
    public void insertLogical(Object object) {
        this.insertLogical(object, false);
    }

    @Override
    public void insertLogical(Object object, boolean dynamic) {
        this.insertLogical(object, null, dynamic);
    }

    public void insertLogical(Object object, Object value) {
        this.insertLogical(object, value, false);
    }

    public void insertLogical(Object object, Object value, boolean dynamic) {
        if (!this.activation.isMatched()) {
            return;
        }
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (!object.equals(((BeliefSet)dep.getJustified()).getFactHandle().getObject())) continue;
                this.previousJustified.remove(dep);
                break;
            }
        }
        if (dep != null) {
            this.activation.addLogicalDependency(dep);
        } else {
            FactHandle handle = this.workingMemory.insert(object, value, dynamic, true, this.activation.getRule(), this.activation);
            if (this.identityMap != null) {
                this.getIdentityMap().put(object, handle);
            }
        }
    }

    @Override
    public void cancelRemainingPreviousLogicalDependencies() {
        LogicalDependency dep;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                TruthMaintenanceSystemHelper.removeLogicalDependency(dep, this.activation.getPropagationContext());
            }
        }
        if (this.previousBlocked != null) {
            dep = this.previousBlocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.previousBlocked.remove(dep);
                AgendaItem justified = (AgendaItem)dep.getJustified();
                justified.getBlockers().remove(dep.getJustifierEntry());
                if (justified.getBlockers().isEmpty()) {
                    ((DefaultAgenda)this.workingMemory.getAgenda()).getStageActivationsGroup().addActivation(justified);
                }
                dep = tmp;
            }
        }
    }

    public void cancelMatch(Match act) {
        AgendaItem match = (AgendaItem)act;
        match.cancel();
        if (match.isActive()) {
            LeftTuple leftTuple = match.getTuple();
            leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, (PropagationContext)act.getPropagationContext(), this.workingMemory);
        }
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        FactHandle handle = null;
        if (this.identityMap != null) {
            handle = this.identityMap.get(object);
        }
        if (handle != null) {
            return handle;
        }
        handle = this.getFactHandleFromWM(object);
        if (handle == null) {
            throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        return handle;
    }

    @Override
    public FactHandle getFactHandle(FactHandle handle) {
        Object object = ((InternalFactHandle)handle).getObject();
        if ((handle = this.getFactHandleFromWM(object)) == null) {
            throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        return handle;
    }

    @Override
    public void update(FactHandle handle, Object newObject) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, newObject, Long.MAX_VALUE, this.activation);
        if (this.getIdentityMap() != null) {
            this.getIdentityMap().put(newObject, handle);
        }
    }

    @Override
    public void update(FactHandle handle) {
        this.update(handle, Long.MAX_VALUE);
    }

    @Override
    public void update(FactHandle handle, long mask) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, ((InternalFactHandle)handle).getObject(), mask, this.activation);
    }

    @Override
    public void update(Object object) {
        this.update(object, Long.MAX_VALUE);
    }

    @Override
    public void update(Object object, long mask) {
        this.update(this.getFactHandle(object), mask);
    }

    @Override
    public void retract(Object object) {
        this.retract(this.getFactHandle(object));
    }

    @Override
    public void retract(FactHandle handle) {
        ((InternalWorkingMemoryEntryPoint)((InternalFactHandle)handle).getEntryPoint()).delete(handle, this.activation.getRule(), this.activation);
        if (this.identityMap != null) {
            this.getIdentityMap().remove(((InternalFactHandle)handle).getObject());
        }
    }

    @Override
    public Rule getRule() {
        return this.activation.getRule();
    }

    @Override
    public Tuple getTuple() {
        return this.tuple;
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public KnowledgeRuntime getKnowledgeRuntime() {
        return ((ReteooWorkingMemory)this.workingMemory).getKnowledgeRuntime();
    }

    @Override
    public Activation getMatch() {
        return this.activation;
    }

    @Override
    public void setFocus(String focus) {
        this.workingMemory.setFocus(focus);
    }

    @Override
    public Object get(Declaration declaration) {
        InternalWorkingMemoryEntryPoint wmTmp = (InternalWorkingMemoryEntryPoint)this.tuple.get(declaration).getEntryPoint();
        if (wmTmp != null) {
            Object object = declaration.getValue(wmTmp.getInternalWorkingMemory(), this.tuple.get(declaration).getObject());
            if (this.identityMap != null) {
                this.getIdentityMap().put(object, wmTmp.getFactHandleByIdentity(object));
            }
            return object;
        }
        return null;
    }

    @Override
    public Declaration getDeclaration(String identifier) {
        return ((AgendaItem)this.activation).getRuleTerminalNode().getSubRule().getOuterDeclarations().get(identifier);
    }

    @Override
    public void halt() {
        this.workingMemory.halt();
    }

    @Override
    public SessionEntryPoint getEntryPoint(String id) {
        return this.workingMemory.getEntryPoints().get(id);
    }

    @Override
    public Channel getChannel(String id) {
        return this.workingMemory.getChannels().get(id);
    }

    @Override
    public Map<String, SessionEntryPoint> getEntryPoints() {
        return Collections.unmodifiableMap(this.workingMemory.getEntryPoints());
    }

    @Override
    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.workingMemory.getChannels());
    }

    @Override
    public IdentityHashMap<Object, FactHandle> getIdentityMap() {
        return this.identityMap;
    }

    @Override
    public void setIdentityMap(IdentityHashMap<Object, FactHandle> identityMap) {
        this.identityMap = identityMap;
    }

    private FactHandle getFactHandleFromWM(Object object) {
        FactHandle handle = null;
        for (SessionEntryPoint sessionEntryPoint : this.workingMemory.getEntryPoints().values()) {
            handle = (FactHandle)sessionEntryPoint.getFactHandle(object);
            if (this.identityMap != null) {
                this.identityMap.put(object, handle);
            }
            if (handle == null) continue;
            break;
        }
        return handle;
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        Map<Long, String> nodeInstances;
        String ruleflowGroupName;
        if (ProcessContext.class.equals(contextClass) && (ruleflowGroupName = this.getMatch().getRule().getRuleFlowGroup()) != null && !(nodeInstances = ((InternalRuleFlowGroup)this.workingMemory.getAgenda().getRuleFlowGroup(ruleflowGroupName)).getNodeInstances()).isEmpty()) {
            if (nodeInstances.size() > 1) {
                throw new UnsupportedOperationException("Not supporting multiple node instances for the same ruleflow group");
            }
            Map.Entry<Long, String> entry = nodeInstances.entrySet().iterator().next();
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(entry.getKey());
            org.drools.spi.ProcessContext context = new org.drools.spi.ProcessContext((KieRuntime)this.workingMemory.getKnowledgeRuntime());
            context.setProcessInstance(processInstance);
            String nodeInstance = entry.getValue();
            String[] nodeInstanceIds = nodeInstance.split(":");
            WorkflowProcessInstance container = (WorkflowProcessInstance)processInstance;
            block0: for (int i = 0; i < nodeInstanceIds.length; ++i) {
                for (NodeInstance subNodeInstance : container.getNodeInstances()) {
                    if (subNodeInstance.getId() != new Long(nodeInstanceIds[i]).longValue()) continue;
                    if (i == nodeInstanceIds.length - 1) {
                        context.setNodeInstance(subNodeInstance);
                        continue block0;
                    }
                    container = (NodeInstanceContainer)subNodeInstance;
                }
            }
            return (T)context;
        }
        return null;
    }

    @Override
    public <T, K> T don(K core, Class<T> trait, boolean logical) {
        try {
            T thing = this.applyTrait(core, trait, logical);
            return this.doInsertTrait(thing, logical);
        }
        catch (LogicalTypeInconsistencyException ltie) {
            ltie.printStackTrace();
            return null;
        }
    }

    protected <T> T doInsertTrait(T thing, boolean logical) {
        FactHandle fh = this.insert(thing);
        if (logical) {
            AgendaItem agendaItem = (AgendaItem)this.activation;
            RetractTrait newUnMatch = new RetractTrait(fh);
            ActivationUnMatchListener unmatch = agendaItem.getActivationUnMatchListener();
            if (unmatch != null) {
                newUnMatch.setNext((RetractTrait)unmatch);
            }
            agendaItem.setActivationUnMatchListener(newUnMatch);
        }
        return thing;
    }

    public KieRuntime getKieRuntime() {
        return this.getKnowledgeRuntime();
    }

    protected <T, K> T applyTrait(K core, Class<T> trait, boolean logical) throws LogicalTypeInconsistencyException {
        TraitableBean inner;
        AbstractRuleBase arb = (AbstractRuleBase)((KnowledgeBaseImpl)this.getKnowledgeRuntime().getKieBase()).getRuleBase();
        TraitFactory builder = arb.getConfiguration().getComponentFactory().getTraitFactory();
        boolean needsWrapping = !(core instanceof TraitableBean);
        TraitableBean traitableBean = inner = needsWrapping ? this.asTraitable(core, builder) : (TraitableBean)core;
        if (needsWrapping) {
            InternalFactHandle h = (InternalFactHandle)this.getFactHandle(core);
            InternalWorkingMemoryEntryPoint ep = (InternalWorkingMemoryEntryPoint)h.getEntryPoint();
            ObjectTypeConfigurationRegistry reg = ep.getObjectTypeConfigurationRegistry();
            ObjectTypeConf coreConf = reg.getObjectTypeConf(ep.getEntryPoint(), core);
            ObjectTypeConf innerConf = reg.getObjectTypeConf(ep.getEntryPoint(), inner);
            if (coreConf.isTMSEnabled()) {
                innerConf.enableTMS();
            }
        }
        return this.processTraits(core, trait, builder, needsWrapping, inner, logical);
    }

    protected <K> TraitableBean asTraitable(K core, TraitFactory builder) {
        CoreWrapper<?> wrapper = builder.getCoreWrapper(core.getClass());
        if (wrapper == null) {
            throw new UnsupportedOperationException("Error: cannot apply a trait to non-traitable class " + core.getClass());
        }
        wrapper.init(core);
        return wrapper;
    }

    protected <T, K> T processTraits(K core, Class<T> trait, TraitFactory builder, boolean needsUpdate, TraitableBean inner, boolean logical) throws LogicalTypeInconsistencyException {
        if (inner.hasTrait(trait.getName())) {
            return (T)inner.getTrait(trait.getName());
        }
        Object thing = builder.getProxy(inner, trait);
        if (needsUpdate) {
            this.update(this.getFactHandle(core), inner);
        }
        if (!inner.hasTrait(Thing.class.getName())) {
            this.don(inner, Thing.class, logical);
        }
        return thing;
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait, boolean logical) {
        return this.don(core.getCore(), trait, logical);
    }

    @Override
    public <T, K> T don(K core, Class<T> trait) {
        return this.don(core, trait, false);
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait) {
        return this.don(core.getCore(), trait);
    }

    @Override
    public <T, K> Thing<K> shed(Thing<K> thing, Class<T> trait) {
        return this.shed((TraitableBean)thing.getCore(), trait);
    }

    @Override
    public <T, K> Thing<K> shed(TraitableBean<K> core, Class<T> trait) {
        this.retract(core.removeTrait(trait.getName()));
        Thing<K> thing = core.getTrait(Thing.class.getName());
        this.update(thing);
        return thing;
    }

    @Override
    public <T, K> Thing<K> ward(Thing<K> thing, Class<T> trait) {
        try {
            ((TraitableBean)thing.getCore()).denyTrait(trait);
            return thing;
        }
        catch (LogicalTypeInconsistencyException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public <T, K> Thing<K> ward(K core, Class<T> trait) {
        Thing thing = this.don(core, Thing.class);
        try {
            ((TraitableBean)thing.getCore()).denyTrait(trait);
            return thing;
        }
        catch (LogicalTypeInconsistencyException e) {
            return null;
        }
    }

    @Override
    public <T, K> Thing<K> grant(Thing<K> thing, Class<T> trait) {
        ((TraitableBean)thing.getCore()).allowTrait(trait);
        return thing;
    }

    @Override
    public <T, K> Thing<K> grant(K core, Class<T> trait) {
        Thing thing = this.don(core, Thing.class);
        ((TraitableBean)thing.getCore()).allowTrait(trait);
        return thing;
    }

    @Override
    public void modify(Object newObject) {
    }

    public static class RetractTrait
    implements ActivationUnMatchListener {
        private FactHandle fh;
        private RetractTrait next;

        public RetractTrait(FactHandle fh) {
            this.fh = fh;
        }

        public void unMatch(Session wm, Match activation) {
            wm.retract((org.kie.runtime.rule.FactHandle)this.fh);
            if (this.next != null) {
                this.next.unMatch(wm, activation);
            }
        }

        public FactHandle getFh() {
            return this.fh;
        }

        public void setFh(FactHandle fh) {
            this.fh = fh;
        }

        public RetractTrait getNext() {
            return this.next;
        }

        public void setNext(RetractTrait next) {
            this.next = next;
        }
    }
}

