/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.drools.xml.PomModel;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MinimalPomParser
extends DefaultHandler {
    private int depth;
    private boolean inParent;
    private PomModel model = new PomModel();
    private StringBuilder characters;
    private Document document;

    public static PomModel parse(String path, InputStream is) {
        MinimalPomParser handler = new MinimalPomParser();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse File '" + path + "'", e);
        }
        return handler.getPomModel();
    }

    public PomModel getPomModel() {
        return this.model;
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        if ("parent".equals(qname) && this.depth == 1) {
            this.inParent = true;
        } else if ("groupId".equals(qname) || "artifactId".equals(qname) || "version".equals(qname)) {
            this.characters = new StringBuilder();
        }
        ++this.depth;
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (this.inParent) {
            String text;
            String string = text = this.characters != null ? this.characters.toString() : null;
            if (text != null) {
                if ("groupId".equals(qname)) {
                    this.model.setParentGroupId(text);
                } else if ("artifactId".equals(qname)) {
                    this.model.setParentArtifactId(text);
                } else if ("version".equals(qname)) {
                    this.model.setParentVersion(text);
                }
            }
            if ("parent".equals(qname) && this.depth == 2) {
                this.inParent = false;
            }
        } else if (this.depth == 2) {
            String text;
            String string = text = this.characters != null ? this.characters.toString() : null;
            if (text != null) {
                if ("groupId".equals(qname)) {
                    this.model.setGroupId(text);
                } else if ("artifactId".equals(qname)) {
                    this.model.setArtifactId(text);
                } else if ("version".equals(qname)) {
                    this.model.setVersion(text);
                }
            }
        }
        this.characters = null;
        --this.depth;
    }

    @Override
    public void characters(char[] chars, int start, int len) {
        if (this.characters != null) {
            this.characters.append(chars, start, len);
        }
    }
}

