/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.List;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.MemoryFactory;
import org.drools.common.StagedLeftTuples;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.RuleMemory;

public class SegmentMemory
extends LinkedList<SegmentMemory>
implements LinkedListNode<SegmentMemory> {
    private LeftTupleSource rootNode;
    private LeftTupleSource tipNode;
    private LinkedList<Memory> nodeMemories;
    private long linkedNodeMask;
    private long allLinkedMaskTest;
    private List<RuleMemory> ruleMemories;
    private long segmentPosMaskBit;
    private int pos;
    private StagedLeftTuples stagedLeftTuples;
    private int counter;
    private boolean active;
    private SegmentMemory previous;
    private SegmentMemory next;

    public SegmentMemory(LeftTupleSource rootNode) {
        this.rootNode = rootNode;
        this.ruleMemories = new ArrayList<RuleMemory>(1);
        this.nodeMemories = new LinkedList();
        this.stagedLeftTuples = new StagedLeftTuples();
    }

    public LeftTupleSource getRootNode() {
        return this.rootNode;
    }

    public LeftTupleSource getTipNode() {
        return this.tipNode;
    }

    public void setTipNode(LeftTupleSource tipNode) {
        this.tipNode = tipNode;
    }

    public Memory createNodeMemory(MemoryFactory memoryFactory, InternalWorkingMemory wm) {
        Memory memory = wm.getNodeMemory(memoryFactory);
        this.nodeMemories.add(memory);
        return memory;
    }

    public LinkedList<Memory> getNodeMemories() {
        return this.nodeMemories;
    }

    public long getLinkedNodeMask() {
        return this.linkedNodeMask;
    }

    public void setLinkedNodeMask(long linkedSegmentMask) {
        this.linkedNodeMask = linkedSegmentMask;
    }

    public void linkNode(long mask, InternalWorkingMemory wm) {
        this.linkedNodeMask |= mask;
        if (this.isSegmentLinked()) {
            this.notifyRuleLinkSegment(wm);
        }
    }

    public void notifyRuleLinkSegment(InternalWorkingMemory wm) {
        int length = this.ruleMemories.size();
        for (int i = 0; i < length; ++i) {
            this.ruleMemories.get(i).linkSegment(this.segmentPosMaskBit, wm);
        }
    }

    public void unlinkNode(long mask, InternalWorkingMemory wm) {
        if (this.isSegmentLinked()) {
            int length = this.ruleMemories.size();
            for (int i = 0; i < length; ++i) {
                this.ruleMemories.get(i).unlinkedSegment(this.segmentPosMaskBit, wm);
            }
        }
        this.linkedNodeMask ^= mask;
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public boolean isSegmentLinked() {
        return (this.linkedNodeMask & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    public List<RuleMemory> getRuleMemories() {
        return this.ruleMemories;
    }

    public void setRuleMemories(List<RuleMemory> ruleSegments) {
        this.ruleMemories = ruleSegments;
    }

    public long getSegmentPosMaskBit() {
        return this.segmentPosMaskBit;
    }

    public void setSegmentPosMaskBit(long nodeSegmenMask) {
        this.segmentPosMaskBit = nodeSegmenMask;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean evaluating) {
        this.active = evaluating;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public StagedLeftTuples getStagedLeftTuples() {
        return this.stagedLeftTuples;
    }

    public void setStagedTuples(StagedLeftTuples stagedTuples) {
        this.stagedLeftTuples = stagedTuples;
    }

    @Override
    public void setNext(SegmentMemory next) {
        this.next = next;
    }

    @Override
    public SegmentMemory getNext() {
        return this.next;
    }

    @Override
    public SegmentMemory getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(SegmentMemory previous) {
        this.previous = previous;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 * this.rootNode.getId();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentMemory other = (SegmentMemory)obj;
        return !(this.rootNode == null ? other.rootNode != null : this.rootNode.getId() != other.rootNode.getId());
    }
}

