/*
 * Decompiled with CFR 0.152.
 */
package org.drools.phreak;

import java.util.List;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.base.DroolsQuery;
import org.drools.common.AgendaItem;
import org.drools.common.BaseNode;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.StagedLeftTuples;
import org.drools.common.StagedRightTuples;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.RightTupleList;
import org.drools.phreak.SegmentPropagator;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ExistsNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.NodeTypeEnums;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.RiaRuleMemory;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.RuleMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.SegmentMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.Rule;
import org.drools.spi.PropagationContext;

public class RuleNetworkEvaluatorActivation
extends AgendaItem {
    private RuleMemory rmem;
    private PhreakLianNode pLiaNode = new PhreakLianNode();
    private PhreakJoinNode pJoinNode = new PhreakJoinNode();
    private PhreakNotNode pNotNode = new PhreakNotNode();
    private PhreakExistsNode pExistsNode = new PhreakExistsNode();
    private PhreakRuleTerminalNode pRtnNode = new PhreakRuleTerminalNode();

    public RuleNetworkEvaluatorActivation() {
    }

    public RuleNetworkEvaluatorActivation(long activationNumber, LeftTuple tuple, int salience, PropagationContext context, RuleMemory rmem, RuleTerminalNode rtn) {
        super(activationNumber, tuple, salience, context, rtn);
        this.rmem = rmem;
    }

    public int evaluateNetwork(InternalWorkingMemory wm) {
        SegmentMemory[] smems = this.rmem.getSegmentMemories();
        int smemIndex = 0;
        SegmentMemory smem = smems[smemIndex];
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)smem.getRootNode();
        LinkedList<Memory> nodeMemories = smem.getNodeMemories();
        LeftInputAdapterNode.LiaNodeMemory liaNodeMemory = (LeftInputAdapterNode.LiaNodeMemory)nodeMemories.getFirst();
        StagedLeftTuples trgTuples = new StagedLeftTuples();
        StagedLeftTuples srcTuples = smem.getStagedLeftTuples();
        this.pLiaNode.doNode(liaNode, liaNodeMemory, wm, srcTuples, trgTuples);
        LeftTupleSource node = null;
        Memory nodeMem = null;
        if (liaNode == smem.getTipNode()) {
            SegmentPropagator.propagate(smem, trgTuples, wm);
            smem = smems[smemIndex];
            nodeMem = smem.getNodeMemories().getFirst();
            node = smem.getRootNode();
        } else {
            node = (LeftTupleSource)((Object)liaNode.getSinkPropagator().getFirstLeftTupleSink());
            nodeMem = (Memory)liaNodeMemory.getNext();
        }
        this.eval(node, nodeMem, smems, smemIndex, trgTuples, null, wm);
        return 0;
    }

    public StagedLeftTuples eval(LeftTupleSource node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, StagedLeftTuples trgTuples, StagedLeftTuples stagedLeftTuples, InternalWorkingMemory wm) {
        StagedLeftTuples srcTuples = null;
        boolean foundSegmentTip = false;
        SegmentMemory smem = smems[smemIndex];
        while (true) {
            srcTuples = trgTuples;
            if (NodeTypeEnums.isTerminalNode(node)) break;
            if (71 == node.getType()) {
                return trgTuples;
            }
            if (nodeMem == null) {
                SegmentPropagator.propagate(smem, trgTuples, wm);
                smem = smems[smemIndex++];
                node = smem.getRootNode();
                nodeMem = smem.getNodeMemories().getFirst();
            }
            stagedLeftTuples = node == smem.getTipNode() && smem.getFirst() != null ? ((SegmentMemory)smem.getFirst()).getStagedLeftTuples() : null;
            trgTuples = new StagedLeftTuples();
            if (NodeTypeEnums.isBetaNode(node)) {
                BetaNode betaNode = (BetaNode)node;
                BetaMemory bm = (BetaMemory)nodeMem;
                if (betaNode.isRightInputIsRiaNode()) {
                    StagedLeftTuples peerTuples = new StagedLeftTuples();
                    SegmentPropagator.processPeers(srcTuples, peerTuples, betaNode);
                    SegmentMemory subSmem = bm.getSubnetworkSegmentMemory();
                    StagedLeftTuples subnetworkStaged = subSmem.getStagedLeftTuples();
                    subnetworkStaged.addAllDeletes(srcTuples.getDeleteFirst());
                    subnetworkStaged.addAllUpdates(srcTuples.getUpdateFirst());
                    subnetworkStaged.addAllInserts(srcTuples.getInsertFirst());
                    List<RuleMemory> ruleMemories = subSmem.getRuleMemories();
                    RiaRuleMemory rm = null;
                    if (ruleMemories.size() == 1) {
                        rm = (RiaRuleMemory)ruleMemories.get(0);
                    } else {
                        int size = ruleMemories.size();
                        for (int i = 0; i < size; ++i) {
                            if (!(ruleMemories.get(i) instanceof RiaRuleMemory)) continue;
                            rm = (RiaRuleMemory)ruleMemories.get(i);
                        }
                    }
                    RightInputAdapterNode riaNode = (RightInputAdapterNode)betaNode.getRightInput();
                    StagedLeftTuples riaStagedTuples = this.eval(subSmem.getRootNode(), subSmem.getNodeMemories().getFirst(), rm.getSegmentMemories(), 0, srcTuples, null, wm);
                    StagedRightTuples riaStageRight = bm.getStagedRightTuples();
                    for (LeftTuple leftTuple = riaStagedTuples.getInsertFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
                        InternalFactHandle handle = riaNode.createFactHandle(leftTuple, leftTuple.getPropagationContext(), wm);
                        RightTuple rightTuple = betaNode.createRightTuple(handle, betaNode, leftTuple.getPropagationContext());
                    }
                }
                switch (node.getType()) {
                    case 181: {
                        this.pJoinNode.doNode((JoinNode)node, node.getSinkPropagator().getFirstLeftTupleSink(), bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 191: {
                        this.pNotNode.doNode((NotNode)node, node.getSinkPropagator().getFirstLeftTupleSink(), bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 201: {
                        this.pExistsNode.doNode((ExistsNode)node, node.getSinkPropagator().getFirstLeftTupleSink(), bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                    }
                }
            }
            if (node.getSinkPropagator().size() > 1) {
                stagedLeftTuples = new StagedLeftTuples();
                LeftTupleSource subNetworkNode = (LeftTupleSource)((Object)node.getSinkPropagator().getFirstLeftTupleSink());
            }
            node = (LeftTupleSource)((Object)node.getSinkPropagator().getFirstLeftTupleSink());
            nodeMem = (Memory)nodeMem.getNext();
        }
        RuleTerminalNode rtn = this.rmem.getRuleTerminalNode();
        this.pRtnNode.doNode(rtn, wm, srcTuples);
        return null;
    }

    public int evaluateSegment(SegmentMemory smem, InternalWorkingMemory wm) {
        return 0;
    }

    public static void evaluateLazyItems(WorkingMemory wm) {
        InternalWorkingMemory iwm = (InternalWorkingMemory)wm;
        Map<Rule, BaseNode[]> map = ((InternalRuleBase)iwm.getRuleBase()).getReteooBuilder().getTerminalNodes();
        for (BaseNode[] nodes : map.values()) {
            for (BaseNode node : nodes) {
                RuleTerminalNode rtn = (RuleTerminalNode)node;
                RuleMemory rs = (RuleMemory)iwm.getNodeMemory(rtn);
                RuleNetworkEvaluatorActivation item = rs.getAgendaItem();
                if (item == null) continue;
                item.dequeue();
                int count = item.evaluateNetwork(iwm);
                if (count <= 0) continue;
                ((InternalAgenda)iwm.getAgenda()).addActivation(item);
            }
        }
    }

    @Override
    public boolean isRuleNetworkEvaluatorActivation() {
        return true;
    }

    public static LeftTuple deleteLeftChild(StagedLeftTuples trgLeftTuples, LeftTuple childLeftTuple, StagedLeftTuples stagedLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
            }
        }
        LeftTuple next = childLeftTuple.getLeftParentNext();
        trgLeftTuples.addDelete(childLeftTuple);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return next;
    }

    public static LeftTuple deleteRightChild(LeftTuple childLeftTuple, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
            }
        }
        LeftTuple next = childLeftTuple.getRightParentNext();
        trgLeftTuples.addDelete(childLeftTuple);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return next;
    }

    public static void dpUpdatesReorderMemory(BetaMemory bm, InternalWorkingMemory wm, StagedRightTuples srcRightTuples, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples) {
        LeftTuple childNext;
        LeftTuple childLeftTuple;
        Entry next;
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        RightTupleMemory rtm = bm.getRightTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            ltm.removeAdd(leftTuple);
            childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                childNext = childLeftTuple.getLeftParentNext();
                childLeftTuple.reAddRight();
                childLeftTuple = childNext;
            }
            leftTuple = next;
        }
        Entry rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            rtm.removeAdd((RightTuple)rightTuple);
            childLeftTuple = rightTuple.getFirstChild();
            while (childLeftTuple != null) {
                childNext = childLeftTuple.getLeftParentNext();
                childLeftTuple.reAddLeft();
                childLeftTuple = childNext;
            }
            rightTuple = next;
        }
    }

    public static void removeBlocker(LeftTuple leftTuple, RightTuple blocker) {
        blocker.removeBlocked(leftTuple);
        leftTuple.clearBlocker();
    }

    public static class PhreakRuleTerminalNode {
        public void doNode(RuleTerminalNode rtnNode, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples) {
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(rtnNode, wm, srcLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(rtnNode, wm, srcLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(rtnNode, wm, srcLeftTuples);
            }
        }

        public void doLeftInserts(RuleTerminalNode rtnNode, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                rtnNode.assertLeftTuple(leftTuple, leftTuple.getPropagationContext(), wm);
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcLeftTuples.setInsert(null, 0);
        }

        public void doLeftUpdates(RuleTerminalNode rtnNode, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                rtnNode.modifyLeftTuple(leftTuple, leftTuple.getPropagationContext(), wm);
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcLeftTuples.setUpdate(null);
        }

        public void doLeftDeletes(RuleTerminalNode rtnNode, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                rtnNode.retractLeftTuple(leftTuple, leftTuple.getPropagationContext(), wm);
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcLeftTuples.setDelete(null);
        }
    }

    public static class PhreakExistsNode {
        public void doNode(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            StagedRightTuples srcRightTuples = bm.getStagedRightTuples();
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(existsNode, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(existsNode, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null || srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluatorActivation.dpUpdatesReorderMemory(bm, wm, srcRightTuples, srcLeftTuples, trgLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(existsNode, sink, bm, wm, srcRightTuples, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(existsNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(existsNode, sink, bm, wm, srcRightTuples, srcLeftTuples, trgLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(existsNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
            }
            srcRightTuples.setInsert(null, 0);
            srcRightTuples.setDelete(null);
            srcRightTuples.setUpdate(null);
            srcLeftTuples.setInsert(null, 0);
            srcLeftTuples.setDelete(null);
            srcLeftTuples.setUpdate(null);
        }

        public void doLeftInserts(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            FastIterator it = existsNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                Object object;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                boolean useLeftMemory = true;
                if (!(tupleMemoryEnabled || (object = ((InternalFactHandle)context.getFactHandle()).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                    useLeftMemory = false;
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RightTuple rightTuple = existsNode.getFirstRightTuple(leftTuple, rtm, context, it);
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        leftTuple.setBlocker(rightTuple);
                        if (!useLeftMemory) break;
                        rightTuple.addBlocked(leftTuple);
                        break;
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
                if (leftTuple.getBlocker() != null) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                } else if (useLeftMemory) {
                    ltm.add(leftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcLeftTuples.setInsert(null, 0);
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedRightTuples srcRightTuples, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            FastIterator it = existsNode.getLeftIterator(ltm);
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = existsNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)it.next(leftTuple);
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                    }
                    leftTuple = temp;
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            srcRightTuples.setInsert(null, 0);
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftUpdates(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            boolean tupleMemory = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            FastIterator rightIt = existsNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple childLeftTuple;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                RightTuple firstRightTuple = existsNode.getFirstRightTuple(leftTuple, rtm, context, rightIt);
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    if (leftTuple.getMemory().isStagingMemory()) {
                        leftTuple.getMemory().remove(leftTuple);
                    } else {
                        ltm.remove(leftTuple);
                    }
                    leftTuple.setMemory(null);
                } else if (rtm.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
                    RuleNetworkEvaluatorActivation.removeBlocker(leftTuple, blocker);
                    blocker = null;
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                if (blocker == null || !constraints.isAllowedCachedLeft(contextEntry, blocker.getFactHandle())) {
                    if (blocker != null) {
                        RuleNetworkEvaluatorActivation.removeBlocker(leftTuple, blocker);
                    }
                    RightTuple newBlocker = firstRightTuple;
                    while (newBlocker != null) {
                        if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)rightIt.next(newBlocker);
                    }
                }
                if (leftTuple.getBlocker() == null) {
                    ltm.add(leftTuple);
                    if (leftTuple.getFirstChild() != null && leftTuple.getFirstChild() != null) {
                        childLeftTuple = leftTuple.getFirstChild();
                        while (childLeftTuple != null) {
                            childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(trgLeftTuples, childLeftTuple, stagedLeftTuples);
                        }
                    }
                } else if (leftTuple.getFirstChild() == null) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                } else if (leftTuple.getFirstChild() != null) {
                    for (childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        trgLeftTuples.addUpdate(childLeftTuple);
                        childLeftTuple.reAddRight();
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcLeftTuples.setUpdate(null);
            constraints.resetTuple(contextEntry);
        }

        public void doRightUpdates(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedRightTuples srcRightTuples, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            boolean tupleMemory = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            FastIterator leftIt = existsNode.getLeftIterator(ltm);
            FastIterator rightIt = existsNode.getRightIterator(rtm);
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                PropagationContext context = rightTuple.getPropagationContext();
                LeftTuple firstLeftTuple = existsNode.getFirstLeftTuple(rightTuple, ltm, context, leftIt);
                LeftTuple firstBlocked = rightTuple.getBlocked();
                rightTuple.nullBlocked();
                LeftTuple leftTuple = firstLeftTuple;
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                    }
                    leftTuple = temp;
                }
                if (firstBlocked != null) {
                    boolean useComparisonIndex = rtm.getIndexType().isComparison();
                    RightTuple rootBlocker = useComparisonIndex ? null : (RightTuple)rightIt.next(rightTuple);
                    RightTupleList list = rightTuple.getMemory();
                    rtm.removeAdd(rightTuple);
                    if (!useComparisonIndex && rootBlocker == null && list == rightTuple.getMemory()) {
                        rootBlocker = rightTuple;
                    }
                    LeftTuple leftTuple2 = firstBlocked;
                    while (leftTuple2 != null) {
                        LeftTuple temp = leftTuple2.getBlockedNext();
                        leftTuple2.clearBlocker();
                        constraints.updateFromTuple(contextEntry, wm, leftTuple2);
                        if (useComparisonIndex) {
                            rootBlocker = existsNode.getFirstRightTuple(leftTuple2, rtm, context, rightIt);
                        }
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple2.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple2);
                                break;
                            }
                            newBlocker = (RightTuple)rightIt.next(newBlocker);
                        }
                        if (leftTuple2.getBlocker() == null) {
                            ltm.add(leftTuple2);
                            LeftTuple childLeftTuple = leftTuple2.getFirstChild();
                            while (childLeftTuple != null) {
                                childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(trgLeftTuples, childLeftTuple, stagedLeftTuples);
                            }
                        }
                        leftTuple2 = temp;
                    }
                } else {
                    rtm.removeAdd(rightTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            srcRightTuples.setUpdate(null);
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftDeletes(ExistsNode existsNode, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    ltm.remove(leftTuple);
                } else {
                    if (leftTuple.getFirstChild() != null) {
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        while (childLeftTuple != null) {
                            childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(trgLeftTuples, childLeftTuple, stagedLeftTuples);
                        }
                    }
                    blocker.removeBlocked(leftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcLeftTuples.setDelete(null);
        }

        public void doRightDeletes(ExistsNode existsNode, BetaMemory bm, InternalWorkingMemory wm, StagedRightTuples srcRightTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            boolean tupleMemory = true;
            RightTupleMemory rtm = bm.getRightTupleMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            FastIterator it = existsNode.getRightIterator(rtm);
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.remove(rightTuple);
                rightTuple.setMemory(null);
                RightTuple rootBlocker = (RightTuple)it.next(rightTuple);
                if (rightTuple.getBlocked() == null) {
                    return;
                }
                LeftTuple leftTuple = rightTuple.getBlocked();
                while (leftTuple != null) {
                    LeftTuple temp = leftTuple.getBlockedNext();
                    leftTuple.clearBlocker();
                    constraints.updateFromTuple(contextEntry, wm, leftTuple);
                    RightTuple newBlocker = rootBlocker;
                    while (newBlocker != null) {
                        if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)it.next(newBlocker);
                    }
                    if (leftTuple.getBlocker() == null) {
                        ltm.add(leftTuple);
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        while (childLeftTuple != null) {
                            childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(trgLeftTuples, childLeftTuple, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
                rightTuple.nullBlocked();
                rightTuple.clearStaged();
                rightTuple = next;
            }
            srcRightTuples.setDelete(null);
        }
    }

    public static class PhreakNotNode {
        public void doNode(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            StagedRightTuples srcRightTuples = bm.getStagedRightTuples();
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(notNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
            }
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(notNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null || srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluatorActivation.dpUpdatesReorderMemory(bm, wm, srcRightTuples, srcLeftTuples, trgLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(notNode, sink, bm, wm, srcRightTuples, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(notNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(notNode, sink, bm, wm, srcRightTuples, srcLeftTuples, trgLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(notNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
            }
            srcRightTuples.setInsert(null, 0);
            srcRightTuples.setDelete(null);
            srcRightTuples.setUpdate(null);
            srcLeftTuples.setInsert(null, 0);
            srcLeftTuples.setDelete(null);
            srcLeftTuples.setUpdate(null);
        }

        public void doLeftInserts(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            FastIterator it = notNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                Object object;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                boolean useLeftMemory = true;
                if (!(tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                    useLeftMemory = false;
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RightTuple rightTuple = notNode.getFirstRightTuple(leftTuple, rtm, context, it);
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        leftTuple.setBlocker(rightTuple);
                        if (!useLeftMemory) break;
                        rightTuple.addBlocked(leftTuple);
                        break;
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
                if (leftTuple.getBlocker() == null) {
                    if (useLeftMemory) {
                        ltm.add(leftTuple);
                    }
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedRightTuples srcRightTuples, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            FastIterator it = notNode.getLeftIterator(ltm);
            StagedLeftTuples stagedLeftTuples = null;
            if (!bm.getSegmentMemory().isEmpty()) {
                stagedLeftTuples = ((SegmentMemory)bm.getSegmentMemory().getFirst()).getStagedLeftTuples();
            }
            if (bm.getSegmentMemory().isSegmentLinked() && !notNode.isRightInputIsRiaNode() && notNode.isEmptyBetaConstraints()) {
                bm.unlinkNode(wm);
            }
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = notNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)it.next(leftTuple);
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        RuleNetworkEvaluatorActivation.deleteLeftChild(trgLeftTuples, leftTuple, stagedLeftTuples);
                    }
                    leftTuple = temp;
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftUpdates(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            FastIterator rightIt = notNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                RightTuple firstRightTuple = notNode.getFirstRightTuple(leftTuple, rtm, context, rightIt);
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    ltm.remove(leftTuple);
                } else if (rtm.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
                    RuleNetworkEvaluatorActivation.removeBlocker(leftTuple, blocker);
                    blocker = null;
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                if (blocker == null || !constraints.isAllowedCachedLeft(contextEntry, blocker.getFactHandle())) {
                    if (blocker != null) {
                        RuleNetworkEvaluatorActivation.removeBlocker(leftTuple, blocker);
                    }
                    RightTuple newBlocker = firstRightTuple;
                    while (newBlocker != null) {
                        if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)rightIt.next(newBlocker);
                    }
                    LeftTuple childLeftTuple = leftTuple.getFirstChild();
                    if (leftTuple.getBlocker() != null) {
                        if (leftTuple.getFirstChild() != null) {
                            RuleNetworkEvaluatorActivation.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    } else if (childLeftTuple == null) {
                        ltm.add(leftTuple);
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                    } else {
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        ltm.add(leftTuple);
                        trgLeftTuples.addUpdate(childLeftTuple);
                        childLeftTuple.reAddLeft();
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightUpdates(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedRightTuples srcRightTuples, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            FastIterator leftIt = notNode.getLeftIterator(ltm);
            FastIterator rightIt = notNode.getRightIterator(rtm);
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                if (bm.getLeftTupleMemory() == null || bm.getLeftTupleMemory().size() == 0 && rightTuple.getBlocked() == null) {
                    bm.getRightTupleMemory().removeAdd(rightTuple);
                    rightTuple.clearStaged();
                    rightTuple = next;
                    continue;
                }
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple firstLeftTuple = notNode.getFirstLeftTuple(rightTuple, ltm, context, leftIt);
                LeftTuple firstBlocked = rightTuple.getBlocked();
                rightTuple.nullBlocked();
                LeftTuple leftTuple = firstLeftTuple;
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        if (leftTuple.getFirstChild() != null) {
                            RuleNetworkEvaluatorActivation.deleteRightChild(leftTuple.getFirstChild(), trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
                if (firstBlocked != null) {
                    boolean useComparisonIndex = rtm.getIndexType().isComparison();
                    RightTuple rootBlocker = useComparisonIndex ? null : (RightTuple)rightIt.next(rightTuple);
                    RightTupleList list = rightTuple.getMemory();
                    rtm.removeAdd(rightTuple);
                    if (!useComparisonIndex && rootBlocker == null && list == rightTuple.getMemory()) {
                        rootBlocker = rightTuple;
                    }
                    LeftTuple leftTuple2 = firstBlocked;
                    while (leftTuple2 != null) {
                        LeftTuple temp = leftTuple2.getBlockedNext();
                        leftTuple2.clearBlocker();
                        constraints.updateFromTuple(contextEntry, wm, leftTuple2);
                        if (useComparisonIndex) {
                            rootBlocker = notNode.getFirstRightTuple(leftTuple2, rtm, context, rightIt);
                        }
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple2.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple2);
                                break;
                            }
                            newBlocker = (RightTuple)rightIt.next(newBlocker);
                        }
                        if (leftTuple2.getBlocker() == null) {
                            ltm.add(leftTuple2);
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple2, sink, tupleMemory));
                        }
                        leftTuple2 = temp;
                    }
                } else {
                    rtm.removeAdd(rightTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
            constraints.resetTuple(contextEntry);
        }

        public void doLeftDeletes(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    ltm.remove(leftTuple);
                    LeftTuple childLeftTuple = leftTuple.getFirstChild();
                    if (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(trgLeftTuples, childLeftTuple, stagedLeftTuples);
                    }
                } else {
                    blocker.removeBlocked(leftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doRightDeletes(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedRightTuples srcRightTuples, StagedLeftTuples trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            FastIterator it = notNode.getRightIterator(rtm);
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                RightTuple rootBlocker = (RightTuple)it.next(rightTuple);
                rtm.remove(rightTuple);
                if (rightTuple.getBlocked() != null) {
                    PropagationContext context = rightTuple.getPropagationContext();
                    LeftTuple leftTuple = rightTuple.getBlocked();
                    while (leftTuple != null) {
                        LeftTuple temp = leftTuple.getBlockedNext();
                        leftTuple.clearBlocker();
                        constraints.updateFromTuple(contextEntry, wm, leftTuple);
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple);
                                break;
                            }
                            newBlocker = (RightTuple)it.next(newBlocker);
                        }
                        if (leftTuple.getBlocker() == null) {
                            ltm.add(leftTuple);
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                        }
                        leftTuple = temp;
                    }
                }
                rightTuple.nullBlocked();
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }
    }

    public static class PhreakJoinNode {
        public void doNode(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            StagedRightTuples srcRightTuples = bm.getStagedRightTuples();
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(joinNode, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(joinNode, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null || srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluatorActivation.dpUpdatesReorderMemory(bm, wm, srcRightTuples, srcLeftTuples, trgLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(joinNode, sink, bm, wm, srcRightTuples, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(joinNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(joinNode, sink, bm, wm, srcRightTuples, srcLeftTuples, trgLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(joinNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
            }
            srcRightTuples.setInsert(null, 0);
            srcRightTuples.setDelete(null);
            srcRightTuples.setUpdate(null);
            srcLeftTuples.setInsert(null, 0);
            srcLeftTuples.setDelete(null);
            srcLeftTuples.setUpdate(null);
        }

        public void doLeftInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            FastIterator it = joinNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                Object object;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                boolean useLeftMemory = true;
                if (!(tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                    useLeftMemory = false;
                }
                if (useLeftMemory) {
                    ltm.add(leftTuple);
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, context, it);
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcLeftTuples.setInsert(null, 0);
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedRightTuples srcRightTuples, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            FastIterator it = joinNode.getLeftIterator(ltm);
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                while (leftTuple != null) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            srcRightTuples.setInsert(null, 0);
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            boolean tupleMemory = true;
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            FastIterator it = joinNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, context, it);
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                if (childLeftTuple != null && rtm.isIndexed() && !it.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(trgLeftTuples, childLeftTuple, stagedLeftTuples);
                    }
                }
                if (rightTuple != null) {
                    this.doLeftUpdatesProcessChildren(childLeftTuple, leftTuple, rightTuple, stagedLeftTuples, tupleMemory, contextEntry, constraints, sink, it, trgLeftTuples);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcLeftTuples.setUpdate(null);
            constraints.resetTuple(contextEntry);
        }

        public LeftTuple doLeftUpdatesProcessChildren(LeftTuple childLeftTuple, LeftTuple leftTuple, RightTuple rightTuple, StagedLeftTuples stagedLeftTuples, boolean tupleMemory, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, StagedLeftTuples trgLeftTuples) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
            } else {
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                        } else {
                            switch (childLeftTuple.getStagedType()) {
                                case 1: {
                                    stagedLeftTuples.removeInsert(childLeftTuple);
                                    break;
                                }
                                case 2: {
                                    stagedLeftTuples.removeUpdate(childLeftTuple);
                                }
                            }
                            trgLeftTuples.addUpdate(childLeftTuple);
                            childLeftTuple.reAddRight();
                            childLeftTuple = childLeftTuple.getLeftParentNext();
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(trgLeftTuples, childLeftTuple, stagedLeftTuples);
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
            }
            return childLeftTuple;
        }

        public void doRightUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, StagedRightTuples srcRightTuples, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            boolean tupleMemory = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            FastIterator it = joinNode.getLeftIterator(ltm);
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                PropagationContext context = rightTuple.getPropagationContext();
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                LeftTuple leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                if (childLeftTuple != null && ltm.isIndexed() && !it.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                if (leftTuple != null) {
                    this.doRightUpdatesProcessChildren(childLeftTuple, leftTuple, rightTuple, stagedLeftTuples, tupleMemory, contextEntry, constraints, sink, it, trgLeftTuples);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            srcRightTuples.setUpdate(null);
            constraints.resetFactHandle(contextEntry);
        }

        public LeftTuple doRightUpdatesProcessChildren(LeftTuple childLeftTuple, LeftTuple leftTuple, RightTuple rightTuple, StagedLeftTuples stagedLeftTuples, boolean tupleMemory, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, StagedLeftTuples trgLeftTuples) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            } else {
                while (leftTuple != null) {
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        if (childLeftTuple == null || childLeftTuple.getLeftParent() != leftTuple) {
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                        } else {
                            switch (childLeftTuple.getStagedType()) {
                                case 1: {
                                    stagedLeftTuples.removeInsert(childLeftTuple);
                                    break;
                                }
                                case 2: {
                                    stagedLeftTuples.removeUpdate(childLeftTuple);
                                }
                            }
                            trgLeftTuples.addUpdate(childLeftTuple);
                            childLeftTuple.reAddLeft();
                            childLeftTuple = childLeftTuple.getRightParentNext();
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            }
            return childLeftTuple;
        }

        public void doLeftDeletes(JoinNode joinNode, BetaMemory bm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                ltm.remove(leftTuple);
                if (leftTuple.getFirstChild() != null) {
                    LeftTuple childLeftTuple = leftTuple.getFirstChild();
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(trgLeftTuples, childLeftTuple, stagedLeftTuples);
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcLeftTuples.setDelete(null);
        }

        public void doRightDeletes(JoinNode joinNode, BetaMemory bm, InternalWorkingMemory wm, StagedRightTuples srcRightTuples, StagedLeftTuples trgLeftTuples, StagedLeftTuples stagedLeftTuples) {
            RightTupleMemory rtm = bm.getRightTupleMemory();
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.remove(rightTuple);
                if (rightTuple.getFirstChild() != null) {
                    LeftTuple childLeftTuple = rightTuple.getFirstChild();
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            srcRightTuples.setDelete(null);
        }
    }

    public static class PhreakLianNode {
        public void doNode(LeftInputAdapterNode liaNode, LeftInputAdapterNode.LiaNodeMemory lm, InternalWorkingMemory wm, StagedLeftTuples srcLeftTuples, StagedLeftTuples trgLeftTuples) {
            int size = srcLeftTuples.insertSize();
            trgLeftTuples.setInsert(srcLeftTuples.getInsertFirst(), srcLeftTuples.insertSize());
            srcLeftTuples.setInsert(null, 0);
            trgLeftTuples.setDelete(srcLeftTuples.getDeleteFirst());
            trgLeftTuples.setUpdate(srcLeftTuples.getUpdateFirst());
            srcLeftTuples.setDelete(null);
            srcLeftTuples.setUpdate(null);
        }
    }
}

