/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import org.drools.io.impl.BaseResource;
import org.drools.io.internal.InternalResource;
import org.kie.io.Resource;

public class EncodedResource
extends BaseResource
implements InternalResource,
Externalizable {
    private InternalResource resource;
    private String encoding;

    public EncodedResource(Resource resource) {
        this(resource, null);
    }

    public EncodedResource(Resource resource, String encoding) {
        if (resource == null) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        this.resource = (InternalResource)resource;
        this.encoding = encoding;
        this.setSourcePath(resource.getSourcePath());
        this.setResourceType(resource.getResourceType());
        this.setConfiguration(resource.getConfiguration());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.resource = (InternalResource)in.readObject();
        this.encoding = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.resource);
        out.writeObject(this.encoding);
    }

    @Override
    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    @Override
    public boolean hasURL() {
        return this.resource.hasURL();
    }

    public final Resource getResource() {
        return this.resource;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.resource.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.resource.getInputStream());
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    @Override
    public long getLastModified() {
        return this.resource.getLastModified();
    }

    @Override
    public long getLastRead() {
        return this.resource.getLastRead();
    }

    @Override
    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    @Override
    public Collection<Resource> listResources() {
        return this.resource.listResources();
    }

    public String toString() {
        return "[EncodedResource resource=" + this.resource + " encoding='" + this.encoding + "']";
    }
}

