/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit;

import javax.inject.Singleton;
import org.drools.audit.ThreadedWorkingMemoryFileLogger;
import org.drools.audit.WorkingMemoryConsoleLogger;
import org.drools.audit.WorkingMemoryFileLogger;
import org.kie.event.KieRuntimeEventManager;
import org.kie.event.KnowledgeRuntimeEventManager;
import org.kie.logger.KieLoggers;
import org.kie.logger.KnowledgeRuntimeLogger;

@Singleton
public class KnowledgeRuntimeLoggerProviderImpl
implements KieLoggers {
    public KnowledgeRuntimeLogger newFileLogger(KieRuntimeEventManager session, String fileName) {
        WorkingMemoryFileLogger logger = new WorkingMemoryFileLogger((KnowledgeRuntimeEventManager)session);
        if (fileName != null) {
            logger.setFileName(fileName);
        }
        return new KnowledgeRuntimeFileLoggerWrapper(logger);
    }

    public KnowledgeRuntimeLogger newThreadedFileLogger(KieRuntimeEventManager session, String fileName, int interval) {
        ThreadedWorkingMemoryFileLogger logger = new ThreadedWorkingMemoryFileLogger((KnowledgeRuntimeEventManager)session);
        if (fileName != null) {
            logger.setFileName(fileName);
        }
        logger.start(interval);
        return new KnowledgeRuntimeThreadedFileLoggerWrapper(logger);
    }

    public KnowledgeRuntimeLogger newConsoleLogger(KieRuntimeEventManager session) {
        WorkingMemoryConsoleLogger logger = new WorkingMemoryConsoleLogger((KnowledgeRuntimeEventManager)session);
        return new KnowledgeRuntimeConsoleLoggerWrapper(logger);
    }

    private class KnowledgeRuntimeConsoleLoggerWrapper
    implements KnowledgeRuntimeLogger {
        public KnowledgeRuntimeConsoleLoggerWrapper(WorkingMemoryConsoleLogger logger) {
        }

        public void close() {
        }
    }

    private class KnowledgeRuntimeThreadedFileLoggerWrapper
    implements KnowledgeRuntimeLogger {
        private ThreadedWorkingMemoryFileLogger logger;

        public KnowledgeRuntimeThreadedFileLoggerWrapper(ThreadedWorkingMemoryFileLogger logger) {
            this.logger = logger;
        }

        public void close() {
            this.logger.stop();
        }
    }

    private class KnowledgeRuntimeFileLoggerWrapper
    implements KnowledgeRuntimeLogger {
        private WorkingMemoryFileLogger logger;

        public KnowledgeRuntimeFileLoggerWrapper(WorkingMemoryFileLogger logger) {
            this.logger = logger;
        }

        public void close() {
            this.logger.stop();
        }
    }
}

