/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.drools.base.ClassObjectType;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.GlobalExtractor;
import org.drools.spi.InternalReadAccessor;

public class DeclarationScopeResolver {
    private static final Stack<RuleConditionElement> EMPTY_STACK = new Stack();
    private Map<String, Class<?>> map;
    private Stack<RuleConditionElement> buildStack;
    private Package pkg;

    public DeclarationScopeResolver(Map<String, Class<?>> maps) {
        this(maps, EMPTY_STACK);
    }

    public DeclarationScopeResolver(Map<String, Class<?>> map, Stack<RuleConditionElement> buildStack) {
        this.map = map;
        this.buildStack = buildStack == null ? EMPTY_STACK : buildStack;
    }

    public void setPackage(Package pkg) {
        this.pkg = pkg;
    }

    private Declaration getExtendedDeclaration(Rule rule, String identifier) {
        if (rule.getLhs().getInnerDeclarations().containsKey(identifier)) {
            return rule.getLhs().getInnerDeclarations().get(identifier);
        }
        if (null != rule.getParent()) {
            return this.getExtendedDeclaration(rule.getParent(), identifier);
        }
        return null;
    }

    private HashMap<String, Declaration> getAllExtendedDeclaration(Rule rule, HashMap<String, Declaration> dec) {
        dec.putAll(rule.getLhs().getInnerDeclarations());
        if (null != rule.getParent()) {
            return this.getAllExtendedDeclaration(rule.getParent(), dec);
        }
        return dec;
    }

    public Declaration getDeclaration(Rule rule, String identifier) {
        Declaration parentDeclaration;
        for (int i = this.buildStack.size() - 1; i >= 0; --i) {
            Declaration declaration = ((RuleConditionElement)this.buildStack.get(i)).getInnerDeclarations().get(identifier);
            if (declaration == null) continue;
            return declaration;
        }
        if (rule != null && rule.getParent() != null && null != (parentDeclaration = this.getExtendedDeclaration(rule.getParent(), identifier))) {
            return parentDeclaration;
        }
        if (this.map.containsKey(identifier)) {
            if (this.pkg != null) {
                Class<?> cls = this.map.get(identifier);
                ClassObjectType classObjectType = new ClassObjectType(cls);
                Pattern dummy = new Pattern(0, classObjectType);
                GlobalExtractor globalExtractor = new GlobalExtractor(identifier, classObjectType);
                Declaration declaration = new Declaration(identifier, globalExtractor, dummy);
                this.pkg.getClassFieldAccessorStore().getClassObjectType(classObjectType, dummy);
                this.pkg.getClassFieldAccessorStore().getClassObjectType(classObjectType, globalExtractor);
                return declaration;
            }
            throw new UnsupportedOperationException("This shoudln't happen outside of PackageBuilder");
        }
        return null;
    }

    public boolean available(Rule rule, String name) {
        Declaration parentDeclaration;
        for (int i = this.buildStack.size() - 1; i >= 0; --i) {
            Declaration declaration = ((RuleConditionElement)this.buildStack.get(i)).getInnerDeclarations().get(name);
            if (declaration == null) continue;
            return true;
        }
        if (this.map.containsKey(name)) {
            return true;
        }
        return rule != null && rule.getParent() != null && null != (parentDeclaration = this.getExtendedDeclaration(rule.getParent(), name));
    }

    public boolean isDuplicated(Rule rule, String name) {
        Declaration parentDeclaration;
        if (this.map.containsKey(name)) {
            return true;
        }
        for (int i = this.buildStack.size() - 1; i >= 0; --i) {
            RuleConditionElement rce = (RuleConditionElement)this.buildStack.get(i);
            Declaration declaration = rce.getInnerDeclarations().get(name);
            if (declaration == null) continue;
            return !(rce instanceof GroupElement) || !((GroupElement)rce).isOr();
        }
        return rule != null && rule.getParent() != null && null != (parentDeclaration = this.getExtendedDeclaration(rule.getParent(), name));
    }

    public Map<String, Declaration> getDeclarations(Rule rule) {
        return this.getDeclarations(rule, "default");
    }

    public Map<String, Declaration> getDeclarations(Rule rule, String consequenceName) {
        HashMap<String, Declaration> declarations = new HashMap<String, Declaration>();
        for (RuleConditionElement aBuildStack : this.buildStack) {
            Map<String, Declaration> innerDeclarations = aBuildStack instanceof GroupElement ? ((GroupElement)aBuildStack).getInnerDeclarations(consequenceName) : aBuildStack.getInnerDeclarations();
            declarations.putAll(innerDeclarations);
        }
        if (null != rule.getParent()) {
            return this.getAllExtendedDeclaration(rule.getParent(), declarations);
        }
        return declarations;
    }

    public Map<String, Class<?>> getDeclarationClasses(Rule rule) {
        Map<String, Declaration> declarations = this.getDeclarations(rule);
        return DeclarationScopeResolver.getDeclarationClasses(declarations);
    }

    public static Map<String, Class<?>> getDeclarationClasses(Map<String, Declaration> declarations) {
        HashMap classes = new HashMap();
        for (Map.Entry<String, Declaration> decl : declarations.entrySet()) {
            InternalReadAccessor ira = decl.getValue().getExtractor();
            if (ira == null) continue;
            classes.put(decl.getKey(), ira.getExtractToClass());
        }
        return classes;
    }

    public Pattern findPatternByIndex(int index) {
        if (!this.buildStack.isEmpty()) {
            return this.findPatternInNestedElements(index, (RuleConditionElement)this.buildStack.get(0));
        }
        return null;
    }

    private Pattern findPatternInNestedElements(int index, RuleConditionElement rce) {
        for (RuleConditionElement element : rce.getNestedElements()) {
            Pattern p;
            if (!(element instanceof Pattern ? (p = (Pattern)element).getIndex() == index : !element.isPatternScopeDelimiter() && (p = this.findPatternInNestedElements(index, element)) != null)) continue;
            return p;
        }
        return null;
    }
}

