/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AbstractObjectSinkAdapter;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.NodeTypeEnums;
import org.drools.reteoo.ObjectSink;
import org.drools.spi.PropagationContext;

public class SingleObjectSinkAdapter
extends AbstractObjectSinkAdapter {
    private static final long serialVersionUID = 510L;
    protected ObjectSink sink;

    public SingleObjectSinkAdapter() {
        super(null);
    }

    public SingleObjectSinkAdapter(RuleBasePartitionId partitionId, ObjectSink sink) {
        super(partitionId);
        this.sink = sink;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (ObjectSink)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
    }

    @Override
    public void propagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.assertObject(factHandle, context, workingMemory);
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void doLinkRiaNode(InternalWorkingMemory wm) {
        SingleObjectSinkAdapter.staticDoLinkRiaNode(this.sink, wm);
    }

    public static void staticDoLinkRiaNode(ObjectSink sink, InternalWorkingMemory wm) {
        BetaMemory bm;
        if (sink.getType() == 211) {
            AccumulateNode accnode = (AccumulateNode)sink;
            AccumulateNode.AccumulateMemory accMem = (AccumulateNode.AccumulateMemory)wm.getNodeMemory(accnode);
            bm = accMem.getBetaMemory();
        } else if (NodeTypeEnums.isBetaNode(sink)) {
            BetaNode betaNode = (BetaNode)sink;
            bm = (BetaMemory)BetaNode.getBetaMemoryFromRightInput(betaNode, wm);
        } else {
            throw new RuntimeException("Should not be possible to have link into a node of type" + sink);
        }
        bm.linkNode(wm);
    }

    @Override
    public void doUnlinkRiaNode(InternalWorkingMemory wm) {
        SingleObjectSinkAdapter.staticDoUnlinkRiaNode(this.sink, wm);
    }

    public static void staticDoUnlinkRiaNode(ObjectSink sink, InternalWorkingMemory wm) {
        BetaMemory bm;
        if (sink.getType() == 211) {
            AccumulateNode accnode = (AccumulateNode)sink;
            AccumulateNode.AccumulateMemory accMem = (AccumulateNode.AccumulateMemory)wm.getNodeMemory(accnode);
            bm = accMem.getBetaMemory();
        } else if (NodeTypeEnums.isBetaNode(sink)) {
            BetaNode betaNode = (BetaNode)sink;
            bm = (BetaMemory)BetaNode.getBetaMemoryFromRightInput(betaNode, wm);
        } else {
            throw new RuntimeException("Should not be possible to have link into a node of type" + sink);
        }
        bm.unlinkNode(wm);
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        if (candidate.equals(this.sink)) {
            return (BaseNode)((Object)this.sink);
        }
        return null;
    }

    @Override
    public ObjectSink[] getSinks() {
        return new ObjectSink[]{this.sink};
    }

    @Override
    public int size() {
        return 1;
    }
}

