/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.MemoryFactory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleBasePartitionId;
import org.drools.common.StagedLeftTuples;
import org.drools.common.UpdateContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.index.LeftTupleList;
import org.drools.phreak.SegmentUtilities;
import org.drools.reteoo.LIANodePropagation;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.SegmentMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleComponent;
import org.kie.definition.rule.Rule;

public class LeftInputAdapterNode
extends LeftTupleSource
implements ObjectSinkNode,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    private ObjectSource objectSource;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;
    private boolean leftTupleMemoryEnabled;
    protected boolean rootQueryNode;
    protected boolean unlinkingEnabled;
    private int unlinkedDisabledCount;
    private int segmentMemoryIndex;

    public LeftInputAdapterNode() {
    }

    public LeftInputAdapterNode(int id, ObjectSource source, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.objectSource = source;
        this.leftTupleMemoryEnabled = context.isTupleMemoryEnabled();
        ObjectSource current = source;
        while (current.getType() != 30) {
            current = current.getParentObjectSource();
        }
        ObjectTypeNode otn = (ObjectTypeNode)current;
        this.rootQueryNode = ClassObjectType.DroolsQuery_ObjectType.isAssignableFrom(otn.getObjectType());
        this.unlinkingEnabled = context.getRuleBase().getConfiguration().isUnlinkingEnabled();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.objectSource = (ObjectSource)in.readObject();
        this.leftTupleMemoryEnabled = in.readBoolean();
        this.rootQueryNode = in.readBoolean();
        this.unlinkingEnabled = in.readBoolean();
        this.unlinkedDisabledCount = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.objectSource);
        out.writeBoolean(this.leftTupleMemoryEnabled);
        out.writeBoolean(this.rootQueryNode);
        out.writeBoolean(this.unlinkingEnabled);
        out.writeInt(this.unlinkedDisabledCount);
    }

    public int getSegmentMemoryIndex() {
        return this.segmentMemoryIndex;
    }

    public void setSegmentMemoryIndex(int segmentMemoryIndex) {
        this.segmentMemoryIndex = segmentMemoryIndex;
    }

    @Override
    public short getType() {
        return 120;
    }

    public boolean isRootQueryNode() {
        return this.rootQueryNode;
    }

    @Override
    public boolean isUnlinkingEnabled() {
        return this.unlinkingEnabled;
    }

    public void setUnlinkingEnabled(boolean unlinkingEnabled) {
        this.unlinkingEnabled = unlinkingEnabled;
    }

    public int getUnlinkedDisabledCount() {
        return this.unlinkedDisabledCount;
    }

    public void setUnlinkedDisabledCount(int unlinkedDisabledCount) {
        this.unlinkedDisabledCount = unlinkedDisabledCount;
    }

    public ObjectSource getParentObjectSource() {
        return this.objectSource;
    }

    @Override
    public void attach(BuildContext context) {
        this.objectSource.addObjectSink(this);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.objectSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.objectSource.networkUpdated(updateContext);
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        if (this.unlinkingEnabled) {
            LiaNodeMemory lm = (LiaNodeMemory)workingMemory.getNodeMemory(this);
            if (lm.getSegmentMemory() == null) {
                SegmentUtilities.createSegmentMemory(this, workingMemory);
            }
            LeftTupleSinkNode sink = this.getSinkPropagator().getFirstLeftTupleSink();
            LeftTuple leftTuple = sink.createLeftTuple(factHandle, (LeftTupleSink)sink, this.leftTupleMemoryEnabled);
            leftTuple.setPropagationContext(context);
            if (lm.getSegmentMemory().getStagedLeftTuples().insertSize() == 0) {
                lm.linkNode(workingMemory);
            }
            lm.setCounter(lm.getCounter() + 1);
            lm.getSegmentMemory().getStagedLeftTuples().addInsert(leftTuple);
            return;
        }
        boolean useLeftMemory = true;
        if (!this.leftTupleMemoryEnabled && (object = ((InternalFactHandle)context.getFactHandle()).getObject()) instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
            useLeftMemory = false;
        }
        if (!workingMemory.isSequential()) {
            this.sink.createAndPropagateAssertLeftTuple(factHandle, context, workingMemory, useLeftMemory, this);
        } else {
            workingMemory.addLIANodePropagation(new LIANodePropagation(this, factHandle, context));
        }
    }

    public static LeftTuple propagateLeftTuples(LeftInputAdapterNode liaNode, LeftTupleList list, int length, InternalWorkingMemory wm) {
        LeftTuple leftTuple = list.getFirst();
        for (int i = 0; i < length; ++i) {
            LeftTuple next = (LeftTuple)leftTuple.getNext();
            leftTuple.setPrevious(null);
            leftTuple.setNext(null);
            leftTuple.setMemory(null);
            leftTuple.getLeftTupleSink().assertLeftTuple(leftTuple, leftTuple.getPropagationContext(), wm);
            leftTuple.getPropagationContext().evaluateActionQueue(wm);
            leftTuple = next;
        }
        return leftTuple;
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.isUnlinkingEnabled()) {
            LiaNodeMemory lm = (LiaNodeMemory)workingMemory.getNodeMemory(this);
            SegmentMemory smem = lm.getSegmentMemory();
            StagedLeftTuples leftTuples = smem.getStagedLeftTuples();
            switch (leftTuple.getStagedType()) {
                case 1: {
                    leftTuples.removeInsert(leftTuple);
                    break;
                }
                case 2: {
                    leftTuples.removeUpdate(leftTuple);
                }
            }
            lm.setCounter(lm.getCounter() - 1);
            if (lm.getCounter() == 0) {
                lm.unlinkNode(workingMemory);
            }
            return;
        }
        leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, context, workingMemory);
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTupleSinkAdapter adapter = new RightTupleSinkAdapter(sink, true);
        this.objectSource.updateSink(adapter, context, workingMemory);
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        this.handleUnlinking(context);
        this.objectSource.remove(context, builder, this, workingMemories);
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        return null;
    }

    public void handleUnlinking(RuleRemovalContext context) {
        if (!context.isUnlinkEnabled() && this.unlinkedDisabledCount == 0) {
            return;
        }
        if (context.isUnlinkEnabled()) {
            --this.unlinkedDisabledCount;
            if (this.unlinkedDisabledCount == 0) {
                this.unlinkingEnabled = true;
            }
        }
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    @Override
    public int hashCode() {
        return this.objectSource.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LeftInputAdapterNode)) {
            return false;
        }
        LeftInputAdapterNode other = (LeftInputAdapterNode)object;
        return this.objectSource.equals(other.objectSource);
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this.objectSource;
        while (source != null) {
            if (source instanceof ObjectTypeNode) {
                return (ObjectTypeNode)source;
            }
            source = source.source;
        }
        return null;
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config) {
        return new LiaNodeMemory();
    }

    public static class LiaNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Memory {
        private int counter;
        private SegmentMemory segmentMemory;
        private long nodePosMaskBit;

        public int getCounter() {
            return this.counter;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.segmentMemory;
        }

        public void setSegmentMemory(SegmentMemory segmentNodes) {
            this.segmentMemory = segmentNodes;
        }

        public long getNodePosMaskBit() {
            return this.nodePosMaskBit;
        }

        public void setNodePosMaskBit(long nodePosMask) {
            this.nodePosMaskBit = nodePosMask;
        }

        public void linkNode(InternalWorkingMemory wm) {
            this.segmentMemory.linkNode(this.nodePosMaskBit, wm);
        }

        public void unlinkNode(InternalWorkingMemory wm) {
            this.segmentMemory.unlinkNode(this.nodePosMaskBit, wm);
        }

        @Override
        public short getNodeType() {
            return 120;
        }
    }

    private static class RightTupleSinkAdapter
    implements ObjectSink {
        private LeftTupleSink sink;
        private boolean leftTupleMemoryEnabled;

        public RightTupleSinkAdapter(LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
            this.sink = sink;
            this.leftTupleMemoryEnabled = leftTupleMemoryEnabled;
        }

        @Override
        public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
            LeftTuple tuple = this.sink.createLeftTuple(factHandle, this.sink, this.leftTupleMemoryEnabled);
            this.sink.assertLeftTuple(tuple, context, workingMemory);
        }

        @Override
        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("ObjectSinkAdapter onlys supports assertObject method calls");
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public short getType() {
            return 120;
        }

        @Override
        public Map<Rule, RuleComponent> getAssociations() {
            return this.sink.getAssociations();
        }
    }
}

