/*
 * Decompiled with CFR 0.152.
 */
package org.drools.phreak;

import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.MemoryFactory;
import org.drools.common.StagedLeftTuples;
import org.drools.reteoo.CompositeLeftTupleSinkAdapter;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSinkNodeList;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.SegmentMemory;

public class SegmentPropagator {
    public static void propagate(SegmentMemory sourceSegment, StagedLeftTuples stagedLeftTuples, InternalWorkingMemory wm) {
        LeftTupleSource source = sourceSegment.getTipNode();
        if (sourceSegment.isEmpty()) {
            LeftTupleSinkNodeList list = ((CompositeLeftTupleSinkAdapter)source.getSinkPropagator()).getRawSinks();
            for (LeftTupleSinkNode sink = list.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
                Memory memory = wm.getNodeMemories().getNodeMemory((MemoryFactory)((Object)sink));
                SegmentMemory smem = memory.getSegmentMemory();
                sourceSegment.add(smem);
            }
        }
        SegmentPropagator.processPeers(sourceSegment, stagedLeftTuples);
    }

    public static void processPeers(SegmentMemory sourceSegment, StagedLeftTuples leftTuples) {
        StagedLeftTuples stagedLeftTuples;
        LeftTuple peer;
        SegmentMemory smem;
        LeftTuple leftTuple;
        SegmentMemory firstSmem = (SegmentMemory)sourceSegment.getFirst();
        if (leftTuples.getDeleteFirst() != null) {
            for (leftTuple = leftTuples.getDeleteFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
                smem = firstSmem.getNext();
                if (smem == null) continue;
                for (peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                    stagedLeftTuples = smem.getStagedLeftTuples();
                    switch (peer.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(peer);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(peer);
                        }
                    }
                    stagedLeftTuples.addDelete(peer);
                    smem = smem.getNext();
                }
            }
            firstSmem.getStagedLeftTuples().addAllDeletes(leftTuples.getDeleteFirst());
        }
        if (leftTuples.getUpdateFirst() != null) {
            firstSmem = (SegmentMemory)sourceSegment.getFirst();
            for (leftTuple = leftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
                smem = firstSmem.getNext();
                if (smem == null) continue;
                for (peer = leftTuple.getPeer(); peer != null; peer = peer.getPeer()) {
                    stagedLeftTuples = smem.getStagedLeftTuples();
                    switch (peer.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(peer);
                        }
                    }
                    stagedLeftTuples.addUpdate(peer);
                    smem = smem.getNext();
                }
            }
            firstSmem.getStagedLeftTuples().addAllUpdates(leftTuples.getUpdateFirst());
        }
        if (leftTuples.getInsertFirst() != null) {
            firstSmem = (SegmentMemory)sourceSegment.getFirst();
            for (leftTuple = leftTuples.getInsertFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
                smem = firstSmem.getNext();
                if (smem == null) continue;
                peer = leftTuple;
                while (smem != null) {
                    peer = smem.getRootNode().createPeer(peer);
                    smem.getStagedLeftTuples().addInsert(peer);
                    smem = smem.getNext();
                }
            }
            firstSmem.getStagedLeftTuples().addAllInserts(leftTuples.getInsertFirst());
        }
    }

    public static void processPeers(StagedLeftTuples leftTuples, StagedLeftTuples peerLeftTuples, LeftTupleSink sink) {
        LeftTuple leftTuple;
        for (leftTuple = leftTuples.getDeleteFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            peerLeftTuples.addDelete(leftTuple.getPeer());
        }
        for (leftTuple = leftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            peerLeftTuples.addUpdate(leftTuple.getPeer());
        }
        for (leftTuple = leftTuples.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            peerLeftTuples.addInsert(sink.createPeer(leftTuple.getPeer()));
        }
    }
}

