/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import org.drools.RuleBaseConfiguration;
import org.drools.common.EqualityAssertMapComparator;
import org.drools.common.IdentityAssertMapComparator;
import org.drools.common.InternalFactHandle;
import org.drools.common.ObjectStore;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.JavaIteratorAdapter;
import org.drools.core.util.ObjectHashMap;
import org.kie.runtime.ObjectFilter;
import org.kie.runtime.rule.FactHandle;

public class SingleThreadedObjectStore
implements Externalizable,
ObjectStore {
    private ObjectHashMap assertMap;
    private ObjectHashMap identityMap;
    private RuleBaseConfiguration.AssertBehaviour behaviour;
    private Lock lock;

    public SingleThreadedObjectStore() {
    }

    public SingleThreadedObjectStore(RuleBaseConfiguration conf, Lock lock) {
        this.behaviour = conf.getAssertBehaviour();
        this.lock = lock;
        this.assertMap = new ObjectHashMap();
        if (RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals(this.behaviour)) {
            this.assertMap.setComparator(new IdentityAssertMapComparator());
            this.identityMap = this.assertMap;
        } else {
            this.assertMap.setComparator(new EqualityAssertMapComparator());
            this.identityMap = new ObjectHashMap();
            this.identityMap.setComparator(new IdentityAssertMapComparator());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.assertMap = (ObjectHashMap)in.readObject();
        this.identityMap = (ObjectHashMap)in.readObject();
        this.behaviour = (RuleBaseConfiguration.AssertBehaviour)in.readObject();
        this.lock = (Lock)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.assertMap);
        out.writeObject(this.identityMap);
        out.writeObject(this.behaviour);
        out.writeObject(this.lock);
    }

    @Override
    public int size() {
        return this.assertMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.assertMap.size() == 0;
    }

    @Override
    public void clear() {
        this.assertMap.clear();
        this.identityMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectForHandle(FactHandle handle) {
        try {
            Object object;
            this.lock.lock();
            InternalFactHandle internalHandle = (InternalFactHandle)this.assertMap.get(handle);
            if (internalHandle == null) {
                Object var3_3 = null;
                return var3_3;
            }
            Object object2 = object = internalHandle.getObject();
            return object2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public InternalFactHandle getHandleForObject(Object object) {
        if (object == null) {
            return null;
        }
        return (InternalFactHandle)this.assertMap.get(object);
    }

    @Override
    public InternalFactHandle reconnect(FactHandle factHandle) {
        return (InternalFactHandle)this.assertMap.get(factHandle);
    }

    @Override
    public InternalFactHandle getHandleForObjectIdentity(Object object) {
        return (InternalFactHandle)this.identityMap.get(object);
    }

    @Override
    public void updateHandle(InternalFactHandle handle, Object object) {
        this.assertMap.remove(handle);
        if (RuleBaseConfiguration.AssertBehaviour.EQUALITY.equals(this.behaviour)) {
            this.identityMap.remove(handle);
        }
        handle.setObject(object);
        this.assertMap.put(handle, handle, false);
        if (RuleBaseConfiguration.AssertBehaviour.EQUALITY.equals(this.behaviour)) {
            this.identityMap.put(handle, handle, false);
        }
    }

    @Override
    public void addHandle(InternalFactHandle handle, Object object) {
        this.assertMap.put(handle, handle, false);
        if (RuleBaseConfiguration.AssertBehaviour.EQUALITY.equals(this.behaviour)) {
            this.identityMap.put(handle, handle, false);
        }
    }

    @Override
    public void removeHandle(FactHandle handle) {
        this.assertMap.remove(handle);
        if (RuleBaseConfiguration.AssertBehaviour.EQUALITY.equals(this.behaviour)) {
            this.identityMap.remove(handle);
        }
    }

    @Override
    public Iterator iterateObjects() {
        AbstractHashTable.HashTableIterator iterator = new AbstractHashTable.HashTableIterator(this.assertMap);
        iterator.reset();
        return new JavaIteratorAdapter(iterator, JavaIteratorAdapter.OBJECT);
    }

    @Override
    public Iterator iterateObjects(ObjectFilter filter) {
        AbstractHashTable.HashTableIterator iterator = new AbstractHashTable.HashTableIterator(this.assertMap);
        iterator.reset();
        return new JavaIteratorAdapter(iterator, JavaIteratorAdapter.OBJECT, filter);
    }

    @Override
    public Iterator iterateFactHandles() {
        AbstractHashTable.HashTableIterator iterator = new AbstractHashTable.HashTableIterator(this.assertMap);
        iterator.reset();
        return new JavaIteratorAdapter(iterator, JavaIteratorAdapter.FACT_HANDLE);
    }

    @Override
    public Iterator iterateFactHandles(ObjectFilter filter) {
        AbstractHashTable.HashTableIterator iterator = new AbstractHashTable.HashTableIterator(this.assertMap);
        iterator.reset();
        return new JavaIteratorAdapter(iterator, JavaIteratorAdapter.FACT_HANDLE, filter);
    }
}

