/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.Iterator;
import org.drools.common.ActivationGroupNode;
import org.drools.core.util.LinkedList;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;

public class ActivationGroupImpl
implements ActivationGroup {
    private final String name;
    private final LinkedList<ActivationGroupNode> list;
    private long triggeredForRecency;

    public ActivationGroupImpl(String name) {
        this.name = name;
        this.list = new LinkedList();
        this.triggeredForRecency = -1L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addActivation(Activation activation) {
        ActivationGroupNode node = new ActivationGroupNode(activation, this);
        activation.setActivationGroupNode(node);
        this.list.add(node);
    }

    @Override
    public void removeActivation(Activation activation) {
        ActivationGroupNode node = activation.getActivationGroupNode();
        this.list.remove(node);
        activation.setActivationGroupNode(null);
    }

    @Override
    public Iterator iterator() {
        return this.list.javaUtilIterator();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public LinkedList<ActivationGroupNode> getList() {
        return this.list;
    }

    @Override
    public long getTriggeredForRecency() {
        return this.triggeredForRecency;
    }

    @Override
    public void setTriggeredForRecency(long executedForRecency) {
        this.triggeredForRecency = executedForRecency;
    }
}

