/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.ValueType;
import org.drools.base.extractors.BaseObjectClassFieldReader;
import org.drools.base.mvel.MVELCompileable;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.MVELDialectRuntimeData;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExecutableStatement;

public class MVELClassFieldReader
extends BaseObjectClassFieldReader
implements Externalizable,
MVELCompileable {
    private static final long serialVersionUID = 510L;
    private ExecutableStatement mvelExpression = null;
    private String className;
    private String expr;
    private boolean typesafe;

    public MVELClassFieldReader() {
    }

    public MVELClassFieldReader(String className, String expr, boolean typesafe) {
        this.className = className;
        this.expr = expr;
        this.typesafe = typesafe;
        this.setValueType(ValueType.CLASS_TYPE);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.expr = (String)in.readObject();
        this.typesafe = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.expr);
        out.writeBoolean(this.typesafe);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        Class cls = null;
        try {
            cls = runtimeData.getRootClassLoader().loadClass(this.className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to compile as Class could not be found '" + this.className + "'");
        }
        ParserContext context = new ParserContext(runtimeData.getParserConfiguration());
        context.addInput("this", cls);
        context.setStrongTyping(this.typesafe);
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
        MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
        this.mvelExpression = (ExecutableStatement)MVEL.compileExpression((String)this.expr, (ParserContext)context);
        Class returnType = this.mvelExpression.getKnownEgressType();
        this.setFieldType(returnType);
        this.setValueType(ValueType.determineValueType(returnType));
    }

    @Override
    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return MVEL.executeExpression((Object)this.mvelExpression, (Object)object);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.typesafe ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MVELClassFieldReader other = (MVELClassFieldReader)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        return this.typesafe == other.typesafe;
    }

    public String toString() {
        return "[MVELClassFieldReader className=" + this.className + ", expr=" + this.expr + ", typesafe=" + this.typesafe + "]";
    }
}

