/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.factmodel.traits.CoreWrapper;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.kie.runtime.ObjectFilter;

public class IsAEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator ISA = Operator.addOperatorToRegistry("isA", false);
    public static final Operator NOT_ISA = Operator.addOperatorToRegistry("isA", true);
    protected static final String[] SUPPORTED_IDS = new String[]{ISA.getOperatorString()};
    private Evaluator[] evaluator;

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
        IsAEvaluator evaluator = new IsAEvaluator(type, isNegated);
        evaluator.setParameterText(parameterText);
        return evaluator;
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return type.equals(ValueType.TRAIT_TYPE);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluator = (Evaluator[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluator);
    }

    public static class IsAEvaluator
    extends BaseEvaluator {
        public void setParameterText(String parameterText) {
        }

        public IsAEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? NOT_ISA : ISA);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object, FieldValue value) {
            Object objectValue = extractor.getValue(workingMemory, object);
            Object typeName = value.getValue();
            if (typeName instanceof Class) {
                typeName = ((Class)typeName).getName();
            }
            TraitableBean core = null;
            if (objectValue instanceof Thing) {
                Thing thing = (Thing)objectValue;
                core = (TraitableBean)thing.getCore();
                return this.getOperator().isNegated() ^ core.hasTrait(typeName.toString());
            }
            if (objectValue instanceof TraitableBean) {
                core = (TraitableBean)objectValue;
                return this.getOperator().isNegated() ^ core.hasTrait(typeName.toString());
            }
            core = this.lookForWrapper(objectValue, workingMemory);
            return core == null && this.getOperator().isNegated() || core != null && this.getOperator().isNegated() ^ core.hasTrait(typeName.toString());
        }

        protected TraitableBean lookForWrapper(final Object objectValue, InternalWorkingMemory workingMemory) {
            Iterator iter = workingMemory.getObjectStore().iterateObjects(new ObjectFilter(){

                public boolean accept(Object object) {
                    if (object instanceof TraitProxy) {
                        Object core = ((TraitProxy)object).getObject();
                        if (core instanceof CoreWrapper) {
                            core = ((CoreWrapper)core).getCore();
                        }
                        return core == objectValue;
                    }
                    return false;
                }
            });
            if (iter.hasNext()) {
                return (TraitableBean)((TraitProxy)iter.next()).getObject();
            }
            return null;
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor leftExtractor, Object left, InternalReadAccessor rightExtractor, Object right) {
            Object value1 = leftExtractor.getValue(workingMemory, left);
            Object value2 = rightExtractor.getValue(workingMemory, right);
            Object target = value1;
            Object source = value2;
            return this.compare(source, target, workingMemory);
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object target = right;
            Object source = context.getObject();
            return this.compare(source, target, workingMemory);
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object target = left;
            Object source = context.getObject();
            return this.compare(source, target, workingMemory);
        }

        private boolean compare(Object source, Object target, InternalWorkingMemory workingMemory) {
            TraitableBean tbean;
            Collection<String> sourceTraits = null;
            Collection<String> targetTraits = null;
            if (source instanceof Thing) {
                sourceTraits = ((TraitableBean)((Thing)source).getCore()).getTraits();
            } else if (source instanceof TraitableBean) {
                sourceTraits = ((TraitableBean)source).getTraits();
            } else {
                tbean = this.lookForWrapper(source, workingMemory);
                if (tbean != null) {
                    sourceTraits = tbean.getTraits();
                }
            }
            if (target instanceof Thing) {
                targetTraits = ((TraitableBean)((Thing)target).getCore()).getTraits();
            } else if (target instanceof TraitableBean) {
                targetTraits = ((TraitableBean)target).getTraits();
            } else {
                tbean = this.lookForWrapper(target, workingMemory);
                if (tbean != null) {
                    targetTraits = tbean.getTraits();
                }
            }
            return targetTraits != null && sourceTraits != null && this.getOperator().isNegated() ^ sourceTraits.containsAll(targetTraits) || sourceTraits == null && this.getOperator().isNegated();
        }

        @Override
        public String toString() {
            return "IsAEvaluatorDefinition isA";
        }
    }
}

