/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class CoincidesEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator COINCIDES = Operator.addOperatorToRegistry("coincides", false);
    public static final Operator COINCIDES_NOT = Operator.addOperatorToRegistry("coincides", true);
    private static final String[] SUPPORTED_IDS = new String[]{COINCIDES.getOperatorString()};
    private Map<String, CoincidesEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        CoincidesEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, CoincidesEvaluator>();
        }
        if ((eval = this.cache.get(key = (Object)((Object)left) + ":" + (Object)((Object)right) + ":" + isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new CoincidesEvaluator(type, isNegated, params, parameterText, left == EvaluatorDefinition.Target.FACT, right == EvaluatorDefinition.Target.FACT);
            this.cache.put(key, eval);
        }
        return eval;
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.BOTH;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class CoincidesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long startDev;
        private long endDev;
        private String paramText;
        private boolean unwrapLeft;
        private boolean unwrapRight;

        public CoincidesEvaluator() {
        }

        public CoincidesEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText, boolean unwrapLeft, boolean unwrapRight) {
            super(type, isNegated ? COINCIDES_NOT : COINCIDES);
            this.paramText = paramText;
            this.unwrapLeft = unwrapLeft;
            this.unwrapRight = unwrapRight;
            this.setParameters(parameters);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.startDev = in.readLong();
            this.endDev = in.readLong();
            this.unwrapLeft = in.readBoolean();
            this.unwrapRight = in.readBoolean();
            this.paramText = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.startDev);
            out.writeLong(this.endDev);
            out.writeBoolean(this.unwrapLeft);
            out.writeBoolean(this.unwrapRight);
            out.writeObject(this.paramText);
        }

        @Override
        public Object prepareLeftObject(InternalFactHandle handle) {
            return this.unwrapLeft ? handle.getObject() : handle;
        }

        @Override
        public Object prepareRightObject(InternalFactHandle handle) {
            return this.unwrapRight ? handle.getObject() : handle;
        }

        @Override
        public boolean isTemporal() {
            return true;
        }

        @Override
        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, 0L);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'coincides' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            long rightEndTS;
            long rightStartTS;
            if (context.rightNull) {
                return false;
            }
            if (this.unwrapRight) {
                rightStartTS = context instanceof VariableRestriction.ObjectVariableContextEntry ? (((VariableRestriction.ObjectVariableContextEntry)context).right instanceof Date ? ((Date)((VariableRestriction.ObjectVariableContextEntry)context).right).getTime() : ((Number)((VariableRestriction.ObjectVariableContextEntry)context).right).longValue()) : ((VariableRestriction.LongVariableContextEntry)context).right;
                rightEndTS = rightStartTS;
            } else {
                rightStartTS = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getStartTimestamp();
                rightEndTS = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getEndTimestamp();
            }
            long leftStartTS = this.unwrapLeft ? context.declaration.getExtractor().getLongValue(workingMemory, left) : ((EventFactHandle)left).getStartTimestamp();
            long leftEndTS = this.unwrapLeft ? rightStartTS : ((EventFactHandle)left).getEndTimestamp();
            long distStart = Math.abs(rightStartTS - leftStartTS);
            long distEnd = Math.abs(rightEndTS - leftEndTS);
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            long leftEndTS;
            long leftStartTS;
            long rightEndTS;
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            long rightStartTS = this.unwrapRight ? context.extractor.getLongValue(workingMemory, right) : ((EventFactHandle)right).getStartTimestamp();
            long l = rightEndTS = this.unwrapRight ? rightStartTS : ((EventFactHandle)right).getEndTimestamp();
            if (this.unwrapLeft) {
                leftStartTS = context instanceof VariableRestriction.ObjectVariableContextEntry ? (((VariableRestriction.ObjectVariableContextEntry)context).left instanceof Date ? ((Date)((VariableRestriction.ObjectVariableContextEntry)context).left).getTime() : ((Number)((VariableRestriction.ObjectVariableContextEntry)context).left).longValue()) : ((VariableRestriction.LongVariableContextEntry)context).left;
                leftEndTS = leftStartTS;
            } else {
                leftStartTS = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getStartTimestamp();
                leftEndTS = ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getEndTimestamp();
            }
            long distStart = Math.abs(rightStartTS - leftStartTS);
            long distEnd = Math.abs(rightEndTS - leftEndTS);
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            long rightStartTS = this.unwrapRight ? extractor1.getLongValue(workingMemory, object1) : ((EventFactHandle)object1).getStartTimestamp();
            long rightEndTS = this.unwrapRight ? rightStartTS : ((EventFactHandle)object1).getEndTimestamp();
            long leftStartTS = this.unwrapLeft ? extractor2.getLongValue(workingMemory, object2) : ((EventFactHandle)object2).getStartTimestamp();
            long leftEndTS = this.unwrapLeft ? leftStartTS : ((EventFactHandle)object2).getEndTimestamp();
            long distStart = Math.abs(rightStartTS - leftStartTS);
            long distEnd = Math.abs(rightEndTS - leftEndTS);
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        @Override
        public String toString() {
            return "coincides[" + this.startDev + ", " + this.endDev + "]";
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endDev ^ this.endDev >>> 32);
            result = 31 * result + (int)(this.startDev ^ this.startDev >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoincidesEvaluator other = (CoincidesEvaluator)obj;
            return this.endDev == other.endDev && this.startDev == other.startDev;
        }

        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.startDev = 0L;
                this.endDev = 0L;
                return;
            }
            for (Long param : parameters) {
                if (param >= 0L) continue;
                throw new RuntimeDroolsException("[Coincides Evaluator]: negative values not allowed for temporal distance thresholds: '" + this.paramText + "'");
            }
            if (parameters.length == 1) {
                this.startDev = parameters[0];
                this.endDev = parameters[0];
            } else if (parameters.length == 2) {
                this.startDev = parameters[0];
                this.endDev = parameters[1];
            } else {
                throw new RuntimeDroolsException("[Coincides Evaluator]: Not possible to have more than 2 parameters: '" + this.paramText + "'");
            }
        }
    }
}

