/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.drools.base.ClassObjectType;
import org.drools.common.AgendaItem;
import org.drools.common.BaseNode;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.common.UpdateContext;
import org.drools.event.rule.ActivationCancelledCause;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.FromNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.PropertySpecificUtil;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;
import org.drools.spi.Activation;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;

public class RuleTerminalNode
extends BaseNode
implements TerminalNode,
Externalizable {
    private int sequence = -1;
    private static final long serialVersionUID = 510L;
    private Rule rule;
    private GroupElement subrule;
    private int subruleIndex;
    private LeftTupleSource tupleSource;
    private Declaration[] declarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private boolean fireDirect;
    private long declaredMask;
    private long inferredMask;
    private long negativeMask;
    private int leftInputOtnId;

    public RuleTerminalNode() {
    }

    public RuleTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.rule = rule;
        this.tupleSource = source;
        this.subrule = subrule;
        this.subruleIndex = subruleIndex;
        Map<String, Declaration> decls = this.subrule.getOuterDeclarations();
        this.declarations = new Declaration[rule.getRequiredDeclarations().length];
        int i = 0;
        for (String str : rule.getRequiredDeclarations()) {
            this.declarations[i++] = decls.get(str);
        }
        Arrays.sort(this.declarations, SortDeclarations.instance);
        this.setFireDirect(rule.getActivationListener().equals("direct"));
        this.initDeclaredMask(context);
        this.initInferredMask();
    }

    public void initDeclaredMask(BuildContext context) {
        RuleTerminalNode.doInitDeclaredMask(this, context);
    }

    public static void doInitDeclaredMask(TerminalNode tn, BuildContext context) {
        if (!(tn.unwrapTupleSource() instanceof LeftInputAdapterNode)) {
            tn.setDeclaredMask(Long.MAX_VALUE);
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        ObjectType objectType = pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            tn.setDeclaredMask(Long.MAX_VALUE);
            return;
        }
        Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
        TypeDeclaration typeDeclaration = context.getRuleBase().getTypeDeclaration(objectClass);
        if (typeDeclaration == null || !typeDeclaration.isPropertySpecific()) {
            tn.setDeclaredMask(Long.MAX_VALUE);
        } else {
            List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getRuleBase(), objectClass);
            tn.setDeclaredMask(PropertySpecificUtil.calculatePositiveMask(pattern.getListenedProperties(), settableProperties));
            tn.setNegativeMask(PropertySpecificUtil.calculateNegativeMask(pattern.getListenedProperties(), settableProperties));
        }
    }

    public void initInferredMask() {
        RuleTerminalNode.doInitInferredMask(this);
    }

    public static void doInitInferredMask(TerminalNode tn) {
        LeftTupleSource leftTupleSource = tn.unwrapTupleSource();
        if (leftTupleSource instanceof LeftInputAdapterNode && ((LeftInputAdapterNode)leftTupleSource).getParentObjectSource() instanceof AlphaNode) {
            AlphaNode alphaNode = (AlphaNode)((LeftInputAdapterNode)leftTupleSource).getParentObjectSource();
            tn.setInferredMask(alphaNode.updateMask(tn.getDeclaredMask()));
        } else {
            tn.setInferredMask(tn.getDeclaredMask());
        }
        tn.setInferredMask(tn.getInferredMask() & Long.MAX_VALUE - tn.getNegativeMask());
    }

    public LeftTupleSource unwrapTupleSource() {
        return this.tupleSource instanceof FromNode ? ((FromNode)this.tupleSource).getLeftTupleSource() : this.tupleSource;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sequence = in.readInt();
        this.rule = (Rule)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.subruleIndex = in.readInt();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.fireDirect = this.rule.getActivationListener().equals("direct");
        this.declaredMask = in.readLong();
        this.inferredMask = in.readLong();
        this.negativeMask = in.readLong();
        this.leftInputOtnId = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.sequence);
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeInt(this.subruleIndex);
        out.writeObject(this.tupleSource);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.declarations);
        out.writeLong(this.declaredMask);
        out.writeLong(this.inferredMask);
        out.writeLong(this.negativeMask);
        out.writeLong(this.leftInputOtnId);
    }

    public Rule getRule() {
        return this.rule;
    }

    public GroupElement getSubRule() {
        return this.subrule;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    public int getSequence() {
        return this.sequence;
    }

    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    public long getDeclaredMask() {
        return this.declaredMask;
    }

    public long getInferredMask() {
        return this.inferredMask;
    }

    public void setDeclaredMask(long mask) {
        this.declaredMask = mask;
    }

    public void setInferredMask(long mask) {
        this.inferredMask = mask;
    }

    public long getNegativeMask() {
        return this.negativeMask;
    }

    public void setNegativeMask(long mask) {
        this.negativeMask = mask;
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (!this.rule.isEffective(leftTuple, workingMemory) || this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            return;
        }
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        boolean fire = agenda.createActivation(leftTuple, context, workingMemory, this, false);
        if (fire && !this.fireDirect) {
            agenda.addActivation((AgendaItem)leftTuple.getObject());
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AgendaItem match = (AgendaItem)leftTuple.getObject();
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        if (match != null && match.isActivated()) {
            agenda.modifyActivation(match, true);
            return;
        }
        if (this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            agenda.increaseDormantActivations();
            return;
        }
        boolean fire = agenda.createActivation(leftTuple, context, workingMemory, this, true);
        if (fire && !this.isFireDirect()) {
            agenda.decreaseDormantActivations();
            agenda.modifyActivation((AgendaItem)leftTuple.getObject(), false);
        }
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSource.doModifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory, this, this.getLeftInputOtnId(), this.inferredMask);
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Activation activation = (Activation)leftTuple.getObject();
        if (activation == null) {
            return;
        }
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        agenda.cancelActivation(leftTuple, context, workingMemory, activation, this);
    }

    public String toString() {
        return "[RuleTerminalNode(" + this.getId() + "): rule=" + this.rule.getName() + "]";
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated(UpdateContext updateContext) {
        this.tupleSource.networkUpdated(updateContext);
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        RuleRemovalContext.CleanupAdapter adapter = context.getCleanupAdapter();
        context.setCleanupAdapter(new RTNCleanupAdapter(this));
        this.tupleSource.remove(context, builder, this, workingMemories);
        for (InternalWorkingMemory workingMemory : workingMemories) {
            workingMemory.executeQueuedActions();
        }
        context.setCleanupAdapter(adapter);
    }

    public boolean isInUse() {
        return false;
    }

    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
    }

    public Declaration[] getDeclarations() {
        return this.declarations;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof RuleTerminalNode)) {
            return false;
        }
        RuleTerminalNode other = (RuleTerminalNode)object;
        return this.rule.equals(other.rule);
    }

    public short getType() {
        return 9;
    }

    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    public int getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    public void setLeftInputOtnId(int leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    public boolean isFireDirect() {
        return this.fireDirect;
    }

    public void setFireDirect(boolean fireDirect) {
        this.fireDirect = fireDirect;
    }

    protected ObjectTypeNode getObjectTypeNode() {
        return this.tupleSource.getObjectTypeNode();
    }

    public static class RTNCleanupAdapter
    implements RuleRemovalContext.CleanupAdapter {
        private RuleTerminalNode node;

        public RTNCleanupAdapter(RuleTerminalNode node) {
            this.node = node;
        }

        public void cleanUp(LeftTuple leftTuple, InternalWorkingMemory workingMemory) {
            if (leftTuple.getLeftTupleSink() != this.node) {
                return;
            }
            Activation activation = (Activation)leftTuple.getObject();
            if (activation instanceof ScheduledAgendaItem) {
                ScheduledAgendaItem scheduled = (ScheduledAgendaItem)activation;
                workingMemory.getTimerService().removeJob(scheduled.getJobHandle());
                scheduled.getJobHandle().setCancel(true);
            }
            if (activation.isActivated()) {
                activation.remove();
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory, ActivationCancelledCause.CLEAR);
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 4, null, null, null);
            workingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, propagationContext, this.node.getRule());
            leftTuple.unlinkFromLeftParent();
            leftTuple.unlinkFromRightParent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortDeclarations
    implements Comparator<Declaration> {
        public static final SortDeclarations instance = new SortDeclarations();

        @Override
        public int compare(Declaration d1, Declaration d2) {
            return d1.getIdentifier().compareTo(d2.getIdentifier());
        }
    }
}

