/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.constraint;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.RuleBase;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.extractors.ArrayElementReader;
import org.drools.common.AbstractRuleBase;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.IndexEvaluator;
import org.drools.rule.IndexableConstraint;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.MutableTypeConstraint;
import org.drools.rule.Pattern;
import org.drools.rule.constraint.ASMConditionEvaluatorJitter;
import org.drools.rule.constraint.ConditionEvaluator;
import org.drools.rule.constraint.MvelConditionEvaluator;
import org.drools.runtime.rule.Variable;
import org.drools.spi.Constraint;
import org.drools.spi.InternalReadAccessor;
import org.drools.util.CompositeClassLoader;
import org.mvel2.ParserConfiguration;

public class MvelConstraint
extends MutableTypeConstraint
implements IndexableConstraint {
    private static final boolean TEST_JITTING = false;
    private static final int JIT_THRESOLD = Integer.MAX_VALUE;
    private AtomicInteger invocationCounter = new AtomicInteger(0);
    private boolean jitted = false;
    private String packageName;
    private String expression;
    private String operator;
    private Declaration[] declarations;
    private Declaration indexingDeclaration;
    private InternalReadAccessor extractor;
    private boolean isUnification;
    private transient boolean isJittable;
    private transient ParserConfiguration conf;
    private transient ConditionEvaluator conditionEvaluator;
    public static final IndexEvaluator INDEX_EVALUATOR = new PlainIndexEvaluator();

    public MvelConstraint() {
    }

    public MvelConstraint(String packageName, String expression, String operator) {
        this(packageName, expression, operator, null, null, null);
    }

    public MvelConstraint(String packageName, String expression, String operator, Declaration[] declarations, Declaration indexingDeclaration, InternalReadAccessor extractor) {
        this.packageName = packageName;
        this.expression = expression;
        this.operator = operator;
        this.declarations = declarations == null ? new Declaration[]{} : declarations;
        this.indexingDeclaration = indexingDeclaration;
        this.extractor = extractor;
        this.isUnification = this.initUnification();
        this.init();
    }

    private void init() {
        this.isJittable = this.initJittable();
    }

    public boolean isUnification() {
        return this.isUnification;
    }

    public void unsetUnification() {
        this.isUnification = false;
    }

    public boolean isIndexable() {
        return this.indexingDeclaration != null && this.operator.equals("==");
    }

    public IndexEvaluator getIndexEvaluator() {
        return INDEX_EVALUATOR;
    }

    private boolean initUnification() {
        if (this.declarations.length == 0) {
            return false;
        }
        Pattern pattern = this.declarations[0].getPattern();
        if (pattern == null) {
            return false;
        }
        return pattern.getObjectType().equals(new ClassObjectType(DroolsQuery.class)) && this.operator.equals("==");
    }

    private boolean initJittable() {
        return this.getType() == Constraint.ConstraintType.ALPHA;
    }

    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        if (this.isUnification) {
            throw new UnsupportedOperationException("Should not be called");
        }
        if (!this.jitted) {
            if (this.conditionEvaluator == null) {
                this.conditionEvaluator = new MvelConditionEvaluator(this.getParserConfiguration(workingMemory), this.expression, this.operator);
            } else if (this.isJittable && this.invocationCounter.getAndIncrement() == Integer.MAX_VALUE) {
                CompositeClassLoader classLoader = ((AbstractRuleBase)workingMemory.getRuleBase()).getRootClassLoader();
                this.conditionEvaluator = ASMConditionEvaluatorJitter.jit(((MvelConditionEvaluator)this.conditionEvaluator).getExecutableStatement(), (ClassLoader)classLoader);
                this.jitted = true;
            }
        }
        Map<String, Object> vars = context == null ? null : ((MvelContextEntry)context).getRightVars(workingMemory, handle);
        try {
            return this.conditionEvaluator.evaluate(handle.getObject(), vars);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            return false;
        }
    }

    public boolean isJITAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        boolean mvelValue = false;
        if (this.conditionEvaluator == null) {
            this.conditionEvaluator = new MvelConditionEvaluator(this.getParserConfiguration(workingMemory), this.expression, this.operator);
            try {
                mvelValue = this.conditionEvaluator.evaluate(handle.getObject());
            }
            catch (ClassCastException cce) {
                System.out.println("Got ClassCastException: " + cce);
                mvelValue = false;
            }
            try {
                CompositeClassLoader classLoader = ((AbstractRuleBase)workingMemory.getRuleBase()).getRootClassLoader();
                this.conditionEvaluator = ASMConditionEvaluatorJitter.jit(((MvelConditionEvaluator)this.conditionEvaluator).getExecutableStatement(), (ClassLoader)classLoader);
            }
            catch (Throwable t) {
                throw new RuntimeException("Exception jitting: " + this.expression, t);
            }
        }
        boolean asmValue = false;
        try {
            asmValue = this.conditionEvaluator.evaluate(handle.getObject());
        }
        catch (ClassCastException cce) {
            return false;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return asmValue;
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        if (this.isUnification) {
            if (((UnificationContextEntry)context).getVariable() != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        if (this.conditionEvaluator == null) {
            ParserConfiguration conf = this.getParserConfiguration(((MvelContextEntry)context).workingMemory);
            this.conditionEvaluator = new MvelConditionEvaluator(conf, this.expression, this.operator);
        }
        return this.conditionEvaluator.evaluate(handle.getObject(), ((MvelContextEntry)context).vars);
    }

    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        if (this.isUnification) {
            DroolsQuery query = (DroolsQuery)tuple.get(0).getObject();
            Variable v = query.getVariables()[((UnificationContextEntry)context).getReader().getIndex()];
            if (v != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        if (this.conditionEvaluator == null) {
            ParserConfiguration conf = this.getParserConfiguration(((MvelContextEntry)context).workingMemory);
            this.conditionEvaluator = new MvelConditionEvaluator(conf, this.expression, this.operator);
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.conditionEvaluator.evaluate(mvelContextEntry.right, mvelContextEntry.getRightVars(tuple));
    }

    public ContextEntry createContextEntry() {
        if (this.declarations.length == 0) {
            return null;
        }
        ContextEntry contextEntry = new MvelContextEntry(this.declarations);
        if (this.isUnification) {
            contextEntry = new UnificationContextEntry(contextEntry, this.declarations[0]);
        }
        return contextEntry;
    }

    public InternalReadAccessor getFieldExtractor() {
        return this.extractor;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public Declaration getIndexingDeclaration() {
        this.indexingDeclaration.getPattern().setOffset(this.declarations[0].getPattern().getOffset());
        return this.indexingDeclaration;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        if (this.declarations[0].equals(oldDecl)) {
            this.declarations[0] = newDecl;
        }
        if (this.indexingDeclaration != null && this.indexingDeclaration.equals(oldDecl)) {
            this.indexingDeclaration = newDecl;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.packageName);
        out.writeObject(this.expression);
        out.writeObject(this.operator);
        out.writeObject(this.declarations);
        out.writeObject(this.indexingDeclaration);
        out.writeObject(this.extractor);
        out.writeBoolean(this.isUnification);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.packageName = (String)in.readObject();
        this.expression = (String)in.readObject();
        this.operator = (String)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.indexingDeclaration = (Declaration)in.readObject();
        this.extractor = (InternalReadAccessor)in.readObject();
        this.isUnification = in.readBoolean();
        this.init();
    }

    public boolean isTemporal() {
        return false;
    }

    public Object clone() {
        return new MvelConstraint(this.packageName, this.expression, this.operator, this.declarations, this.indexingDeclaration, this.extractor);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != MvelConstraint.class) {
            return false;
        }
        return this.expression.equals(((MvelConstraint)object).expression);
    }

    private ParserConfiguration getParserConfiguration(InternalWorkingMemory workingMemory) {
        return this.conf == null ? this.getParserConfiguration(workingMemory.getRuleBase()) : this.conf;
    }

    private ParserConfiguration getParserConfiguration(RuleBase ruleBase) {
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)ruleBase.getPackage(this.packageName).getDialectRuntimeRegistry().getDialectData("mvel");
        return data.getParserConfiguration();
    }

    public static class PlainIndexEvaluator
    implements IndexEvaluator {
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            if (value1 instanceof String) {
                return value1.equals(value2.toString());
            }
            return value1.equals(value2);
        }
    }

    public static class UnificationContextEntry
    implements ContextEntry {
        private ContextEntry contextEntry;
        private Declaration declaration;
        private Variable variable;
        private ArrayElementReader reader;

        public UnificationContextEntry(ContextEntry contextEntry, Declaration declaration) {
            this.contextEntry = contextEntry;
            this.declaration = declaration;
            this.reader = (ArrayElementReader)this.declaration.getExtractor();
        }

        public ContextEntry getContextEntry() {
            return this.contextEntry;
        }

        public ArrayElementReader getReader() {
            return this.reader;
        }

        public ContextEntry getNext() {
            return this.contextEntry.getNext();
        }

        public void resetFactHandle() {
            this.contextEntry.resetFactHandle();
        }

        public void resetTuple() {
            this.contextEntry.resetTuple();
            this.variable = null;
        }

        public void setNext(ContextEntry entry) {
            this.contextEntry.setNext(entry);
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.contextEntry.updateFromFactHandle(workingMemory, handle);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            DroolsQuery query = (DroolsQuery)tuple.get(0).getObject();
            Variable v = query.getVariables()[this.reader.getIndex()];
            if (v == null) {
                this.variable = null;
                this.contextEntry.updateFromTuple(workingMemory, tuple);
            } else {
                this.variable = v;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.contextEntry = (ContextEntry)in.readObject();
            this.declaration = (Declaration)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.contextEntry);
            out.writeObject(this.declaration);
        }

        public Variable getVariable() {
            return this.variable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MvelContextEntry
    implements ContextEntry {
        Object left;
        Object right;
        Declaration[] declarations;
        ContextEntry next;
        transient Map<String, Object> vars = new HashMap<String, Object>();
        transient InternalWorkingMemory workingMemory;

        public MvelContextEntry() {
        }

        public MvelContextEntry(Declaration[] declarations) {
            this.declarations = declarations;
        }

        @Override
        public ContextEntry getNext() {
            return this.next;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.workingMemory = workingMemory;
            Declaration declaration = this.declarations[0];
            InternalFactHandle handle = tuple.get(declaration);
            this.left = declaration.getExtractor().getValue(workingMemory, handle.getObject());
            this.getRightVars(workingMemory, handle);
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.right = handle.getObject();
        }

        Map<String, Object> getRightVars(LeftTuple tuple) {
            return this.getRightVars(this.workingMemory, tuple.get(this.declarations[0]));
        }

        Map<String, Object> getRightVars(InternalFactHandle handle) {
            return this.getRightVars(this.workingMemory, handle);
        }

        Map<String, Object> getRightVars(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            if (this.declarations.length == 0) {
                return null;
            }
            for (Declaration declaration : this.declarations) {
                this.vars.put(declaration.getBindingName(), declaration.getExtractor().getValue(workingMemory, handle.getObject()));
            }
            return this.vars;
        }

        @Override
        public void resetTuple() {
            this.left = null;
            this.vars.clear();
        }

        @Override
        public void resetFactHandle() {
            this.workingMemory = null;
            this.right = null;
            this.vars.clear();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.left = in.readObject();
            this.right = in.readObject();
            this.declarations = (Declaration[])in.readObject();
            this.next = (ContextEntry)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.left);
            out.writeObject(this.right);
            out.writeObject(this.declarations);
            out.writeObject(this.next);
        }
    }
}

