/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Date;
import org.drools.runtime.Calendars;
import org.drools.time.Calendar;
import org.drools.time.Trigger;

public class IntervalTrigger
implements Trigger {
    private Date startTime;
    private Date endTime;
    private int repeatLimit;
    private int repeatCount;
    private Date nextFireTime;
    private long period;
    private String[] calendarNames;
    private Calendars calendars;

    public IntervalTrigger() {
    }

    public IntervalTrigger(long timestamp, Date startTime, Date endTime, int repeatLimit, long delay, long period, String[] calendarNames, Calendars calendars) {
        this.period = period;
        if (startTime == null) {
            startTime = new Date(timestamp);
        }
        this.setStartTime(startTime);
        if (endTime != null) {
            this.setEndTime(endTime);
        }
        this.repeatLimit = repeatLimit;
        this.calendarNames = calendarNames;
        this.calendars = calendars;
        this.nextFireTime = new Date(timestamp + delay);
        this.setFirstFireTime();
        this.updateToNextIncludeDate();
    }

    public int getRepeatLimit() {
        return this.repeatLimit;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public long getPeriod() {
        return this.period;
    }

    public String[] getCalendarNames() {
        return this.calendarNames;
    }

    public Calendars getCalendars() {
        return this.calendars;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && startTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        java.util.Calendar cl = java.util.Calendar.getInstance();
        cl.setTime(startTime);
        cl.set(14, 0);
        this.startTime = cl.getTime();
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    public void setFirstFireTime() {
        if (this.getStartTime().after(this.nextFireTime)) {
            this.nextFireTime = new Date(this.getStartTime().getTime() - 1000L);
        }
        if (this.getEndTime() != null && this.nextFireTime.compareTo(this.getEndTime()) >= 0) {
            this.nextFireTime = null;
        }
        Date pot = this.getTimeAfter();
        if (this.getEndTime() != null && pot != null && pot.after(this.getEndTime())) {
            this.nextFireTime = null;
        }
    }

    public Date hasNextFireTime() {
        return this.nextFireTime;
    }

    public Date nextFireTime() {
        if (this.nextFireTime == null) {
            return null;
        }
        Date date = this.nextFireTime;
        this.nextFireTime = this.getTimeAfter();
        this.updateToNextIncludeDate();
        if (this.endTime != null && this.nextFireTime.after(this.endTime)) {
            this.nextFireTime = null;
        } else if (this.repeatLimit != -1 && this.repeatCount >= this.repeatLimit) {
            this.nextFireTime = null;
        }
        return date;
    }

    private Date getTimeAfter() {
        ++this.repeatCount;
        Date date = this.period != 0L ? new Date(this.nextFireTime.getTime() + this.period) : null;
        return date;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nextFireTime = (Date)in.readObject();
        this.period = in.readLong();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.nextFireTime);
        out.writeLong(this.period);
    }

    public void updateToNextIncludeDate() {
        if (this.calendars == null || this.calendarNames == null || this.calendarNames.length == 0) {
            return;
        }
        while (this.nextFireTime != null && (this.endTime == null || this.nextFireTime.before(this.endTime))) {
            boolean included = true;
            for (String calName : this.calendarNames) {
                Calendar cal = this.calendars.get(calName);
                if (cal == null || cal.isTimeIncluded(this.nextFireTime.getTime())) continue;
                included = false;
                break;
            }
            if (included) break;
            this.nextFireTime = this.getTimeAfter();
        }
    }

    public void setRepeatLimit(int repeatLimit) {
        this.repeatLimit = repeatLimit;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public void setCalendarNames(String[] calendarNames) {
        this.calendarNames = calendarNames;
    }

    public void setCalendars(Calendars calendars) {
        this.calendars = calendars;
    }

    public String toString() {
        return "IntervalTrigger [startTime=" + this.startTime + ", endTime=" + this.endTime + ", repeatLimit=" + this.repeatLimit + ", repeatCount=" + this.repeatCount + ", nextFireTime=" + this.nextFireTime + ", period=" + this.period + ", calendarNames=" + Arrays.toString(this.calendarNames) + ", calendars=" + this.calendars + "]";
    }
}

