/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class BeforeEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator BEFORE = Operator.addOperatorToRegistry("before", false);
    public static final Operator NOT_BEFORE = Operator.addOperatorToRegistry("before", true);
    private static final String[] SUPPORTED_IDS = new String[]{BEFORE.getOperatorString()};
    private Map<String, BeforeEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        BeforeEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, BeforeEvaluator>();
        }
        if ((eval = this.cache.get(key = (Object)((Object)left) + ":" + (Object)((Object)right) + ":" + isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new BeforeEvaluator(type, isNegated, params, parameterText, left == EvaluatorDefinition.Target.FACT, right == EvaluatorDefinition.Target.FACT);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.BOTH;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class BeforeEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long initRange;
        private long finalRange;
        private String paramText;
        private boolean unwrapLeft;
        private boolean unwrapRight;

        public BeforeEvaluator() {
        }

        public BeforeEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText, boolean unwrapLeft, boolean unwrapRight) {
            super(type, isNegated ? NOT_BEFORE : BEFORE);
            this.paramText = paramText;
            this.unwrapLeft = unwrapLeft;
            this.unwrapRight = unwrapRight;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initRange = in.readLong();
            this.finalRange = in.readLong();
            this.paramText = (String)in.readObject();
            this.unwrapLeft = in.readBoolean();
            this.unwrapRight = in.readBoolean();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.initRange);
            out.writeLong(this.finalRange);
            out.writeObject(this.paramText);
            out.writeBoolean(this.unwrapLeft);
            out.writeBoolean(this.unwrapRight);
        }

        public Object prepareLeftObject(InternalFactHandle handle) {
            return this.unwrapLeft ? handle.getObject() : handle;
        }

        public Object prepareRightObject(InternalFactHandle handle) {
            return this.unwrapRight ? handle.getObject() : handle;
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            long end;
            long init = this.finalRange == Long.MAX_VALUE ? Long.MIN_VALUE : -this.finalRange;
            long l = end = this.initRange == Long.MIN_VALUE ? Long.MAX_VALUE : -this.initRange;
            if (this.getOperator().isNegated()) {
                if (init == Long.MIN_VALUE && end != Long.MAX_VALUE) {
                    init = this.finalRange + 1L;
                    end = Long.MAX_VALUE;
                } else if (init != Long.MIN_VALUE && end == Long.MAX_VALUE) {
                    init = Long.MIN_VALUE;
                    end = this.initRange - 1L;
                } else if (init == Long.MIN_VALUE && end == Long.MAX_VALUE) {
                    init = 0L;
                    end = -1L;
                } else {
                    init = Long.MIN_VALUE;
                    end = Long.MAX_VALUE;
                }
            }
            return new Interval(init, end);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'before' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            long rightTS = this.unwrapRight ? (context instanceof VariableRestriction.ObjectVariableContextEntry ? (((VariableRestriction.ObjectVariableContextEntry)context).right instanceof Date ? ((Date)((VariableRestriction.ObjectVariableContextEntry)context).right).getTime() : ((Number)((VariableRestriction.ObjectVariableContextEntry)context).right).longValue()) : ((VariableRestriction.LongVariableContextEntry)context).right) : ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).right).getEndTimestamp();
            long leftTS = this.unwrapLeft ? context.declaration.getExtractor().getLongValue(workingMemory, left) : ((EventFactHandle)left).getStartTimestamp();
            long dist = leftTS - rightTS;
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            long rightTS;
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            long l = rightTS = this.unwrapRight ? context.extractor.getLongValue(workingMemory, right) : ((EventFactHandle)right).getEndTimestamp();
            long leftTS = this.unwrapLeft ? (context instanceof VariableRestriction.ObjectVariableContextEntry ? (((VariableRestriction.ObjectVariableContextEntry)context).left instanceof Date ? ((Date)((VariableRestriction.ObjectVariableContextEntry)context).left).getTime() : ((Number)((VariableRestriction.ObjectVariableContextEntry)context).left).longValue()) : ((VariableRestriction.LongVariableContextEntry)context).left) : ((EventFactHandle)((VariableRestriction.ObjectVariableContextEntry)context).left).getStartTimestamp();
            long dist = leftTS - rightTS;
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            long rightTS = this.unwrapRight ? extractor1.getLongValue(workingMemory, object1) : ((EventFactHandle)object1).getEndTimestamp();
            long leftTS = this.unwrapLeft ? extractor2.getLongValue(workingMemory, object2) : ((EventFactHandle)object2).getStartTimestamp();
            long dist = leftTS - rightTS;
            return this.getOperator().isNegated() ^ (dist >= this.initRange && dist <= this.finalRange);
        }

        public String toString() {
            return this.getOperator().toString() + "[" + this.paramText + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.finalRange ^ this.finalRange >>> 32);
            result = 31 * result + (int)(this.initRange ^ this.initRange >>> 32);
            result = 31 * result + (this.paramText == null ? 0 : this.paramText.hashCode());
            result = 31 * result + (this.unwrapLeft ? 1231 : 1237);
            result = 31 * result + (this.unwrapRight ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeforeEvaluator other = (BeforeEvaluator)obj;
            if (this.finalRange != other.finalRange) {
                return false;
            }
            if (this.initRange != other.initRange) {
                return false;
            }
            if (this.paramText == null ? other.paramText != null : !this.paramText.equals(other.paramText)) {
                return false;
            }
            if (this.unwrapLeft != other.unwrapLeft) {
                return false;
            }
            return this.unwrapRight == other.unwrapRight;
        }

        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.initRange = 1L;
                this.finalRange = Long.MAX_VALUE;
                return;
            }
            if (parameters.length == 1) {
                this.initRange = parameters[0];
                this.finalRange = Long.MAX_VALUE;
            } else if (parameters.length == 2) {
                if (parameters[0] <= parameters[1]) {
                    this.initRange = parameters[0];
                    this.finalRange = parameters[1];
                } else {
                    this.initRange = parameters[1];
                    this.finalRange = parameters[0];
                }
            } else {
                throw new RuntimeDroolsException("[Before Evaluator]: Not possible to have more than 2 parameters: '" + this.paramText + "'");
            }
        }
    }
}

