/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorCache;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.DateUtils;
import org.drools.core.util.MathUtils;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;

public class EqualityEvaluatorsDefinition
implements EvaluatorDefinition {
    private static final String[] SUPPORTED_IDS = new String[]{Operator.EQUAL.getOperatorString(), Operator.NOT_EQUAL.getOperatorString()};
    private EvaluatorCache evaluators = new EvaluatorCache(){
        private static final long serialVersionUID = 510L;
        {
            this.addEvaluator(ValueType.ARRAY_TYPE, Operator.EQUAL, ArrayEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.ARRAY_TYPE, Operator.NOT_EQUAL, ArrayNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_DECIMAL_TYPE, Operator.EQUAL, BigDecimalEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_DECIMAL_TYPE, Operator.NOT_EQUAL, BigDecimalNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_INTEGER_TYPE, Operator.EQUAL, BigIntegerEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_INTEGER_TYPE, Operator.NOT_EQUAL, BigIntegerNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BOOLEAN_TYPE, Operator.EQUAL, BooleanEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BOOLEAN_TYPE, Operator.NOT_EQUAL, BooleanNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBOOLEAN_TYPE, Operator.EQUAL, BooleanEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBOOLEAN_TYPE, Operator.NOT_EQUAL, BooleanNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BYTE_TYPE, Operator.EQUAL, ByteEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BYTE_TYPE, Operator.NOT_EQUAL, ByteNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBYTE_TYPE, Operator.EQUAL, ByteEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBYTE_TYPE, Operator.NOT_EQUAL, ByteNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.CHAR_TYPE, Operator.EQUAL, CharacterEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.CHAR_TYPE, Operator.NOT_EQUAL, CharacterNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PCHAR_TYPE, Operator.EQUAL, CharacterEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PCHAR_TYPE, Operator.NOT_EQUAL, CharacterNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DATE_TYPE, Operator.EQUAL, DateEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DATE_TYPE, Operator.NOT_EQUAL, DateNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DOUBLE_TYPE, Operator.EQUAL, DoubleEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DOUBLE_TYPE, Operator.NOT_EQUAL, DoubleNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PDOUBLE_TYPE, Operator.EQUAL, DoubleEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PDOUBLE_TYPE, Operator.NOT_EQUAL, DoubleNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.FACTTEMPLATE_TYPE, Operator.EQUAL, FactTemplateEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.FACTTEMPLATE_TYPE, Operator.NOT_EQUAL, FactTemplateNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.FLOAT_TYPE, Operator.EQUAL, FloatEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.FLOAT_TYPE, Operator.NOT_EQUAL, FloatNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PFLOAT_TYPE, Operator.EQUAL, FloatEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PFLOAT_TYPE, Operator.NOT_EQUAL, FloatNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.INTEGER_TYPE, Operator.EQUAL, IntegerEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.INTEGER_TYPE, Operator.NOT_EQUAL, IntegerNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PINTEGER_TYPE, Operator.EQUAL, IntegerEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PINTEGER_TYPE, Operator.NOT_EQUAL, IntegerNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.LONG_TYPE, Operator.EQUAL, LongEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.LONG_TYPE, Operator.NOT_EQUAL, LongNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PLONG_TYPE, Operator.EQUAL, LongEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PLONG_TYPE, Operator.NOT_EQUAL, LongNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, Operator.EQUAL, ObjectEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, Operator.NOT_EQUAL, ObjectNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.SHORT_TYPE, Operator.EQUAL, ShortEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.SHORT_TYPE, Operator.NOT_EQUAL, ShortNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PSHORT_TYPE, Operator.EQUAL, ShortEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PSHORT_TYPE, Operator.NOT_EQUAL, ShortNotEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.STRING_TYPE, Operator.EQUAL, StringEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.STRING_TYPE, Operator.NOT_EQUAL, StringNotEqualEvaluator.INSTANCE);
        }
    };

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (EvaluatorCache)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        return this.evaluators.getEvaluator(type, Operator.determineOperator(operatorId, isNegated));
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return false;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    public boolean supportsType(ValueType type) {
        return this.evaluators.supportsType(type);
    }

    protected static class ObjectEqualsComparator {
        protected ObjectEqualsComparator() {
        }

        public boolean equals(Object arg0, Object arg1) {
            if (arg0 == null || arg1 == null) {
                return arg0 == arg1;
            }
            if (arg0 instanceof Number) {
                double val0 = ((Number)arg0).doubleValue();
                double val1 = 0.0;
                if (arg1 instanceof Number) {
                    val1 = ((Number)arg1).doubleValue();
                } else if (arg1 instanceof String) {
                    try {
                        val1 = Double.parseDouble((String)arg1);
                    }
                    catch (Exception ex) {
                        return false;
                    }
                } else {
                    return false;
                }
                return val0 == val1;
            }
            if (arg0 instanceof String) {
                return arg0.equals(arg1.toString());
            }
            if (arg0 instanceof Boolean && arg1 instanceof String) {
                return ((Boolean)arg0).booleanValue() == Boolean.valueOf((String)arg1).booleanValue();
            }
            if (arg0 instanceof Character && arg1 instanceof String && ((String)arg1).length() == 1) {
                return ((Character)arg0).charValue() == ((String)arg1).charAt(0);
            }
            return arg0.equals(arg1);
        }
    }

    public static class StringNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringNotEqualEvaluator();

        public StringNotEqualEvaluator() {
            super(ValueType.STRING_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            return !value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            return !((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public String toString() {
            return "String !=";
        }
    }

    public static class StringEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringEqualEvaluator();

        public StringEqualEvaluator() {
            super(ValueType.STRING_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            return value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            return ((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public String toString() {
            return "String ==";
        }
    }

    public static class ShortNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortNotEqualEvaluator();

        public ShortNotEqualEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getShortValue(workingMemory, object1) != object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return (long)context.declaration.getExtractor().getShortValue(workingMemory, left) != ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left != (long)context.extractor.getShortValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getShortValue(workingMemory, object1) != extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Short !=";
        }
    }

    public static class ShortEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortEqualEvaluator();

        public ShortEqualEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getShortValue(workingMemory, object1) == object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return (long)context.declaration.getExtractor().getShortValue(workingMemory, left) == ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left == (long)context.extractor.getShortValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getShortValue(workingMemory, object1) == extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Short ==";
        }
    }

    public static class ObjectNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectNotEqualEvaluator();
        private static final ObjectEqualsComparator comparator = new ObjectEqualsComparator();

        public ObjectNotEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value2;
            Object value1 = extractor.getValue(workingMemory, object1);
            return !comparator.equals(value1, value2 = object2.getValue());
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            return !comparator.equals(((VariableRestriction.ObjectVariableContextEntry)context).right, value);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            return !comparator.equals(value, ((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value2;
            Object value1 = extractor1.getValue(workingMemory, object1);
            return !comparator.equals(value1, value2 = extractor2.getValue(workingMemory, object2));
        }

        public String toString() {
            return "Object !=";
        }
    }

    public static class ObjectEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectEqualEvaluator();
        private static final ObjectEqualsComparator comparator = new ObjectEqualsComparator();

        public ObjectEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            return comparator.equals(value1, value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            return comparator.equals(((VariableRestriction.ObjectVariableContextEntry)context).right, value);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            return comparator.equals(value, ((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            return comparator.equals(value1, value2);
        }

        public String toString() {
            return "Object ==";
        }
    }

    public static class LongNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new LongNotEqualEvaluator();

        public LongNotEqualEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getLongValue(workingMemory, object1) != object2.getLongValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return context.declaration.getExtractor().getLongValue(workingMemory, left) != ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left != context.extractor.getLongValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getLongValue(workingMemory, object1) != extractor2.getLongValue(workingMemory, object2);
        }

        public String toString() {
            return "Long !=";
        }
    }

    public static class LongEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new LongEqualEvaluator();

        public LongEqualEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getLongValue(workingMemory, object1) == object2.getLongValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return context.declaration.getExtractor().getLongValue(workingMemory, left) == ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left == context.extractor.getLongValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getLongValue(workingMemory, object1) == extractor2.getLongValue(workingMemory, object2);
        }

        public String toString() {
            return "Long ==";
        }
    }

    public static class IntegerNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerNotEqualEvaluator();

        public IntegerNotEqualEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getIntValue(workingMemory, object1) != object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return (long)context.declaration.getExtractor().getIntValue(workingMemory, left) != ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object object2) {
            if (context.extractor.isNullValue(workingMemory, object2)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return (long)context.extractor.getIntValue(workingMemory, object2) != ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getIntValue(workingMemory, object1) != extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer !=";
        }
    }

    public static class IntegerEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerEqualEvaluator();

        public IntegerEqualEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getIntValue(workingMemory, object1) == object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return (long)context.declaration.getExtractor().getIntValue(workingMemory, left) == ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object object2) {
            if (context.extractor.isNullValue(workingMemory, object2)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return (long)context.extractor.getIntValue(workingMemory, object2) == ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getIntValue(workingMemory, object1) == extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer ==";
        }
    }

    public static class FloatNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FloatNotEqualEvaluator();

        public FloatNotEqualEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getFloatValue(workingMemory, object1) != object2.getFloatValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return (double)context.declaration.getExtractor().getFloatValue(workingMemory, left) != ((VariableRestriction.DoubleVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).left != (double)context.extractor.getFloatValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getFloatValue(workingMemory, object1) != extractor2.getFloatValue(workingMemory, object2);
        }

        public String toString() {
            return "Float !=";
        }
    }

    public static class FloatEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FloatEqualEvaluator();

        public FloatEqualEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getFloatValue(workingMemory, object1) == object2.getFloatValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return (double)context.declaration.getExtractor().getFloatValue(workingMemory, left) == ((VariableRestriction.DoubleVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).left == (double)context.extractor.getFloatValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getFloatValue(workingMemory, object1) == extractor2.getFloatValue(workingMemory, object2);
        }

        public String toString() {
            return "Float ==";
        }
    }

    public static class FactTemplateNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FactTemplateNotEqualEvaluator();

        public FactTemplateNotEqualEvaluator() {
            super(ValueType.FACTTEMPLATE_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            return !value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            return !((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public String toString() {
            return "FactTemplate !=";
        }
    }

    public static class FactTemplateEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FactTemplateEqualEvaluator();

        public FactTemplateEqualEvaluator() {
            super(ValueType.FACTTEMPLATE_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            return value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            return ((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public String toString() {
            return "FactTemplate ==";
        }
    }

    public static class DoubleNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DoubleNotEqualEvaluator();

        public DoubleNotEqualEvaluator() {
            super(ValueType.PDOUBLE_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getDoubleValue(workingMemory, object1) != object2.getDoubleValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return context.declaration.getExtractor().getDoubleValue(workingMemory, left) != ((VariableRestriction.DoubleVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).left != context.extractor.getDoubleValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getDoubleValue(workingMemory, object1) != extractor2.getDoubleValue(workingMemory, object2);
        }

        public String toString() {
            return "Double !=";
        }
    }

    public static class DoubleEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DoubleEqualEvaluator();

        public DoubleEqualEvaluator() {
            super(ValueType.PDOUBLE_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getDoubleValue(workingMemory, object1) == object2.getDoubleValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return context.declaration.getExtractor().getDoubleValue(workingMemory, left) == ((VariableRestriction.DoubleVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).left == context.extractor.getDoubleValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getDoubleValue(workingMemory, object1) == extractor2.getDoubleValue(workingMemory, object2);
        }

        public String toString() {
            return "Double ==";
        }
    }

    public static class DateNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateNotEqualEvaluator();

        public DateNotEqualEvaluator() {
            super(ValueType.DATE_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 != null;
            }
            if (value2 == null) {
                return true;
            }
            return value1.compareTo(DateUtils.getRightDate(value2, workingMemory.getDateFormats())) != 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value1 == null) {
                return value2 != null;
            }
            if (value2 == null) {
                return true;
            }
            return value1.compareTo(DateUtils.getRightDate(value2, workingMemory.getDateFormats())) != 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            if (value1 == null) {
                return value2 != null;
            }
            if (value2 == null) {
                return true;
            }
            return value1.compareTo(DateUtils.getRightDate(value2, workingMemory.getDateFormats())) != 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            if (value2 == null) {
                return true;
            }
            return value1.compareTo(value2) != 0;
        }

        public String toString() {
            return "Date !=";
        }
    }

    public static class DateEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateEqualEvaluator();

        public DateEqualEvaluator() {
            super(ValueType.DATE_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 == null) {
                return false;
            }
            return value1.compareTo(DateUtils.getRightDate(value2, workingMemory.getDateFormats())) == 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 == null) {
                return false;
            }
            return value1.compareTo(DateUtils.getRightDate(value2, workingMemory.getDateFormats())) == 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 == null) {
                return false;
            }
            return value1.compareTo(DateUtils.getRightDate(value2, workingMemory.getDateFormats())) == 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            if (value2 == null) {
                return false;
            }
            return value1.compareTo(value2) == 0;
        }

        public String toString() {
            return "Date ==";
        }
    }

    public static class CharacterNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterNotEqualEvaluator();

        public CharacterNotEqualEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getCharValue(workingMemory, object1) != object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return context.declaration.getExtractor().getCharValue(workingMemory, left) != ((VariableRestriction.CharVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).left != context.extractor.getCharValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getCharValue(workingMemory, object1) != extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character !=";
        }
    }

    public static class CharacterEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterEqualEvaluator();

        public CharacterEqualEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getCharValue(workingMemory, object1) == object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return context.declaration.getExtractor().getCharValue(workingMemory, left) == ((VariableRestriction.CharVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).left == context.extractor.getCharValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getCharValue(workingMemory, object1) == extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character ==";
        }
    }

    public static class ByteNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ByteNotEqualEvaluator();

        public ByteNotEqualEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getByteValue(workingMemory, object1) != object2.getByteValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return (long)context.declaration.getExtractor().getByteValue(workingMemory, left) != ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object object2) {
            if (context.extractor.isNullValue(workingMemory, object2)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left != (long)context.extractor.getByteValue(workingMemory, object2);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getByteValue(workingMemory, object1) != extractor2.getByteValue(workingMemory, object2);
        }

        public String toString() {
            return "Byte !=";
        }
    }

    public static class ByteEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ByteEqualEvaluator();

        public ByteEqualEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getByteValue(workingMemory, object1) == object2.getByteValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return (long)context.declaration.getExtractor().getByteValue(workingMemory, left) == ((VariableRestriction.LongVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).left == (long)context.extractor.getByteValue(workingMemory, right);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getByteValue(workingMemory, object1) == extractor2.getByteValue(workingMemory, object2);
        }

        public String toString() {
            return "Byte ==";
        }
    }

    public static class BooleanNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BooleanNotEqualEvaluator();

        public BooleanNotEqualEvaluator() {
            super(ValueType.PBOOLEAN_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return !object2.isNull();
            }
            if (object2.isNull()) {
                return true;
            }
            return extractor.getBooleanValue(workingMemory, object1) != object2.getBooleanValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return !context.isRightNull();
            }
            if (context.isRightNull()) {
                return true;
            }
            return context.declaration.getExtractor().getBooleanValue(workingMemory, left) != ((VariableRestriction.BooleanVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object object2) {
            if (context.extractor.isNullValue(workingMemory, object2)) {
                return !context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return true;
            }
            return context.extractor.getBooleanValue(workingMemory, object2) != ((VariableRestriction.BooleanVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return !extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return true;
            }
            return extractor1.getBooleanValue(workingMemory, object1) != extractor2.getBooleanValue(workingMemory, object2);
        }

        public String toString() {
            return "Boolean !=";
        }
    }

    public static class BooleanEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new BooleanEqualEvaluator();

        public BooleanEqualEvaluator() {
            super(ValueType.PBOOLEAN_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return object2.isNull();
            }
            if (object2.isNull()) {
                return false;
            }
            return extractor.getBooleanValue(workingMemory, object1) == object2.getBooleanValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.declaration.getExtractor().isNullValue(workingMemory, left)) {
                return context.isRightNull();
            }
            if (context.isRightNull()) {
                return false;
            }
            return context.declaration.getExtractor().getBooleanValue(workingMemory, left) == ((VariableRestriction.BooleanVariableContextEntry)context).right;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object object2) {
            if (context.extractor.isNullValue(workingMemory, object2)) {
                return context.isLeftNull();
            }
            if (context.isLeftNull()) {
                return false;
            }
            return context.extractor.getBooleanValue(workingMemory, object2) == ((VariableRestriction.BooleanVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return extractor2.isNullValue(workingMemory, object2);
            }
            if (extractor2.isNullValue(workingMemory, object2)) {
                return false;
            }
            return extractor1.getBooleanValue(workingMemory, object1) == extractor2.getBooleanValue(workingMemory, object2);
        }

        public String toString() {
            return "Boolean ==";
        }
    }

    public static class BigIntegerNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerNotEqualEvaluator();

        public BigIntegerNotEqualEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            BigInteger value1 = extractor.getBigIntegerValue(workingMemory, object1);
            BigInteger value2 = object2.getBigIntegerValue();
            if (value1 == null) {
                return value2 != null;
            }
            return !((Object)value1).equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            BigInteger value = context.declaration.getExtractor().getBigIntegerValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            return !((Object)value).equals(MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).right));
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            BigInteger value = context.extractor.getBigIntegerValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            return !MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).left).equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            BigInteger value1 = extractor1.getBigIntegerValue(workingMemory, object1);
            BigInteger value2 = extractor2.getBigIntegerValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            return !((Object)value1).equals(value2);
        }

        public String toString() {
            return "BigInteger !=";
        }
    }

    public static class BigIntegerEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerEqualEvaluator();

        public BigIntegerEqualEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            BigInteger value1 = extractor.getBigIntegerValue(workingMemory, object1);
            BigInteger value2 = object2.getBigIntegerValue();
            if (value1 == null) {
                return value2 == null;
            }
            return ((Object)value1).equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            BigInteger value = context.declaration.getExtractor().getBigIntegerValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            return ((Object)value).equals(MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).right));
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            BigInteger value = context.extractor.getBigIntegerValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            return MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).left).equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            BigInteger value1 = extractor1.getBigIntegerValue(workingMemory, object1);
            BigInteger value2 = extractor2.getBigIntegerValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            return ((Object)value1).equals(value2);
        }

        public String toString() {
            return "BigInteger ==";
        }
    }

    public static class BigDecimalNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalNotEqualEvaluator();

        public BigDecimalNotEqualEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            BigDecimal value1 = extractor.getBigDecimalValue(workingMemory, object1);
            BigDecimal value2 = object2.getBigDecimalValue();
            if (value1 == null) {
                return value2 != null;
            }
            return !BigDecimalEqualEvaluator.isEqual(value1, value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            BigDecimal value = context.declaration.getExtractor().getBigDecimalValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            return !BigDecimalEqualEvaluator.isEqual(value, MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).right));
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            BigDecimal value = context.extractor.getBigDecimalValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            return !BigDecimalEqualEvaluator.isEqual(MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).left), value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            BigDecimal value1 = extractor1.getBigDecimalValue(workingMemory, object1);
            BigDecimal value2 = extractor2.getBigDecimalValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            return !BigDecimalEqualEvaluator.isEqual(value1, value2);
        }

        public String toString() {
            return "BigDecimal !=";
        }
    }

    public static class BigDecimalEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalEqualEvaluator();

        static boolean isEqual(Object value1, Object value2) {
            if (!(value1 instanceof BigDecimal) || !(value2 instanceof BigDecimal)) {
                return false;
            }
            return ((BigDecimal)value1).compareTo((BigDecimal)value2) == 0;
        }

        public BigDecimalEqualEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            BigDecimal value1 = extractor.getBigDecimalValue(workingMemory, object1);
            BigDecimal value2 = object2.getBigDecimalValue();
            if (value1 == null) {
                return value2 == null;
            }
            return BigDecimalEqualEvaluator.isEqual(value1, value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            BigDecimal value = context.declaration.getExtractor().getBigDecimalValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            return BigDecimalEqualEvaluator.isEqual(value, MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).right));
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            BigDecimal value = context.extractor.getBigDecimalValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            return BigDecimalEqualEvaluator.isEqual(MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).left), value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            BigDecimal value1 = extractor1.getBigDecimalValue(workingMemory, object1);
            BigDecimal value2 = extractor2.getBigDecimalValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            return BigDecimalEqualEvaluator.isEqual(value1, value2);
        }

        public String toString() {
            return "BigDecimal ==";
        }
    }

    public static class ArrayNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ArrayNotEqualEvaluator();

        public ArrayNotEqualEvaluator() {
            super(ValueType.ARRAY_TYPE, Operator.NOT_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right != null;
            }
            return !value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value != null;
            }
            return !((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 != null;
            }
            return !value1.equals(value2);
        }

        public String toString() {
            return "Array !=";
        }
    }

    public static class ArrayEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ArrayEqualEvaluator();

        public ArrayEqualEvaluator() {
            super(ValueType.ARRAY_TYPE, Operator.EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value1 = extractor.getValue(workingMemory, object1);
            Object value2 = object2.getValue();
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            Object value = context.declaration.getExtractor().getValue(workingMemory, left);
            if (value == null) {
                return ((VariableRestriction.ObjectVariableContextEntry)context).right == null;
            }
            return value.equals(((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            Object value = context.extractor.getValue(workingMemory, right);
            if (((VariableRestriction.ObjectVariableContextEntry)context).left == null) {
                return value == null;
            }
            return ((VariableRestriction.ObjectVariableContextEntry)context).left.equals(value);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            return value1.equals(value2);
        }

        public String toString() {
            return "Array ==";
        }
    }
}

