/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.base.DroolsQuery;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.rule.ContextEntry;
import org.drools.spi.PropagationContext;

public class JoinNode
extends BetaNode {
    private static final long serialVersionUID = 510L;

    public JoinNode() {
    }

    public JoinNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints binder, Behavior[] behaviors, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, binder, behaviors);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.setOpen(true);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        ContextEntry[] contextEntry = memory.getContext();
        boolean useLeftMemory = true;
        if (this.tupleMemoryEnabled) {
            memory.getLeftTupleMemory().add(leftTuple);
        } else {
            Object object;
            if (memory.isOpen()) {
                contextEntry = this.constraints.createContext();
            }
            if ((object = ((InternalFactHandle)context.getFactHandle()).getObject()) instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
                useLeftMemory = false;
            } else if (memory.getLeftTupleMemory() != null) {
                memory.getLeftTupleMemory().add(leftTuple);
            }
        }
        this.constraints.updateFromTuple(contextEntry, workingMemory, leftTuple);
        FastIterator it = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, context, it);
        while (rightTuple != null) {
            InternalFactHandle handle = rightTuple.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(contextEntry, handle)) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, useLeftMemory);
            }
            rightTuple = (RightTuple)it.next(rightTuple);
        }
        this.constraints.resetTuple(contextEntry);
        memory.setOpen(false);
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        RightTuple rightTuple = this.createRightTuple(factHandle, this);
        if (!this.behavior.assertRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory)) {
            rightTuple.unlinkFromRightParent();
            return;
        }
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, factHandle);
        FastIterator it = memory.getLeftTupleMemory().fastIterator();
        LeftTuple leftTuple = memory.getLeftTupleMemory().getFirst(rightTuple);
        while (leftTuple != null) {
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, true);
            }
            leftTuple = (LeftTuple)it.next(leftTuple);
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        this.behavior.retractRightTuple(memory.getBehaviorContext(), rightTuple, workingMemory);
        memory.getRightTupleMemory().remove(rightTuple);
        if (rightTuple.firstChild != null) {
            this.sink.propagateRetractRightTuple(rightTuple, context, workingMemory);
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getLeftTupleMemory().remove(leftTuple);
        if (leftTuple.firstChild != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getRightTupleMemory().remove(rightTuple);
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() != null && memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        LeftTuple childLeftTuple = rightTuple.firstChild;
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator it = leftMemory.fastIterator();
        LeftTuple leftTuple = leftMemory.getFirst(rightTuple);
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        if (childLeftTuple != null && leftMemory.isIndexed() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
            this.sink.propagateRetractRightTuple(rightTuple, context, workingMemory);
            childLeftTuple = null;
        }
        if (leftTuple != null) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                        this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, true);
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            } else {
                while (leftTuple != null) {
                    if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                        if (childLeftTuple == null || childLeftTuple.getLeftParent() != leftTuple) {
                            this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, childLeftTuple, context, workingMemory, true);
                        } else {
                            childLeftTuple = this.sink.propagateModifyChildLeftTuple(childLeftTuple, leftTuple, context, workingMemory, true);
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        childLeftTuple = this.sink.propagateRetractChildLeftTuple(childLeftTuple, leftTuple, context, workingMemory);
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            }
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getLeftTupleMemory().remove(leftTuple);
        memory.getLeftTupleMemory().add(leftTuple);
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        LeftTuple childLeftTuple = leftTuple.firstChild;
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        FastIterator it = rightMemory.fastIterator();
        RightTuple rightTuple = rightMemory.getFirst(leftTuple, (InternalFactHandle)context.getFactHandle());
        if (childLeftTuple != null && rightMemory.isIndexed() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            childLeftTuple = null;
        }
        if (rightTuple != null) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (this.constraints.isAllowedCachedLeft(memory.getContext(), handle)) {
                        this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, null, null, context, workingMemory, true);
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
            } else {
                while (rightTuple != null) {
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (this.constraints.isAllowedCachedLeft(memory.getContext(), handle)) {
                        if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                            this.sink.propagateAssertLeftTuple(leftTuple, rightTuple, childLeftTuple, null, context, workingMemory, true);
                        } else {
                            childLeftTuple = this.sink.propagateModifyChildLeftTuple(childLeftTuple, rightTuple, context, workingMemory, true);
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                        childLeftTuple = this.sink.propagateRetractChildLeftTuple(childLeftTuple, rightTuple, context, workingMemory);
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
            }
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        FastIterator it = memory.getLeftTupleMemory().fastIterator();
        Iterator tupleIter = memory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            RightTuple rightTuple = memory.getRightTupleMemory().getFirst(leftTuple, (InternalFactHandle)context.getFactHandle());
            while (rightTuple != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), rightTuple.getFactHandle())) {
                    sink.assertLeftTuple(new LeftTuple(leftTuple, rightTuple, null, null, sink, true), context, workingMemory);
                }
                rightTuple = (RightTuple)it.next(rightTuple);
            }
            this.constraints.resetTuple(memory.getContext());
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    public short getType() {
        return 0;
    }

    public String toString() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.source;
        }
        return "[JoinNode(" + this.getId() + ") - " + ((ObjectTypeNode)source).getObjectType() + "]";
    }
}

