/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.rule.Behavior;

public class BehaviorManager
implements Externalizable {
    public static final Behavior[] NO_BEHAVIORS = new Behavior[0];
    private Behavior[] behaviors;

    public BehaviorManager() {
        this(NO_BEHAVIORS);
    }

    public BehaviorManager(Behavior[] behaviors) {
        this.behaviors = behaviors;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.behaviors = (Behavior[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.behaviors);
    }

    public Object createBehaviorContext() {
        Object[] behaviorCtx = new Object[this.behaviors.length];
        for (int i = 0; i < this.behaviors.length; ++i) {
            behaviorCtx[i] = this.behaviors[i].createContext();
        }
        return behaviorCtx;
    }

    public boolean assertRightTuple(Object behaviorContext, RightTuple rightTuple, InternalWorkingMemory workingMemory) {
        boolean result = true;
        for (int i = 0; i < this.behaviors.length; ++i) {
            result = result && this.behaviors[i].assertRightTuple(((Object[])behaviorContext)[i], rightTuple, workingMemory);
        }
        return result;
    }

    public void retractRightTuple(Object behaviorContext, RightTuple rightTuple, InternalWorkingMemory workingMemory) {
        for (int i = 0; i < this.behaviors.length; ++i) {
            this.behaviors[i].retractRightTuple(((Object[])behaviorContext)[i], rightTuple, workingMemory);
        }
    }

    public Behavior[] getBehaviors() {
        return this.behaviors;
    }
}

