/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Arrays;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.core.util.Entry;
import org.drools.core.util.LeftTupleList;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.RightTuple;
import org.drools.rule.Declaration;
import org.drools.spi.Tuple;

public class LeftTuple
implements Tuple,
Entry {
    private static final long serialVersionUID = 510L;
    private int index;
    private InternalFactHandle handle;
    private LeftTuple parent;
    private Object object;
    private RightTuple blocker;
    private LeftTuple blockedPrevious;
    private LeftTuple blockedNext;
    private LeftTuple leftParent;
    private LeftTuple leftParentPrevious;
    private LeftTuple leftParentNext;
    private RightTuple rightParent;
    private LeftTuple rightParentPrevious;
    private LeftTuple rightParentNext;
    private LeftTupleList memory;
    private Entry next;
    private Entry previous;
    public LeftTuple firstChild;
    public LeftTuple lastChild;
    private LeftTupleSink sink;

    public LeftTuple() {
    }

    public LeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.handle = factHandle;
        if (leftTupleMemoryEnabled) {
            LeftTuple first = this.handle.getLastLeftTuple();
            if (first == null) {
                this.handle.setFirstLeftTuple(this);
                this.handle.setLastLeftTuple(this);
            } else {
                this.leftParentPrevious = this.handle.getLastLeftTuple();
                this.leftParentPrevious.leftParentNext = this;
                this.handle.setLastLeftTuple(this);
            }
        }
        this.sink = sink;
    }

    public LeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.index = leftTuple.index;
        this.parent = leftTuple.parent;
        this.handle = leftTuple.handle;
        if (leftTupleMemoryEnabled) {
            this.leftParent = leftTuple;
            if (leftTuple.lastChild != null) {
                this.leftParentPrevious = leftTuple.lastChild;
                this.leftParentPrevious.leftParentNext = this;
            } else {
                leftTuple.firstChild = this;
            }
            leftTuple.lastChild = this;
        }
        this.sink = sink;
    }

    public LeftTuple(LeftTuple leftTuple, InternalFactHandle handle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.index = leftTuple.index + 1;
        this.parent = leftTuple;
        this.handle = handle;
        if (leftTupleMemoryEnabled) {
            this.leftParent = leftTuple;
            if (leftTuple.lastChild != null) {
                this.leftParentPrevious = leftTuple.lastChild;
                this.leftParentPrevious.leftParentNext = this;
            } else {
                leftTuple.firstChild = this;
            }
            leftTuple.lastChild = this;
        }
        this.sink = sink;
    }

    public LeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this(leftTuple, rightTuple, null, null, sink, leftTupleMemoryEnabled);
    }

    public LeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.handle = rightTuple.getFactHandle();
        this.index = leftTuple.index + 1;
        this.parent = leftTuple;
        if (leftTupleMemoryEnabled) {
            this.leftParent = leftTuple;
            this.rightParent = rightTuple;
            if (currentLeftChild == null) {
                if (leftTuple.lastChild != null) {
                    this.leftParentPrevious = leftTuple.lastChild;
                    this.leftParentPrevious.leftParentNext = this;
                } else {
                    leftTuple.firstChild = this;
                }
                leftTuple.lastChild = this;
            } else {
                this.leftParentNext = currentLeftChild;
                this.leftParentPrevious = currentLeftChild.leftParentPrevious;
                currentLeftChild.leftParentPrevious = this;
                if (this.leftParentPrevious == null) {
                    this.leftParent.firstChild = this;
                } else {
                    this.leftParentPrevious.leftParentNext = this;
                }
            }
            if (currentRightChild == null) {
                if (rightTuple.lastChild != null) {
                    this.rightParentPrevious = rightTuple.lastChild;
                    this.rightParentPrevious.rightParentNext = this;
                } else {
                    rightTuple.firstChild = this;
                }
                rightTuple.lastChild = this;
            } else {
                this.rightParentNext = currentRightChild;
                this.rightParentPrevious = currentRightChild.rightParentPrevious;
                currentRightChild.rightParentPrevious = this;
                if (this.rightParentPrevious == null) {
                    this.rightParent.firstChild = this;
                } else {
                    this.rightParentPrevious.rightParentNext = this;
                }
            }
        }
        this.sink = sink;
    }

    public void reAdd() {
        LeftTuple first = this.handle.getLastLeftTuple();
        if (first == null) {
            this.handle.setFirstLeftTuple(this);
            this.handle.setLastLeftTuple(this);
        } else {
            this.handle.getLastLeftTuple().leftParentNext = this;
            this.leftParentPrevious = this.handle.getLastLeftTuple();
            this.handle.setLastLeftTuple(this);
        }
    }

    public void reAddLeft() {
        if (this.leftParentNext != null) {
            if (this.leftParentPrevious != null) {
                this.leftParentPrevious.leftParentNext = this.leftParentNext;
                this.leftParentNext.leftParentPrevious = this.leftParentPrevious;
            } else {
                if (this.leftParent.firstChild == this) {
                    this.leftParent.firstChild = this.leftParentNext;
                }
                this.leftParentNext.leftParentPrevious = null;
            }
            this.leftParentPrevious = this.leftParent.lastChild;
            this.leftParentPrevious.leftParentNext = this;
            this.leftParent.lastChild = this;
            this.leftParentNext = null;
        }
    }

    public void reAddRight() {
        if (this.rightParentNext != null) {
            if (this.rightParentPrevious != null) {
                this.rightParentPrevious.rightParentNext = this.rightParentNext;
                this.rightParentNext.rightParentPrevious = this.rightParentPrevious;
            } else {
                if (this.rightParent.firstChild == this) {
                    this.rightParent.firstChild = this.rightParentNext;
                }
                this.rightParentNext.rightParentPrevious = null;
            }
            this.rightParentPrevious = this.rightParent.lastChild;
            this.rightParentPrevious.rightParentNext = this;
            this.rightParent.lastChild = this;
            this.rightParentNext = null;
        }
    }

    public void unlinkFromLeftParent() {
        LeftTuple previousParent = this.leftParentPrevious;
        LeftTuple nextParent = this.leftParentNext;
        if (previousParent != null && nextParent != null) {
            this.leftParentPrevious.leftParentNext = nextParent;
            this.leftParentNext.leftParentPrevious = previousParent;
        } else if (nextParent != null) {
            if (this.leftParent != null) {
                this.leftParent.firstChild = nextParent;
            } else {
                this.handle.setFirstLeftTuple(nextParent);
            }
            nextParent.leftParentPrevious = null;
        } else if (previousParent != null) {
            if (this.leftParent != null) {
                this.leftParent.lastChild = previousParent;
            } else {
                this.handle.setLastLeftTuple(previousParent);
            }
            previousParent.leftParentNext = null;
        } else if (this.leftParent != null) {
            this.leftParent.firstChild = null;
            this.leftParent.lastChild = null;
        } else {
            this.handle.setFirstLeftTuple(null);
            this.handle.setLastLeftTuple(null);
        }
        this.leftParent = null;
        this.leftParentPrevious = null;
        this.leftParentNext = null;
        this.blocker = null;
    }

    public void unlinkFromRightParent() {
        if (this.rightParent == null) {
            return;
        }
        LeftTuple previousParent = this.rightParentPrevious;
        LeftTuple nextParent = this.rightParentNext;
        if (previousParent != null && nextParent != null) {
            this.rightParentPrevious.rightParentNext = this.rightParentNext;
            this.rightParentNext.rightParentPrevious = this.rightParentPrevious;
        } else if (nextParent != null) {
            this.rightParent.firstChild = nextParent;
            nextParent.rightParentPrevious = null;
        } else if (previousParent != null) {
            this.rightParent.lastChild = previousParent;
            previousParent.rightParentNext = null;
        } else {
            this.rightParent.firstChild = null;
            this.rightParent.lastChild = null;
        }
        this.blocker = null;
        this.rightParent = null;
        this.rightParentPrevious = null;
        this.rightParentNext = null;
    }

    public int getIndex() {
        return this.index;
    }

    public LeftTupleSink getLeftTupleSink() {
        return this.sink;
    }

    public void setLeftTupleSink(LeftTupleSink sink) {
        this.sink = sink;
    }

    public LeftTuple getLeftParent() {
        return this.leftParent;
    }

    public void setLeftParent(LeftTuple leftParent) {
        this.leftParent = leftParent;
    }

    public LeftTuple getLeftParentPrevious() {
        return this.leftParentPrevious;
    }

    public void setLeftParentPrevious(LeftTuple leftParentLeft) {
        this.leftParentPrevious = leftParentLeft;
    }

    public LeftTuple getLeftParentNext() {
        return this.leftParentNext;
    }

    public void setLeftParentNext(LeftTuple leftParentright) {
        this.leftParentNext = leftParentright;
    }

    public RightTuple getRightParent() {
        return this.rightParent;
    }

    public void setRightParent(RightTuple rightParent) {
        this.rightParent = rightParent;
    }

    public LeftTuple getRightParentPrevious() {
        return this.rightParentPrevious;
    }

    public void setRightParentPrevious(LeftTuple rightParentLeft) {
        this.rightParentPrevious = rightParentLeft;
    }

    public LeftTuple getRightParentNext() {
        return this.rightParentNext;
    }

    public void setRightParentNext(LeftTuple rightParentRight) {
        this.rightParentNext = rightParentRight;
    }

    public InternalFactHandle get(int index) {
        LeftTuple entry = this;
        while (entry.index != index) {
            entry = entry.parent;
        }
        return entry.handle;
    }

    public LeftTupleList getMemory() {
        return this.memory;
    }

    public void setMemory(LeftTupleList memory) {
        this.memory = memory;
    }

    public Entry getPrevious() {
        return this.previous;
    }

    public void setPrevious(Entry previous) {
        this.previous = previous;
    }

    public void setNext(Entry next) {
        this.next = next;
    }

    public Entry getNext() {
        return this.next;
    }

    public InternalFactHandle getLastHandle() {
        return this.handle;
    }

    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getPattern().getOffset());
    }

    public InternalFactHandle[] getFactHandles() {
        InternalFactHandle[] handles = new InternalFactHandle[this.index + 1];
        LeftTuple entry = this;
        int i = 0;
        while (entry != null) {
            handles[i++] = entry.handle;
            entry = entry.parent;
        }
        return handles;
    }

    public InternalFactHandle[] toFactHandles() {
        InternalFactHandle[] handles = new InternalFactHandle[this.index + 1];
        LeftTuple entry = this;
        while (entry != null) {
            handles[entry.index] = entry.handle;
            entry = entry.parent;
        }
        return handles;
    }

    public void setBlocker(RightTuple blocker) {
        this.blocker = blocker;
    }

    public RightTuple getBlocker() {
        return this.blocker;
    }

    public LeftTuple getBlockedPrevious() {
        return this.blockedPrevious;
    }

    public void setBlockedPrevious(LeftTuple blockerPrevious) {
        this.blockedPrevious = blockerPrevious;
    }

    public LeftTuple getBlockedNext() {
        return this.blockedNext;
    }

    public void setBlockedNext(LeftTuple blockerNext) {
        this.blockedNext = blockerNext;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        LeftTuple entry = this;
        while (entry != null) {
            buffer.append(entry.handle).append("\n");
            entry = entry.parent;
        }
        return buffer.toString();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(LeftTuple other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (this.handle != other.handle) {
            return false;
        }
        if (this.parent == null) {
            return other.parent == null;
        }
        return this.parent.equals(other.parent);
    }

    public boolean equals(Object object) {
        return this.equals((LeftTuple)object);
    }

    public int size() {
        return this.index + 1;
    }

    public LeftTuple getSubTuple(int elements) {
        LeftTuple entry = this;
        if (elements < this.size()) {
            int lastindex = elements - 1;
            while (entry.index != lastindex) {
                entry = entry.parent;
            }
        }
        return entry;
    }

    public Object[] toObjectArray() {
        Object[] objects = new Object[this.index + 1];
        LeftTuple entry = this;
        while (entry != null) {
            Object object;
            objects[entry.index] = object = entry.getLastHandle().getObject();
            entry = entry.parent;
        }
        return objects;
    }

    public LeftTuple getParent() {
        return this.parent;
    }

    public String toTupleTree(int indent) {
        StringBuilder buf = new StringBuilder();
        char[] spaces = new char[indent];
        Arrays.fill(spaces, ' ');
        String istr = new String(spaces);
        buf.append(istr);
        buf.append(this.toExternalString());
        buf.append("\n");
        for (LeftTuple leftTuple = this.firstChild; leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            buf.append(leftTuple.toTupleTree(indent + 4));
        }
        return buf.toString();
    }

    private String toExternalString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%08X", System.identityHashCode(this))).append(":");
        int[] ids = new int[this.index + 1];
        LeftTuple entry = this;
        while (entry != null) {
            ids[entry.index] = entry.getLastHandle().getId();
            entry = entry.parent;
        }
        builder.append(Arrays.toString(ids)).append(" activation=").append(this.object != null ? this.object : "null").append(" sink=").append(this.sink.getClass().getSimpleName()).append("(").append(this.sink.getId()).append(")");
        return builder.toString();
    }

    public void increaseActivationCountForEvents() {
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            if (!entry.getLastHandle().isEvent()) continue;
            ((EventFactHandle)entry.getLastHandle()).increaseActivationsCount();
        }
    }

    public void decreaseActivationCountForEvents() {
        for (LeftTuple entry = this; entry != null; entry = entry.getParent()) {
            if (!entry.getLastHandle().isEvent()) continue;
            ((EventFactHandle)entry.getLastHandle()).decreaseActivationsCount();
        }
    }
}

