/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.base.mvel.DroolsGlobalVariableMVELFactory;
import org.drools.base.mvel.DroolsLocalVariableMVELFactory;
import org.drools.base.mvel.DroolsMVELGlobalVariable;
import org.drools.base.mvel.LocalVariableResolver;
import org.drools.base.mvel.MVELDebugHandler;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mvel2.integration.impl.LocalVariableResolverFactory;
import org.mvel2.integration.impl.StaticMethodImportResolverFactory;

public class DroolsProcessMVELFactory
extends BaseVariableResolverFactory
implements LocalVariableResolverFactory,
DroolsGlobalVariableMVELFactory,
DroolsLocalVariableMVELFactory,
Externalizable,
Cloneable {
    private static final long serialVersionUID = 510L;
    private Map globals;
    private WorkingMemory workingMemory;
    private Map localVariables;

    public DroolsProcessMVELFactory() {
    }

    public DroolsProcessMVELFactory(Map globals) {
        this(globals, null);
    }

    public DroolsProcessMVELFactory(Map globals, List[] externals) {
        this.globals = globals;
        if (externals != null && MVELDebugHandler.isDebugMode()) {
            for (int i = 0; i < externals.length; ++i) {
                for (String identifier : externals[i]) {
                    this.isResolveable(identifier);
                }
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.globals = (Map)in.readObject();
        this.workingMemory = (WorkingMemory)in.readObject();
        this.localVariables = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.globals);
        out.writeObject(this.workingMemory);
        out.writeObject(this.localVariables);
    }

    public static void addStaticImport(StaticMethodImportResolverFactory factory, String staticImportEntry, ClassLoader classLoader) {
        int index = staticImportEntry.lastIndexOf(46);
        String className = staticImportEntry.substring(0, index);
        String methodName = staticImportEntry.substring(index + 1);
        try {
            Class<?> cls = classLoader.loadClass(className);
            Method[] methods = cls.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(methodName)) continue;
                factory.createVariable(methodName, (Object)methods[i]);
                break;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to dynamically load method '" + staticImportEntry + "'");
        }
    }

    public Map getVariableResolvers() {
        return this.variableResolvers;
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public void setContext(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public Object getValue(String identifier) {
        return this.workingMemory.getGlobal(identifier);
    }

    public Object getLocalValue(String identifier) {
        return this.localVariables.get(identifier);
    }

    public void setLocalValue(String identifier, Object value) {
        if (this.localVariables == null) {
            this.localVariables = new HashMap();
        }
        this.localVariables.put(identifier, value);
    }

    public VariableResolver createVariable(String name, Object value) {
        VariableResolver vr = this.getVariableResolver(name);
        if (vr == null) {
            vr = new LocalVariableResolver(this, name);
            this.addResolver(name, vr);
        }
        vr.setValue(value);
        return vr;
    }

    public VariableResolver createVariable(String name, Object value, Class type) {
        VariableResolver vr = this.getVariableResolver(name);
        if (vr == null) {
            vr = new LocalVariableResolver((DroolsLocalVariableMVELFactory)this, name, type);
            this.addResolver(name, vr);
        }
        vr.setValue(value);
        return vr;
    }

    public boolean isResolveable(String name) {
        if (this.variableResolvers != null && this.variableResolvers.containsKey(name)) {
            return true;
        }
        if (this.workingMemory.getGlobal(name) != null) {
            this.addResolver(name, new DroolsMVELGlobalVariable(name, (Class)this.globals.get(name), this));
            return true;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.isResolveable(name);
        }
        return false;
    }

    private void addResolver(String name, VariableResolver vr) {
        if (this.variableResolvers == null) {
            this.variableResolvers = new HashMap();
        }
        this.variableResolvers.put(name, vr);
    }

    public boolean isTarget(String name) {
        if (this.variableResolvers != null) {
            return this.variableResolvers.containsKey(name);
        }
        return false;
    }

    public Object clone() {
        return new DroolsProcessMVELFactory(this.globals);
    }

    protected Map getGlobals() {
        return this.globals;
    }

    protected Map getLocalVariables() {
        return this.localVariables;
    }
}

