/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;

public class StrEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator STR_COMPARE = Operator.addOperatorToRegistry("str", false);
    public static final Operator NOT_STR_COMPARE = Operator.addOperatorToRegistry("str", true);
    private static final String[] SUPPORTED_IDS = new String[]{STR_COMPARE.getOperatorString()};
    private Evaluator[] evaluator;

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
        StrEvaluator evaluator = new StrEvaluator(type, isNegated);
        evaluator.setParameterText(parameterText);
        return evaluator;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    public boolean isNegatable() {
        return true;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluator = (Evaluator[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluator);
    }

    public static class StrEvaluator
    extends BaseEvaluator {
        private Operations parameter;

        public void setParameterText(String parameterText) {
            this.parameter = Operations.valueOf(parameterText);
        }

        public Operations getParameter() {
            return this.parameter;
        }

        public StrEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? NOT_STR_COMPARE : STR_COMPARE);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object, FieldValue value) {
            Object objectValue = extractor.getValue(workingMemory, object);
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)objectValue).startsWith((String)value.getValue());
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)objectValue).endsWith((String)value.getValue());
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)objectValue).length() == (Long)value.getValue();
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor leftExtractor, Object left, InternalReadAccessor rightExtractor, Object right) {
            Object value1 = leftExtractor.getValue(workingMemory, left);
            Object value2 = rightExtractor.getValue(workingMemory, right);
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)value1).startsWith((String)value2);
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)value1).endsWith((String)value2);
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)value1).length() == (Long)value2;
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)right).startsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)right).endsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)right).length() == (Long)((VariableRestriction.ObjectVariableContextEntry)context).left;
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)left).startsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).right);
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)left).endsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).right);
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)left).length() == (Long)((VariableRestriction.ObjectVariableContextEntry)context).right;
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        public String toString() {
            return "StrEvaluatorDefinition str";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operations {
        startsWith,
        endsWith,
        length;

    }
}

