/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.spi.FactHandleFactory;

public abstract class AbstractFactHandleFactory
implements FactHandleFactory {
    private static final long serialVersionUID = 510L;
    private AtomicInteger id;
    private AtomicLong counter;

    public AbstractFactHandleFactory() {
        this.id = new AtomicInteger(-1);
        this.counter = new AtomicLong(-1L);
    }

    public AbstractFactHandleFactory(int id, long counter) {
        this.id = new AtomicInteger(id);
        this.counter = new AtomicLong(counter);
    }

    public final InternalFactHandle newFactHandle(Object object, ObjectTypeConf conf, InternalWorkingMemory workingMemory, WorkingMemoryEntryPoint wmEntryPoint) {
        return this.newFactHandle(this.id.incrementAndGet(), object, conf, workingMemory, wmEntryPoint);
    }

    protected final InternalFactHandle newFactHandle(int id, Object object, ObjectTypeConf conf, InternalWorkingMemory workingMemory, WorkingMemoryEntryPoint wmEntryPoint) {
        return this.newFactHandle(id, object, this.counter.incrementAndGet(), conf, workingMemory, wmEntryPoint);
    }

    protected abstract InternalFactHandle newFactHandle(int var1, Object var2, long var3, ObjectTypeConf var5, InternalWorkingMemory var6, WorkingMemoryEntryPoint var7);

    public final void increaseFactHandleRecency(InternalFactHandle factHandle) {
        factHandle.setRecency(this.counter.incrementAndGet());
    }

    public void destroyFactHandle(InternalFactHandle factHandle) {
        factHandle.invalidate();
    }

    public abstract FactHandleFactory newInstance();

    public int getId() {
        return this.id.get();
    }

    public long getRecency() {
        return this.counter.get();
    }

    public void clear(int id, long counter) {
        this.id = new AtomicInteger(id);
        this.counter = new AtomicLong(counter);
    }
}

