/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.node;

import org.drools.process.core.timer.Timer;
import org.drools.process.instance.timer.TimerInstance;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.drools.time.TimeUtils;
import org.drools.workflow.core.node.TimerNode;
import org.drools.workflow.instance.node.StateBasedNodeInstance;

public class TimerNodeInstance
extends StateBasedNodeInstance
implements EventListener {
    private static final long serialVersionUID = 400L;
    private long timerId;

    public TimerNode getTimerNode() {
        return (TimerNode)this.getNode();
    }

    public long getTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(long timerId) {
        this.timerId = timerId;
    }

    public void internalTrigger(NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A TimerNode only accepts default incoming connections!");
        }
        TimerInstance timer = this.createTimerInstance();
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
        this.getProcessInstance().getWorkingMemory().getTimerManager().registerTimer(timer, this.getProcessInstance());
        this.timerId = timer.getId();
    }

    protected TimerInstance createTimerInstance() {
        Timer timer = this.getTimerNode().getTimer();
        TimerInstance timerInstance = new TimerInstance();
        timerInstance.setDelay(TimeUtils.parseTimeString(timer.getDelay()));
        if (timer.getPeriod() == null) {
            timerInstance.setPeriod(0L);
        } else {
            timerInstance.setPeriod(TimeUtils.parseTimeString(timer.getPeriod()));
        }
        timerInstance.setTimerId(timer.getId());
        return timerInstance;
    }

    public void signalEvent(String type, Object event) {
        TimerInstance timer;
        if ("timerTriggered".equals(type) && (timer = (TimerInstance)event).getId() == this.timerId) {
            this.triggerCompleted(timer.getPeriod() == 0L);
        }
    }

    public String[] getEventTypes() {
        return new String[]{"timerTriggered"};
    }

    public void triggerCompleted(boolean remove) {
        this.triggerCompleted("DROOLS_DEFAULT", remove);
    }

    public void cancel() {
        this.getProcessInstance().getWorkingMemory().getTimerManager().cancelTimer(this.timerId);
        super.cancel();
    }

    public void addEventListeners() {
        super.addEventListeners();
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("timerTriggered", this, false);
    }
}

