/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.common.EventSupport;
import org.drools.common.InternalWorkingMemory;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.process.instance.ContextInstanceContainer;
import org.drools.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.instance.NodeInstance;
import org.drools.workflow.instance.NodeInstanceContainer;
import org.drools.workflow.instance.impl.ConstraintEvaluator;
import org.drools.workflow.instance.impl.NodeInstanceImpl;

public class SplitInstance
extends NodeInstanceImpl {
    private static final long serialVersionUID = 400L;

    protected Split getSplit() {
        return (Split)this.getNode();
    }

    public void internalTrigger(org.drools.runtime.process.NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A Split only accepts default incoming connections!");
        }
        Split split = this.getSplit();
        switch (split.getType()) {
            case 1: {
                this.triggerCompleted("DROOLS_DEFAULT", true);
                break;
            }
            case 2: {
                ConstraintEvaluator constraint;
                List<Connection> outgoing = split.getDefaultOutgoingConnections();
                int priority = Integer.MAX_VALUE;
                Connection selected = null;
                for (Connection connection : outgoing) {
                    constraint = (ConstraintEvaluator)split.getConstraint(connection);
                    if (constraint == null || constraint.getPriority() >= priority || constraint.isDefault() || !constraint.evaluate(this, connection, constraint)) continue;
                    selected = connection;
                    priority = constraint.getPriority();
                }
                ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                if (selected == null) {
                    for (Connection connection : outgoing) {
                        constraint = (ConstraintEvaluator)split.getConstraint(connection);
                        if (!constraint.isDefault()) continue;
                        selected = connection;
                        break;
                    }
                }
                if (selected == null) {
                    throw new IllegalArgumentException("XOR split could not find at least one valid outgoing connection for split " + this.getSplit().getName());
                }
                this.triggerConnection(selected);
                break;
            }
            case 3: {
                ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                List<Connection> outgoing = split.getDefaultOutgoingConnections();
                boolean found = false;
                ArrayList<Connection> outgoingCopy = new ArrayList<Connection>(outgoing);
                while (!outgoingCopy.isEmpty()) {
                    int priority = Integer.MAX_VALUE;
                    Connection selectedConnection = null;
                    ConstraintEvaluator selectedConstraint = null;
                    for (Connection connection : outgoingCopy) {
                        ConstraintEvaluator constraint = (ConstraintEvaluator)split.getConstraint(connection);
                        if (constraint == null || constraint.getPriority() >= priority || constraint.isDefault()) continue;
                        priority = constraint.getPriority();
                        selectedConnection = connection;
                        selectedConstraint = constraint;
                    }
                    if (selectedConstraint == null) break;
                    if (selectedConstraint.evaluate(this, selectedConnection, selectedConstraint)) {
                        this.triggerConnection(selectedConnection);
                        found = true;
                    }
                    outgoingCopy.remove(selectedConnection);
                }
                if (!found) {
                    for (Connection connection : outgoing) {
                        ConstraintEvaluator constraint = (ConstraintEvaluator)split.getConstraint(connection);
                        if (!constraint.isDefault()) continue;
                        this.triggerConnection(connection);
                        found = true;
                        break;
                    }
                }
                if (found) break;
                throw new IllegalArgumentException("OR split could not find at least one valid outgoing connection for split " + this.getSplit().getName());
            }
            case 4: {
                ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                Node node = this.getNode();
                List connections = null;
                if (node != null) {
                    connections = node.getOutgoingConnections(type);
                }
                if (connections == null || connections.isEmpty()) {
                    ((NodeInstanceContainer)this.getNodeInstanceContainer()).nodeInstanceCompleted(this, type);
                    break;
                }
                ExclusiveGroupInstance groupInstance = new ExclusiveGroupInstance();
                org.drools.runtime.process.NodeInstanceContainer parent = this.getNodeInstanceContainer();
                if (!(parent instanceof ContextInstanceContainer)) {
                    throw new IllegalArgumentException("An Exclusive AND is only possible if the parent is a context instance container");
                }
                ((ContextInstanceContainer)parent).addContextInstance("ExclusiveGroup", groupInstance);
                HashMap<NodeInstance, String> nodeInstances = new HashMap<NodeInstance, String>();
                for (Connection connection : connections) {
                    nodeInstances.put(((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstance(connection.getTo()), connection.getToType());
                }
                for (org.drools.runtime.process.NodeInstance nodeInstance : nodeInstances.keySet()) {
                    groupInstance.addNodeInstance(nodeInstance);
                }
                for (Map.Entry entry : nodeInstances.entrySet()) {
                    if (this.getProcessInstance().getState() != 1) {
                        return;
                    }
                    boolean hidden = false;
                    if (this.getNode().getMetaData("hidden") != null) {
                        hidden = true;
                    }
                    WorkingMemory workingMemory = this.getProcessInstance().getWorkingMemory();
                    if (!hidden) {
                        ((EventSupport)((Object)workingMemory)).getRuleFlowEventSupport().fireBeforeRuleFlowNodeLeft(this, (InternalWorkingMemory)workingMemory);
                    }
                    ((NodeInstance)entry.getKey()).trigger(this, (String)entry.getValue());
                    if (hidden) continue;
                    ((EventSupport)((Object)workingMemory)).getRuleFlowEventSupport().fireAfterRuleFlowNodeLeft(this, (InternalWorkingMemory)workingMemory);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal split type " + split.getType());
            }
        }
    }
}

