/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.RuntimeDroolsException;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.MutableTypeConstraint;
import org.drools.spi.CompiledInvoker;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.PredicateExpression;
import org.drools.spi.Restriction;
import org.drools.spi.Wireable;

public class PredicateConstraint
extends MutableTypeConstraint
implements Restriction,
Wireable,
Externalizable {
    private static final long serialVersionUID = 400L;
    private PredicateExpression expression;
    private Declaration[] requiredDeclarations;
    private Declaration[] previousDeclarations;
    private Declaration[] localDeclarations;
    private String[] requiredGlobals;
    private List<PredicateConstraint> cloned = Collections.emptyList();
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];
    private static final String[] EMPTY_GLOBALS = new String[0];

    public PredicateConstraint() {
        this(null);
    }

    public PredicateConstraint(PredicateExpression evaluator) {
        this(evaluator, null, null, null);
    }

    public PredicateConstraint(Declaration[] previousDeclarations, Declaration[] localDeclarations) {
        this(null, previousDeclarations, localDeclarations, null);
    }

    public PredicateConstraint(PredicateExpression expression, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] requiredGlobals) {
        this.expression = expression;
        this.previousDeclarations = previousDeclarations == null ? EMPTY_DECLARATIONS : previousDeclarations;
        this.localDeclarations = localDeclarations == null ? EMPTY_DECLARATIONS : localDeclarations;
        this.requiredGlobals = requiredGlobals == null ? EMPTY_GLOBALS : requiredGlobals;
        this.requiredDeclarations = new Declaration[this.previousDeclarations.length + this.localDeclarations.length];
        System.arraycopy(this.previousDeclarations, 0, this.requiredDeclarations, 0, this.previousDeclarations.length);
        System.arraycopy(this.localDeclarations, 0, this.requiredDeclarations, this.previousDeclarations.length, this.localDeclarations.length);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.expression = (PredicateExpression)in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.previousDeclarations = (Declaration[])in.readObject();
        this.localDeclarations = (Declaration[])in.readObject();
        this.requiredGlobals = (String[])in.readObject();
        this.cloned = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.expression instanceof CompiledInvoker) {
            out.writeObject(null);
        } else {
            out.writeObject(this.expression);
        }
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.previousDeclarations);
        out.writeObject(this.localDeclarations);
        out.writeObject(this.requiredGlobals);
        out.writeObject(this.cloned);
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public Declaration[] getPreviousDeclarations() {
        return this.previousDeclarations;
    }

    public Declaration[] getLocalDeclarations() {
        return this.localDeclarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        int i = 0;
        while (i < this.requiredDeclarations.length) {
            if (this.requiredDeclarations[i].equals(oldDecl)) {
                this.requiredDeclarations[i] = newDecl;
            }
            ++i;
        }
        i = 0;
        while (i < this.previousDeclarations.length) {
            if (this.previousDeclarations[i].equals(oldDecl)) {
                this.previousDeclarations[i] = newDecl;
            }
            ++i;
        }
        i = 0;
        while (i < this.localDeclarations.length) {
            if (this.localDeclarations[i].equals(oldDecl)) {
                this.localDeclarations[i] = newDecl;
            }
            ++i;
        }
    }

    public void wire(Object object) {
        this.setPredicateExpression((PredicateExpression)object);
        for (PredicateConstraint clone : this.cloned) {
            clone.wire(object);
        }
    }

    public void setPredicateExpression(PredicateExpression expression) {
        this.expression = expression;
    }

    public PredicateExpression getPredicateExpression() {
        return this.expression;
    }

    public boolean isTemporal() {
        return false;
    }

    public String toString() {
        return "[PredicateConstraint previousDeclarations=" + this.previousDeclarations + " localDeclarations=" + this.localDeclarations + "]";
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != PredicateConstraint.class) {
            return false;
        }
        PredicateConstraint other = (PredicateConstraint)object;
        if (this.previousDeclarations.length != other.previousDeclarations.length) {
            return false;
        }
        if (this.localDeclarations.length != other.localDeclarations.length) {
            return false;
        }
        if (this.requiredGlobals.length != other.requiredGlobals.length) {
            return false;
        }
        int i = 0;
        int length = this.previousDeclarations.length;
        while (i < length) {
            if (this.previousDeclarations[i].getPattern().getOffset() != other.previousDeclarations[i].getPattern().getOffset()) {
                return false;
            }
            if (!this.previousDeclarations[i].getExtractor().equals(other.previousDeclarations[i].getExtractor())) {
                return false;
            }
            ++i;
        }
        i = 0;
        length = this.localDeclarations.length;
        while (i < length) {
            if (this.localDeclarations[i].getPattern().getOffset() != other.localDeclarations[i].getPattern().getOffset()) {
                return false;
            }
            if (!this.localDeclarations[i].getExtractor().equals(other.localDeclarations[i].getExtractor())) {
                return false;
            }
            ++i;
        }
        if (!Arrays.equals(this.requiredGlobals, other.requiredGlobals)) {
            return false;
        }
        return this.expression.equals(other.expression);
    }

    public ContextEntry createContextEntry() {
        PredicateContextEntry ctx = new PredicateContextEntry();
        ctx.dialectContext = this.expression.createContext();
        return ctx;
    }

    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry ctx) {
        try {
            return this.expression.evaluate(handle.getObject(), null, this.previousDeclarations, this.localDeclarations, workingMemory, ((PredicateContextEntry)ctx).dialectContext);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Exception executing predicate " + this.expression, e);
        }
    }

    public boolean isAllowed(InternalReadAccessor extractor, InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        throw new UnsupportedOperationException("Method not supported. Please contact development team.");
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        try {
            PredicateContextEntry ctx = (PredicateContextEntry)context;
            return this.expression.evaluate(handle.getObject(), ctx.leftTuple, this.previousDeclarations, this.localDeclarations, ctx.workingMemory, ctx.dialectContext);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Exception executing predicate " + this.expression, e);
        }
    }

    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        try {
            PredicateContextEntry ctx = (PredicateContextEntry)context;
            return this.expression.evaluate(ctx.rightObject, tuple, this.previousDeclarations, this.localDeclarations, ctx.workingMemory, ctx.dialectContext);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Exception executing predicate " + this.expression, e);
        }
    }

    public Object clone() {
        Declaration[] previous = new Declaration[this.previousDeclarations.length];
        int i = 0;
        while (i < previous.length) {
            previous[i] = (Declaration)this.previousDeclarations[i].clone();
            ++i;
        }
        Declaration[] local = new Declaration[this.localDeclarations.length];
        int i2 = 0;
        while (i2 < local.length) {
            local[i2] = (Declaration)this.localDeclarations[i2].clone();
            ++i2;
        }
        PredicateConstraint clone = new PredicateConstraint(this.expression, previous, local, this.requiredGlobals);
        if (this.cloned == Collections.EMPTY_LIST) {
            this.cloned = new ArrayList<PredicateConstraint>(1);
        }
        this.cloned.add(clone);
        return clone;
    }

    public static class PredicateContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 400L;
        public LeftTuple leftTuple;
        public Object rightObject;
        public InternalWorkingMemory workingMemory;
        public Object dialectContext;
        private ContextEntry entry;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.leftTuple = (LeftTuple)in.readObject();
            this.rightObject = in.readObject();
            this.workingMemory = (InternalWorkingMemory)in.readObject();
            this.dialectContext = in.readObject();
            this.entry = (ContextEntry)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.leftTuple);
            out.writeObject(this.rightObject);
            out.writeObject(this.workingMemory);
            out.writeObject(this.dialectContext);
            out.writeObject(this.entry);
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.rightObject = handle.getObject();
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.workingMemory = workingMemory;
            this.leftTuple = tuple;
        }

        public void resetTuple() {
            this.leftTuple = null;
        }

        public void resetFactHandle() {
            this.rightObject = null;
        }
    }
}

