/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.Collection;
import org.drools.RuntimeDroolsException;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.Pattern;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.InternalReadAccessor;

public class Declaration
implements Externalizable,
AcceptsReadAccessor,
Cloneable {
    private static final long serialVersionUID = 400L;
    private String identifier;
    private InternalReadAccessor readAccessor;
    private Pattern pattern;
    private boolean internalFact;

    public Declaration() {
        this(null, null, null);
    }

    public Declaration(String identifier, Pattern pattern) {
        this(identifier, null, pattern, false);
    }

    public Declaration(String identifier, InternalReadAccessor extractor, Pattern pattern) {
        this(identifier, extractor, pattern, false);
    }

    public Declaration(String identifier, InternalReadAccessor extractor, Pattern pattern, boolean internalFact) {
        this.identifier = identifier;
        this.readAccessor = extractor;
        this.pattern = pattern;
        this.internalFact = internalFact;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.identifier = (String)in.readObject();
        this.readAccessor = (InternalReadAccessor)in.readObject();
        this.pattern = (Pattern)in.readObject();
        this.internalFact = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.identifier);
        out.writeObject(this.readAccessor);
        out.writeObject(this.pattern);
        out.writeBoolean(this.internalFact);
    }

    public void setReadAccessor(InternalReadAccessor readAccessor) {
        this.readAccessor = readAccessor;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ValueType getValueType() {
        return this.readAccessor.getValueType();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean isPatternDeclaration() {
        return this.pattern != null && this.pattern.getDeclaration() == this;
    }

    public InternalReadAccessor getExtractor() {
        return this.readAccessor;
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getValue(workingMemory, object);
    }

    public Object getNonShadowedValue(InternalWorkingMemory workingMemory, Object object) {
        Object result = this.readAccessor.getValue(workingMemory, object);
        if (this.isInternalFact() && result instanceof Collection) {
            try {
                Collection newCol = (Collection)result.getClass().newInstance();
                for (Object element : (Collection)result) {
                    newCol.add(element);
                }
                return newCol;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return result;
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getCharValue(workingMemory, object);
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getIntValue(workingMemory, object);
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getByteValue(workingMemory, object);
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getShortValue(workingMemory, object);
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getLongValue(workingMemory, object);
    }

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getFloatValue(workingMemory, object);
    }

    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getDoubleValue(workingMemory, object);
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getBooleanValue(workingMemory, object);
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        return this.readAccessor.getHashCode(workingMemory, object);
    }

    public boolean isGlobal() {
        if (this.readAccessor == null) {
            return false;
        }
        return this.readAccessor.isGlobal();
    }

    public Method getNativeReadMethod() {
        if (this.isPatternDeclaration() && this.isInternalFact()) {
            try {
                return this.getClass().getDeclaredMethod("getNonShadowedValue", InternalWorkingMemory.class, Object.class);
            }
            catch (Exception e) {
                throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
            }
        }
        return this.readAccessor.getNativeReadMethod();
    }

    public String toString() {
        return "[Declaration: type=" + this.readAccessor.getValueType() + " identifier=" + this.identifier + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * this.pattern.getOffset();
        result = 31 * this.readAccessor.hashCode();
        result = 31 * this.identifier.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Declaration other = (Declaration)object;
        return this.pattern.getOffset() == other.pattern.getOffset() && this.identifier.equals(other.identifier) && this.readAccessor.equals(other.readAccessor);
    }

    protected boolean isInternalFact() {
        return this.internalFact;
    }

    public Object clone() {
        return new Declaration(this.identifier, this.readAccessor, this.pattern);
    }
}

