/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.drools.RuntimeDroolsException;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.ArrayUtils;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.MutableTypeConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Constraint;

public abstract class AbstractCompositeConstraint
extends MutableTypeConstraint {
    protected AlphaNodeFieldConstraint[] alphaConstraints = new AlphaNodeFieldConstraint[0];
    protected BetaNodeFieldConstraint[] betaConstraints = new BetaNodeFieldConstraint[0];
    protected Declaration[] requiredDeclarations = new Declaration[0];

    public AbstractCompositeConstraint() {
        this.setType(Constraint.ConstraintType.ALPHA);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.alphaConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.betaConstraints = (BetaNodeFieldConstraint[])in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.alphaConstraints);
        out.writeObject(this.betaConstraints);
        out.writeObject(this.requiredDeclarations);
    }

    public AlphaNodeFieldConstraint[] getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public BetaNodeFieldConstraint[] getBetaConstraints() {
        return this.betaConstraints;
    }

    public boolean isTemporal() {
        Constraint c;
        Constraint[] constraintArray = this.alphaConstraints;
        int n = this.alphaConstraints.length;
        int n2 = 0;
        while (n2 < n) {
            c = constraintArray[n2];
            if (c.isTemporal()) {
                return true;
            }
            ++n2;
        }
        constraintArray = this.betaConstraints;
        n = this.betaConstraints.length;
        n2 = 0;
        while (n2 < n) {
            c = constraintArray[n2];
            if (c.isTemporal()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addAlphaConstraint(AlphaNodeFieldConstraint constraint) {
        if (constraint != null) {
            AlphaNodeFieldConstraint[] tmp = this.alphaConstraints;
            this.alphaConstraints = new AlphaNodeFieldConstraint[tmp.length + 1];
            System.arraycopy(tmp, 0, this.alphaConstraints, 0, tmp.length);
            this.alphaConstraints[this.alphaConstraints.length - 1] = constraint;
            this.updateRequiredDeclarations(constraint);
        }
    }

    public void addBetaConstraint(BetaNodeFieldConstraint constraint) {
        if (constraint != null) {
            BetaNodeFieldConstraint[] tmp = this.betaConstraints;
            this.betaConstraints = new BetaNodeFieldConstraint[tmp.length + 1];
            System.arraycopy(tmp, 0, this.betaConstraints, 0, tmp.length);
            this.betaConstraints[this.betaConstraints.length - 1] = constraint;
            this.updateRequiredDeclarations(constraint);
            this.setType(Constraint.ConstraintType.BETA);
        }
    }

    public void addConstraint(Constraint constraint) {
        if (Constraint.ConstraintType.ALPHA.equals((Object)constraint.getType())) {
            this.addAlphaConstraint((AlphaNodeFieldConstraint)constraint);
        } else if (Constraint.ConstraintType.BETA.equals((Object)constraint.getType())) {
            this.addBetaConstraint((BetaNodeFieldConstraint)constraint);
        } else {
            throw new RuntimeDroolsException("Constraint type MUST be known in advance.");
        }
    }

    protected void updateRequiredDeclarations(Constraint constraint) {
        Declaration[] decs = constraint.getRequiredDeclarations();
        if (decs != null && decs.length > 0) {
            int i = 0;
            while (i < decs.length) {
                Declaration dec = decs[i];
                int j = 0;
                while (j < this.requiredDeclarations.length) {
                    if (dec.equals(this.requiredDeclarations[j])) {
                        dec = null;
                        break;
                    }
                    ++j;
                }
                if (dec != null) {
                    Declaration[] tmp = this.requiredDeclarations;
                    this.requiredDeclarations = new Declaration[tmp.length + 1];
                    System.arraycopy(tmp, 0, this.requiredDeclarations, 0, tmp.length);
                    this.requiredDeclarations[this.requiredDeclarations.length - 1] = dec;
                }
                ++i;
            }
        }
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        int i = 0;
        while (i < this.alphaConstraints.length) {
            this.alphaConstraints[i].replaceDeclaration(oldDecl, newDecl);
            ++i;
        }
        i = 0;
        while (i < this.betaConstraints.length) {
            this.betaConstraints[i].replaceDeclaration(oldDecl, newDecl);
            ++i;
        }
        i = 0;
        while (i < this.requiredDeclarations.length) {
            if (this.requiredDeclarations[i] == oldDecl) {
                this.requiredDeclarations[i] = newDecl;
            }
            ++i;
        }
    }

    public ContextEntry createContextEntry() {
        return new MultiFieldConstraintContextEntry(this.alphaConstraints, this.betaConstraints);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + ArrayUtils.hashCode(this.alphaConstraints);
        result = 31 * result + ArrayUtils.hashCode(this.betaConstraints);
        result = 31 * result + ArrayUtils.hashCode(this.requiredDeclarations);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != AbstractCompositeConstraint.class) {
            return false;
        }
        AbstractCompositeConstraint other = (AbstractCompositeConstraint)object;
        return Arrays.equals(this.alphaConstraints, other.alphaConstraints) && Arrays.equals(this.betaConstraints, other.betaConstraints) && Arrays.equals(this.requiredDeclarations, other.requiredDeclarations);
    }

    public abstract Object clone();

    protected static class MultiFieldConstraintContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 400L;
        public ContextEntry[] alphas;
        public ContextEntry[] betas;
        public ContextEntry next;
        public InternalWorkingMemory workingMemory;
        public InternalFactHandle handle;

        public MultiFieldConstraintContextEntry() {
        }

        public MultiFieldConstraintContextEntry(AlphaNodeFieldConstraint[] alphas, BetaNodeFieldConstraint[] betas) {
            this.alphas = new ContextEntry[alphas.length];
            int i = 0;
            while (i < alphas.length) {
                this.alphas[i] = alphas[i].createContextEntry();
                ++i;
            }
            this.betas = new ContextEntry[betas.length];
            i = 0;
            while (i < betas.length) {
                this.betas[i] = betas[i].createContextEntry();
                ++i;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.alphas = (ContextEntry[])in.readObject();
            this.betas = (ContextEntry[])in.readObject();
            this.next = (ContextEntry)in.readObject();
            this.workingMemory = (InternalWorkingMemory)in.readObject();
            this.handle = (InternalFactHandle)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.alphas);
            out.writeObject(this.betas);
            out.writeObject(this.next);
            out.writeObject(this.workingMemory);
            out.writeObject(this.handle);
        }

        public ContextEntry getNext() {
            return this.next;
        }

        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.handle = handle;
            int i = 0;
            while (i < this.alphas.length) {
                if (this.alphas[i] != null) {
                    this.alphas[i].updateFromFactHandle(workingMemory, handle);
                }
                ++i;
            }
            i = 0;
            while (i < this.betas.length) {
                this.betas[i].updateFromFactHandle(workingMemory, handle);
                ++i;
            }
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.workingMemory = workingMemory;
            int i = 0;
            while (i < this.alphas.length) {
                if (this.alphas[i] != null) {
                    this.alphas[i].updateFromTuple(workingMemory, tuple);
                }
                ++i;
            }
            i = 0;
            while (i < this.betas.length) {
                this.betas[i].updateFromTuple(workingMemory, tuple);
                ++i;
            }
        }

        public void resetTuple() {
            this.workingMemory = null;
            int i = 0;
            int length = this.alphas.length;
            while (i < length) {
                if (this.alphas[i] != null) {
                    this.alphas[i].resetTuple();
                }
                ++i;
            }
            i = 0;
            length = this.betas.length;
            while (i < length) {
                this.betas[i].resetTuple();
                ++i;
            }
        }

        public void resetFactHandle() {
            this.workingMemory = null;
            this.handle = null;
            int i = 0;
            int length = this.alphas.length;
            while (i < length) {
                if (this.alphas[i] != null) {
                    this.alphas[i].resetFactHandle();
                }
                ++i;
            }
            i = 0;
            length = this.betas.length;
            while (i < length) {
                this.betas[i].resetFactHandle();
                ++i;
            }
        }
    }
}

