/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.common.InstanceNotEqualsConstraint;
import org.drools.common.InternalWorkingMemory;
import org.drools.conf.EventProcessingOption;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.PropagationQueuingNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.Behavior;
import org.drools.rule.Declaration;
import org.drools.rule.EntryPoint;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.TypeDeclaration;
import org.drools.rule.VariableConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.Constraint;
import org.drools.spi.ObjectType;
import org.drools.time.impl.CompositeMaxDurationTimer;
import org.drools.time.impl.DurationTimer;
import org.drools.time.impl.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBuilder
implements ReteooComponentBuilder {
    @Override
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        Pattern pattern = (Pattern)rce;
        this.attachPattern(context, utils, pattern);
    }

    private void attachPattern(BuildContext context, BuildUtils utils, Pattern pattern) throws InvalidPatternException {
        pattern.setOffset(context.getCurrentPatternOffset());
        LinkedList<Constraint> alphaConstraints = new LinkedList<Constraint>();
        LinkedList<Constraint> betaConstraints = new LinkedList<Constraint>();
        LinkedList<Behavior> behaviors = new LinkedList<Behavior>();
        this.createConstraints(context, utils, pattern, alphaConstraints, betaConstraints);
        context.setBetaconstraints(betaConstraints);
        behaviors.addAll(pattern.getBehaviors());
        context.setBehaviors(behaviors);
        if (pattern.getSource() != null) {
            context.setAlphaConstraints(alphaConstraints);
            int currentOffset = context.getCurrentPatternOffset();
            PatternSource source = pattern.getSource();
            ReteooComponentBuilder builder = utils.getBuilderFor(source);
            builder.build(context, utils, source);
            context.setCurrentPatternOffset(currentOffset);
        }
        if (pattern.getSource() == null || context.getCurrentEntryPoint() != EntryPoint.DEFAULT) {
            this.attachAlphaNodes(context, utils, pattern, alphaConstraints);
            if (context.getCurrentEntryPoint() != EntryPoint.DEFAULT) {
                context.setObjectSource((ObjectSource)utils.attachNode(context, new PropagationQueuingNode(context.getNextId(), context.getObjectSource(), context)));
                context.setCurrentEntryPoint(EntryPoint.DEFAULT);
            }
        }
        context.incrementCurrentPatternOffset();
    }

    private void createConstraints(BuildContext context, BuildUtils utils, Pattern pattern, List<Constraint> alphaConstraints, List<Constraint> betaConstraints) {
        List constraints = pattern.getConstraints();
        this.checkRemoveIdentities(context, pattern, betaConstraints);
        boolean isNegative = this.isNegative(context);
        for (Object object : constraints) {
            if (object instanceof Declaration) continue;
            Constraint constraint = (Constraint)object;
            if (constraint.getType().equals((Object)Constraint.ConstraintType.ALPHA)) {
                alphaConstraints.add(constraint);
                continue;
            }
            if (constraint.getType().equals((Object)Constraint.ConstraintType.BETA)) {
                betaConstraints.add(constraint);
                if (!isNegative || context.getRuleBase().getConfiguration().getEventProcessingMode() != EventProcessingOption.STREAM || !pattern.getObjectType().isEvent() || !constraint.isTemporal()) continue;
                this.checkDelaying(context, constraint);
                continue;
            }
            throw new RuntimeDroolsException("Unknown constraint type: " + (Object)((Object)constraint.getType()) + ". This is a bug. Please contact development team.");
        }
    }

    private void checkDelaying(BuildContext context, Constraint constraint) {
        Declaration target;
        if (constraint instanceof VariableConstraint && (target = constraint.getRequiredDeclarations()[0]).isPatternDeclaration() && target.getPattern().getObjectType().isEvent()) {
            long uplimit = ((VariableConstraint)constraint).getInterval().getUpperBound();
            Timer timer = context.getRule().getTimer();
            DurationTimer durationTimer = new DurationTimer(uplimit);
            if (timer instanceof CompositeMaxDurationTimer) {
                ((CompositeMaxDurationTimer)timer).addDurationTimer(durationTimer);
            } else {
                if (timer == null) {
                    timer = durationTimer;
                } else {
                    CompositeMaxDurationTimer temp = new CompositeMaxDurationTimer();
                    if (timer instanceof DurationTimer) {
                        temp.addDurationTimer((DurationTimer)timer);
                    } else {
                        temp.setTimer(context.getRule().getTimer());
                    }
                    temp.addDurationTimer(durationTimer);
                    timer = temp;
                }
                context.getRule().setTimer(timer);
            }
        }
    }

    private boolean isNegative(BuildContext context) {
        ListIterator<RuleConditionElement> it = context.stackIterator();
        while (it.hasPrevious()) {
            RuleConditionElement rce = it.previous();
            if (!(rce instanceof GroupElement) || !((GroupElement)rce).isNot()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTypeNode attachObjectTypeNode(BuildContext context, ObjectType objectType) {
        Map map = context.getRuleBase().getPackagesMap();
        synchronized (map) {
            InternalWorkingMemory[] wms = context.getWorkingMemories();
            EntryPointNode epn = context.getRuleBase().getRete().getEntryPointNode(context.getCurrentEntryPoint());
            if (epn == null) {
                epn = new EntryPointNode(context.getNextId(), context.getRuleBase().getRete(), context);
                if (wms.length > 0) {
                    epn.attach(wms);
                } else {
                    epn.attach();
                }
            }
            ObjectTypeNode otn = new ObjectTypeNode(context.getNextId(), epn, objectType, context);
            if (wms.length > 0) {
                otn.attach(wms);
            } else {
                otn.attach();
            }
            return otn;
        }
    }

    public void attachAlphaNodes(BuildContext context, BuildUtils utils, Pattern pattern, List<Constraint> alphaConstraints) throws InvalidPatternException {
        boolean objectMemory = context.isObjectTypeNodeMemoryEnabled();
        boolean alphaMemory = context.isAlphaMemoryAllowed();
        ObjectType objectType = pattern.getObjectType();
        if (pattern.getObjectType() instanceof ClassObjectType && DroolsQuery.class == ((ClassObjectType)pattern.getObjectType()).getClassType()) {
            context.setTupleMemoryEnabled(false);
            context.setObjectTypeNodeMemoryEnabled(false);
            context.setTerminalNodeMemoryEnabled(false);
            context.setAlphaNodeMemoryAllowed(false);
        }
        context.setObjectSource((ObjectSource)utils.attachNode(context, new EntryPointNode(context.getNextId(), context.getRuleBase().getRete(), context)));
        ObjectTypeNode otn = new ObjectTypeNode(context.getNextId(), (EntryPointNode)context.getObjectSource(), objectType, context);
        if (objectType.isEvent() && EventProcessingOption.STREAM.equals((Object)context.getRuleBase().getConfiguration().getEventProcessingMode())) {
            long expirationOffset = 0L;
            for (TypeDeclaration type : context.getRuleBase().getTypeDeclarations()) {
                if (!type.getObjectType().isAssignableFrom(objectType)) continue;
                expirationOffset = Math.max(type.getExpirationOffset(), expirationOffset);
            }
            for (Behavior behavior : pattern.getBehaviors()) {
                if (behavior.getExpirationOffset() == -1L) continue;
                expirationOffset = Math.max(behavior.getExpirationOffset(), expirationOffset);
            }
            if (expirationOffset == 0L) {
                otn.setExpirationOffset(context.getTemporalDistance().getExpirationOffset(pattern));
            } else {
                otn.setExpirationOffset(expirationOffset);
            }
        }
        context.setObjectSource((ObjectSource)utils.attachNode(context, otn));
        for (AlphaNodeFieldConstraint alphaNodeFieldConstraint : alphaConstraints) {
            context.setObjectSource((ObjectSource)utils.attachNode(context, new AlphaNode(context.getNextId(), alphaNodeFieldConstraint, context.getObjectSource(), context)));
        }
        context.setObjectTypeNodeMemoryEnabled(objectMemory);
        context.setAlphaNodeMemoryAllowed(alphaMemory);
    }

    private void checkRemoveIdentities(BuildContext context, Pattern pattern, List<Constraint> betaConstraints) {
        if (context.getRuleBase().getConfiguration().isRemoveIdentities() && pattern.getObjectType().getClass() == ClassObjectType.class) {
            Class<?> thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
            for (Pattern previousPattern : context.getObjectType()) {
                Class<?> previousClass = ((ClassObjectType)previousPattern.getObjectType()).getClassType();
                if (!thisClass.isAssignableFrom(previousClass)) continue;
                betaConstraints.add(new InstanceNotEqualsConstraint(previousPattern));
            }
            context.getObjectType().add(pattern);
        }
    }

    @Override
    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        return ((Pattern)rce).getSource() != null;
    }
}

