/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashMap;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;

public class RightInputAdapterNode
extends ObjectSource
implements LeftTupleSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private LeftTupleSource tupleSource;
    protected boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public RightInputAdapterNode() {
    }

    public RightInputAdapterNode(int id, LeftTupleSource source, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.tupleSource = source;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new ObjectHashMap();
    }

    public void assertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(tuple, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), tuple), workingMemory);
        if (this.tupleMemoryEnabled) {
            ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
            memory.put(tuple, handle);
        }
        this.sink.propagateAssertObject(handle, context, workingMemory);
    }

    public void retractLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
        InternalFactHandle factHandle = (InternalFactHandle)memory.remove(tuple);
        RightTuple rightTuple = factHandle.getFirstRightTuple();
        while (rightTuple != null) {
            rightTuple.getRightTupleSink().retractRightTuple(rightTuple, context, workingMemory);
            rightTuple = rightTuple.getHandleNext();
        }
        factHandle.setFirstRightTuple(null);
        LeftTuple leftTuple = factHandle.getLastLeftTuple();
        while (leftTuple != null) {
            leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, context, workingMemory);
            leftTuple = leftTuple.getLeftParentNext();
        }
        factHandle.setFirstLeftTuple(null);
        workingMemory.getFactHandleFactory().destroyFactHandle(factHandle);
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
        InternalFactHandle handle = (InternalFactHandle)memory.get(leftTuple);
        RightTuple rightTuple = handle.getFirstRightTuple();
        while (rightTuple != null) {
            rightTuple.getRightTupleSink().modifyRightTuple(rightTuple, context, workingMemory);
            rightTuple = rightTuple.getHandleNext();
        }
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int i = 0;
        int length = workingMemories.length;
        while (i < length) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
            ++i;
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
        Iterator it = memory.iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            sink.assertObject((InternalFactHandle)entry.getValue(), context, workingMemory);
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
        if (!this.isInUse()) {
            InternalWorkingMemory[] internalWorkingMemoryArray = workingMemories;
            int n = workingMemories.length;
            int n2 = 0;
            while (n2 < n) {
                InternalWorkingMemory workingMemory = internalWorkingMemoryArray[n2];
                ObjectHashMap memory = (ObjectHashMap)workingMemory.getNodeMemory(this);
                Iterator it = memory.iterator();
                ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
                while (entry != null) {
                    LeftTuple leftTuple = (LeftTuple)entry.getKey();
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    InternalFactHandle handle = (InternalFactHandle)entry.getValue();
                    workingMemory.getFactHandleFactory().destroyFactHandle(handle);
                    entry = (ObjectHashMap.ObjectEntry)it.next();
                }
                workingMemory.clearNodeMemory(this);
                ++n2;
            }
        }
        this.tupleSource.remove(context, builder, this, workingMemories);
    }

    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public short getType() {
        return 7;
    }

    public int hashCode() {
        return this.tupleSource.hashCode() * 17 + (this.tupleMemoryEnabled ? 1234 : 4321);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof RightInputAdapterNode)) {
            return false;
        }
        RightInputAdapterNode other = (RightInputAdapterNode)object;
        return this.tupleMemoryEnabled == other.tupleMemoryEnabled && this.tupleSource.equals(other.tupleSource);
    }
}

