/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.RuleBaseConfiguration;
import org.drools.base.ClassObjectType;
import org.drools.base.ValueType;
import org.drools.common.AbstractRuleBase;
import org.drools.common.BaseNode;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashSet;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.FromNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.Sink;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.compiled.CompiledNetwork;
import org.drools.rule.Declaration;
import org.drools.rule.EntryPoint;
import org.drools.rule.EvalCondition;
import org.drools.spi.Constraint;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.impl.PointInTimeTrigger;

public class ObjectTypeNode
extends ObjectSource
implements ObjectSink,
Externalizable,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private ObjectType objectType;
    private boolean skipOnModify = false;
    private boolean objectMemoryEnabled;
    private long expirationOffset = -1L;
    private transient ExpireJob job = new ExpireJob();
    private CompiledNetwork compiledNetwork;

    public ObjectTypeNode() {
    }

    public ObjectTypeNode(int id, EntryPointNode source, ObjectType objectType, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), source, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.objectType = objectType;
        this.setObjectMemoryEnabled(context.isObjectTypeNodeMemoryEnabled());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.objectType = (ObjectType)in.readObject();
        if (this.objectType instanceof ClassObjectType) {
            this.objectType = ((AbstractRuleBase)((DroolsObjectInputStream)in).getRuleBase()).getClassFieldAccessorCache().getClassObjectType((ClassObjectType)this.objectType);
        }
        this.skipOnModify = in.readBoolean();
        this.objectMemoryEnabled = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.objectType);
        out.writeBoolean(this.skipOnModify);
        out.writeBoolean(this.objectMemoryEnabled);
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public boolean isAssignableFrom(ObjectType objectType) {
        return this.objectType.isAssignableFrom(objectType);
    }

    public void setCompiledNetwork(CompiledNetwork compiledNetwork) {
        this.compiledNetwork = compiledNetwork;
        this.compiledNetwork.setObjectTypeNode(this);
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.objectMemoryEnabled) {
            ObjectHashSet memory = (ObjectHashSet)workingMemory.getNodeMemory(this);
            memory.add(factHandle, false);
        }
        if (this.compiledNetwork != null) {
            this.compiledNetwork.assertObject(factHandle, context, workingMemory);
        } else {
            this.sink.propagateAssertObject(factHandle, context, workingMemory);
        }
        if (this.expirationOffset >= 0L) {
            ReteooWorkingMemory.WorkingMemoryReteExpireAction expire = new ReteooWorkingMemory.WorkingMemoryReteExpireAction(factHandle, this);
            TimerService clock = workingMemory.getTimerService();
            long nextTimestamp = Math.max(clock.getCurrentTime() + this.expirationOffset, ((EventFactHandle)factHandle).getStartTimestamp() + this.expirationOffset);
            ExpireJobContext jobctx = new ExpireJobContext(expire, workingMemory);
            JobHandle handle = clock.scheduleJob(this.job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
            jobctx.setJobHandle(handle);
        }
    }

    public void retractObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.objectMemoryEnabled) {
            ObjectHashSet memory = (ObjectHashSet)workingMemory.getNodeMemory(this);
            memory.remove(factHandle);
        }
        RightTuple rightTuple = factHandle.getFirstRightTuple();
        while (rightTuple != null) {
            rightTuple.getRightTupleSink().retractRightTuple(rightTuple, context, workingMemory);
            rightTuple = rightTuple.getHandleNext();
        }
        factHandle.setFirstRightTuple(null);
        factHandle.setLastRightTuple(null);
        LeftTuple leftTuple = factHandle.getFirstLeftTuple();
        while (leftTuple != null) {
            leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, context, workingMemory);
            leftTuple = leftTuple.getLeftParentNext();
        }
        factHandle.setFirstLeftTuple(null);
        factHandle.setLastLeftTuple(null);
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.skipOnModify && context.getDormantActivations() == 0) {
            return;
        }
        if (this.compiledNetwork != null) {
            this.compiledNetwork.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
        } else {
            this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
        }
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectHashSet memory = (ObjectHashSet)workingMemory.getNodeMemory(this);
        Iterator it = memory.iterator();
        ObjectHashSet.ObjectEntry entry = (ObjectHashSet.ObjectEntry)it.next();
        while (entry != null) {
            sink.assertObject((InternalFactHandle)entry.getValue(), context, workingMemory);
            entry = (ObjectHashSet.ObjectEntry)it.next();
        }
    }

    public void attach() {
        this.source.addObjectSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int i = 0;
        int length = workingMemories.length;
        while (i < length) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            propagationContext.setEntryPoint(((EntryPointNode)this.source).getEntryPoint());
            this.source.updateSink(this, propagationContext, workingMemory);
            ++i;
        }
    }

    public void networkUpdated() {
        this.skipOnModify = this.canSkipOnModify(this.sink.getSinks(), true);
    }

    public void remove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        this.doRemove(context, builder, node, workingMemories);
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (context.getCleanupAdapter() != null) {
            InternalWorkingMemory[] internalWorkingMemoryArray = workingMemories;
            int n = workingMemories.length;
            int n2 = 0;
            while (n2 < n) {
                InternalWorkingMemory workingMemory = internalWorkingMemoryArray[n2];
                RuleRemovalContext.CleanupAdapter adapter = context.getCleanupAdapter();
                ObjectHashSet memory = (ObjectHashSet)workingMemory.getNodeMemory(this);
                Iterator it = memory.iterator();
                ObjectHashSet.ObjectEntry entry = (ObjectHashSet.ObjectEntry)it.next();
                while (entry != null) {
                    InternalFactHandle handle = (InternalFactHandle)entry.getValue();
                    LeftTuple leftTuple = handle.getFirstLeftTuple();
                    while (leftTuple != null) {
                        adapter.cleanUp(leftTuple, workingMemory);
                        leftTuple = leftTuple.getLeftParentNext();
                    }
                    entry = (ObjectHashSet.ObjectEntry)it.next();
                }
                ++n2;
            }
            context.setCleanupAdapter(null);
        }
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new ObjectHashSet();
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemoryEnabled;
    }

    public void setObjectMemoryEnabled(boolean objectMemoryEnabled) {
        this.objectMemoryEnabled = objectMemoryEnabled;
    }

    public String toString() {
        return "[ObjectTypeNode(" + this.id + ")::" + ((EntryPointNode)this.source).getEntryPoint() + " objectType=" + this.objectType + " expiration=" + this.expirationOffset + "ms ]";
    }

    public int hashCode() {
        return this.objectType.hashCode() ^ this.source.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ObjectTypeNode)) {
            return false;
        }
        ObjectTypeNode other = (ObjectTypeNode)object;
        return this.objectType.equals(other.objectType) && this.source.equals(other.source);
    }

    private boolean canSkipOnModify(Sink[] sinks, boolean rootCall) {
        boolean hasConstraints = false;
        int i = 0;
        while (i < sinks.length && !hasConstraints) {
            if (sinks[i] instanceof AlphaNode || sinks[i] instanceof AccumulateNode || sinks[i] instanceof FromNode) {
                hasConstraints = true;
            } else if (sinks[i] instanceof BetaNode && ((BetaNode)sinks[i]).getConstraints().length > 0) {
                hasConstraints = rootCall || this.usesDeclaration(((BetaNode)sinks[i]).getConstraints());
            } else if (sinks[i] instanceof EvalConditionNode) {
                hasConstraints = this.usesDeclaration(((EvalConditionNode)sinks[i]).getCondition());
            }
            if (!hasConstraints && sinks[i] instanceof ObjectSource) {
                hasConstraints = !this.canSkipOnModify(((ObjectSource)((Object)sinks[i])).getSinkPropagator().getSinks(), false);
            } else if (!hasConstraints && sinks[i] instanceof LeftTupleSource) {
                hasConstraints = !this.canSkipOnModify(((LeftTupleSource)((Object)sinks[i])).getSinkPropagator().getSinks(), false);
            }
            ++i;
        }
        return !hasConstraints;
    }

    private boolean usesDeclaration(Constraint[] constraints) {
        boolean usesDecl = false;
        int i = 0;
        while (!usesDecl && i < constraints.length) {
            usesDecl = this.usesDeclaration(constraints[i]);
            ++i;
        }
        return usesDecl;
    }

    private boolean usesDeclaration(Constraint constraint) {
        boolean usesDecl = false;
        Declaration[] declarations = constraint.getRequiredDeclarations();
        int j = 0;
        while (!usesDecl && j < declarations.length) {
            usesDecl = declarations[j].getPattern().getObjectType() == this.objectType;
            ++j;
        }
        return usesDecl;
    }

    private boolean usesDeclaration(EvalCondition condition) {
        boolean usesDecl = false;
        Declaration[] declarations = condition.getRequiredDeclarations();
        int j = 0;
        while (!usesDecl && j < declarations.length) {
            usesDecl = declarations[j].getPattern().getObjectType() == this.objectType;
            ++j;
        }
        return usesDecl;
    }

    public EntryPoint getEntryPoint() {
        return ((EntryPointNode)this.source).getEntryPoint();
    }

    public long getExpirationOffset() {
        return this.expirationOffset;
    }

    public void setExpirationOffset(long expirationOffset) {
        this.expirationOffset = expirationOffset;
        if (!this.objectType.getValueType().equals(ValueType.QUERY_TYPE)) {
            if (this.expirationOffset > 0L) {
                this.setObjectMemoryEnabled(true);
            } else if (this.expirationOffset == 0L) {
                this.setObjectMemoryEnabled(false);
            }
        }
    }

    private static class ExpireJob
    implements Job {
        private ExpireJob() {
        }

        public void execute(JobContext ctx) {
            ExpireJobContext context = (ExpireJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction(context.expireAction);
        }
    }

    private static class ExpireJobContext
    implements JobContext,
    Externalizable {
        public ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction;
        public InternalWorkingMemory workingMemory;
        public JobHandle handle;

        public ExpireJobContext(ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction, InternalWorkingMemory workingMemory) {
            this.expireAction = expireAction;
            this.workingMemory = workingMemory;
        }

        public JobHandle getJobHandle() {
            return this.handle;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }
}

