/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.ObjectHashSet;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.core.util.RightTupleIndexHashTable;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkPropagator;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.RuleTerminalNode;

public class MemoryVisitor
extends ReflectiveVisitor
implements Externalizable {
    private InternalWorkingMemory workingMemory;
    private int indent = 0;

    public MemoryVisitor() {
    }

    public MemoryVisitor(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.indent = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeInt(this.indent);
    }

    public void visitReteooRuleBase(ReteooRuleBase ruleBase) {
        this.visit(ruleBase.getRete());
    }

    public void visitRete(Rete rete) {
        for (ObjectTypeNode node : rete.getObjectTypeNodes()) {
            this.visit(node);
        }
    }

    public void visitObjectTypeNode(ObjectTypeNode node) {
        System.out.println(String.valueOf(this.indent()) + node);
        ObjectHashSet memory = (ObjectHashSet)this.workingMemory.getNodeMemory(node);
        this.checkObjectHashSet(memory);
        ++this.indent;
        try {
            Field field = ObjectSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get(node);
            ObjectSink[] sinks = sink.getSinks();
            int i = 0;
            int length = sinks.length;
            while (i < length) {
                this.visit(sinks[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitAlphaNode(AlphaNode node) {
        System.out.println(String.valueOf(this.indent()) + node);
        ++this.indent;
        try {
            Field field = ObjectSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get(node);
            ObjectSink[] sinks = sink.getSinks();
            int i = 0;
            int length = sinks.length;
            while (i < length) {
                this.visit(sinks[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitLeftInputAdapterNode(LeftInputAdapterNode node) {
        System.out.println(String.valueOf(this.indent()) + node);
        ++this.indent;
        try {
            Field field = LeftTupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get(node);
            LeftTupleSink[] sinks = sink.getSinks();
            int i = 0;
            int length = sinks.length;
            while (i < length) {
                this.visit(sinks[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitJoinNode(JoinNode node) {
        System.out.println(String.valueOf(this.indent()) + node);
        try {
            BetaMemory memory = (BetaMemory)this.workingMemory.getNodeMemory(node);
            this.checkObjectHashTable(memory.getRightTupleMemory());
            this.checkLeftTupleMemory(memory.getLeftTupleMemory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.indent;
        try {
            Field field = LeftTupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get(node);
            LeftTupleSink[] sinks = sink.getSinks();
            int i = 0;
            int length = sinks.length;
            while (i < length) {
                this.visit(sinks[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitNotNode(NotNode node) {
        System.out.println(String.valueOf(this.indent()) + node);
        try {
            BetaMemory memory = (BetaMemory)this.workingMemory.getNodeMemory(node);
            this.checkObjectHashTable(memory.getRightTupleMemory());
            this.checkLeftTupleMemory(memory.getLeftTupleMemory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.indent;
        try {
            Field field = LeftTupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get(node);
            LeftTupleSink[] sinks = sink.getSinks();
            int i = 0;
            int length = sinks.length;
            while (i < length) {
                this.visit(sinks[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitRuleTerminalNode(RuleTerminalNode node) {
        System.out.println(String.valueOf(this.indent()) + node);
    }

    private void checkObjectHashSet(ObjectHashSet memory) {
        Entry[] entries = memory.getTable();
        int factCount = 0;
        boolean bucketCount = false;
        int i = 0;
        int length = entries.length;
        while (i < length) {
            if (entries[i] != null) {
                Entry entry = entries[i];
                while (entry != null) {
                    entry = entry.getNext();
                    ++factCount;
                }
            }
            ++i;
        }
        System.out.println(String.valueOf(this.indent()) + "ObjectHashSet: " + memory.size() + ":" + factCount);
        if (factCount != memory.size()) {
            System.out.println(String.valueOf(this.indent()) + "error");
        }
    }

    private void checkObjectHashTable(RightTupleMemory memory) {
        if (memory instanceof RightTupleList) {
            this.checkRightTupleList((RightTupleList)memory);
        } else if (memory instanceof RightTupleIndexHashTable) {
            this.checkRightTupleIndexHashTable((RightTupleIndexHashTable)memory);
        } else {
            throw new RuntimeException(memory.getClass() + " should not be here");
        }
    }

    private void checkRightTupleList(RightTupleList memory) {
        int count = 0;
        RightTuple rightTuple = memory.getFirst(null);
        while (rightTuple != null) {
            ++count;
            rightTuple = (RightTuple)rightTuple.getNext();
        }
        System.out.println(String.valueOf(this.indent()) + "FactHashTable: " + memory.size() + ":" + count);
        if (memory.size() != count) {
            System.out.println(String.valueOf(this.indent()) + "error");
        }
    }

    private void checkRightTupleIndexHashTable(RightTupleIndexHashTable memory) {
        Entry[] entries = memory.getTable();
        int factCount = 0;
        int bucketCount = 0;
        int i = 0;
        int length = entries.length;
        while (i < length) {
            if (entries[i] != null) {
                RightTupleList rightTupleList = (RightTupleList)entries[i];
                while (rightTupleList != null) {
                    if (rightTupleList.first != null) {
                        Entry entry = rightTupleList.first;
                        while (entry != null) {
                            entry = entry.getNext();
                            ++factCount;
                        }
                    } else {
                        System.out.println("error : fieldIndexHashTable cannot have empty FieldIndexEntry objects");
                    }
                    rightTupleList = (RightTupleList)rightTupleList.getNext();
                    ++bucketCount;
                }
            }
            ++i;
        }
        try {
            Field field = AbstractHashTable.class.getDeclaredField("size");
            field.setAccessible(true);
            System.out.println(String.valueOf(this.indent()) + "FieldIndexBuckets: " + (Integer)field.get(memory) + ":" + bucketCount);
            if ((Integer)field.get(memory) != bucketCount) {
                System.out.println(String.valueOf(this.indent()) + "error");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(String.valueOf(this.indent()) + "FieldIndexFacts: " + memory.size() + ":" + factCount);
        if (memory.size() != factCount) {
            System.out.println(String.valueOf(this.indent()) + "error");
        }
    }

    private void checkLeftTupleMemory(LeftTupleMemory memory) {
    }

    private String indent() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.indent) {
            buffer.append("  ");
            ++i;
        }
        return buffer.toString();
    }
}

