/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.base.ValueType;
import org.drools.base.evaluators.Operator;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.core.util.ObjectHashMap;
import org.drools.reteoo.AbstractObjectSinkAdapter;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSinkNodeList;
import org.drools.rule.LiteralConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.PropagationContext;
import org.drools.spi.ReadAccessor;

public class CompositeObjectSinkAdapter
extends AbstractObjectSinkAdapter {
    private static final long serialVersionUID = 400L;
    ObjectSinkNodeList otherSinks;
    ObjectSinkNodeList hashableSinks;
    LinkedList hashedFieldIndexes;
    ObjectHashMap hashedSinkMap;
    private int alphaNodeHashingThreshold;

    public CompositeObjectSinkAdapter() {
        this(null, 3);
    }

    public CompositeObjectSinkAdapter(RuleBasePartitionId partitionId, int alphaNodeHashingThreshold) {
        super(partitionId);
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.otherSinks = (ObjectSinkNodeList)in.readObject();
        this.hashableSinks = (ObjectSinkNodeList)in.readObject();
        this.hashedFieldIndexes = (LinkedList)in.readObject();
        this.hashedSinkMap = (ObjectHashMap)in.readObject();
        this.alphaNodeHashingThreshold = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.otherSinks);
        out.writeObject(this.hashableSinks);
        out.writeObject(this.hashedFieldIndexes);
        out.writeObject(this.hashedSinkMap);
        out.writeInt(this.alphaNodeHashingThreshold);
    }

    public ObjectSinkNodeList getOthers() {
        return this.otherSinks;
    }

    public ObjectSinkNodeList getHashableSinks() {
        return this.hashableSinks;
    }

    public ObjectHashMap getHashedSinkMap() {
        return this.hashedSinkMap;
    }

    public void addObjectSink(ObjectSink sink) {
        LiteralConstraint literalConstraint;
        Evaluator evaluator;
        AlphaNode alphaNode;
        AlphaNodeFieldConstraint fieldConstraint;
        if (sink instanceof AlphaNode && (fieldConstraint = (alphaNode = (AlphaNode)sink).getConstraint()) instanceof LiteralConstraint && (evaluator = (literalConstraint = (LiteralConstraint)fieldConstraint).getEvaluator()).getOperator() == Operator.EQUAL && literalConstraint.getFieldExtractor().getValueType() != ValueType.OBJECT_TYPE) {
            InternalReadAccessor readAccessor = literalConstraint.getFieldExtractor();
            int index = readAccessor.getIndex();
            FieldIndex fieldIndex = this.registerFieldIndex(index, readAccessor);
            if (fieldIndex.getCount() >= this.alphaNodeHashingThreshold && this.alphaNodeHashingThreshold != 0) {
                if (!fieldIndex.isHashed()) {
                    this.hashSinks(fieldIndex);
                }
                FieldValue value = literalConstraint.getField();
                this.hashedSinkMap.put(new HashKey(index, value, fieldIndex.getFieldExtractor()), alphaNode, false);
            } else {
                if (this.hashableSinks == null) {
                    this.hashableSinks = new ObjectSinkNodeList();
                }
                this.hashableSinks.add(alphaNode);
            }
            return;
        }
        if (this.otherSinks == null) {
            this.otherSinks = new ObjectSinkNodeList();
        }
        this.otherSinks.add((ObjectSinkNode)sink);
    }

    public void removeObjectSink(ObjectSink sink) {
        AlphaNode alphaNode;
        AlphaNodeFieldConstraint fieldConstraint;
        if (sink instanceof AlphaNode && (fieldConstraint = (alphaNode = (AlphaNode)sink).getConstraint()) instanceof LiteralConstraint) {
            LiteralConstraint literalConstraint = (LiteralConstraint)fieldConstraint;
            Evaluator evaluator = literalConstraint.getEvaluator();
            FieldValue value = literalConstraint.getField();
            if (evaluator.getOperator() == Operator.EQUAL && literalConstraint.getFieldExtractor().getValueType() != ValueType.OBJECT_TYPE) {
                InternalReadAccessor fieldAccessor = literalConstraint.getFieldExtractor();
                int index = fieldAccessor.getIndex();
                FieldIndex fieldIndex = this.unregisterFieldIndex(index);
                if (fieldIndex.isHashed()) {
                    HashKey hashKey = new HashKey(index, value, fieldAccessor);
                    this.hashedSinkMap.remove(hashKey);
                    if (fieldIndex.getCount() <= this.alphaNodeHashingThreshold - 1) {
                        this.unHashSinks(fieldIndex);
                    }
                } else {
                    this.hashableSinks.remove(alphaNode);
                }
                if (this.hashableSinks != null && this.hashableSinks.isEmpty()) {
                    this.hashableSinks = null;
                }
                return;
            }
        }
        this.otherSinks.remove((ObjectSinkNode)sink);
        if (this.otherSinks.isEmpty()) {
            this.otherSinks = null;
        }
    }

    void hashSinks(FieldIndex fieldIndex) {
        if (this.hashedSinkMap == null) {
            this.hashedSinkMap = new ObjectHashMap();
        }
        int index = fieldIndex.getIndex();
        InternalReadAccessor fieldReader = fieldIndex.getFieldExtractor();
        ObjectSinkNode currentSink = this.hashableSinks.getFirst();
        while (currentSink != null) {
            AlphaNode alphaNode = (AlphaNode)currentSink;
            AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
            LiteralConstraint literalConstraint = (LiteralConstraint)fieldConstraint;
            currentSink = currentSink.getNextObjectSinkNode();
            if (index != literalConstraint.getFieldExtractor().getIndex()) continue;
            FieldValue value = literalConstraint.getField();
            this.hashedSinkMap.put(new HashKey(index, value, fieldReader), alphaNode);
            this.hashableSinks.remove(alphaNode);
        }
        if (this.hashableSinks.isEmpty()) {
            this.hashableSinks = null;
        }
        fieldIndex.setHashed(true);
    }

    void unHashSinks(FieldIndex fieldIndex) {
        int index = fieldIndex.getIndex();
        ArrayList<HashKey> unhashedSinks = new ArrayList<HashKey>();
        Iterator iter = this.hashedSinkMap.newIterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)iter.next();
        while (entry != null) {
            AlphaNode alphaNode = (AlphaNode)entry.getValue();
            LiteralConstraint literalConstraint = (LiteralConstraint)alphaNode.getConstraint();
            if (index == literalConstraint.getFieldExtractor().getIndex()) {
                FieldValue value = literalConstraint.getField();
                if (this.hashableSinks == null) {
                    this.hashableSinks = new ObjectSinkNodeList();
                }
                this.hashableSinks.add(alphaNode);
                unhashedSinks.add(new HashKey(index, value, fieldIndex.getFieldExtractor()));
            }
            entry = (ObjectHashMap.ObjectEntry)iter.next();
        }
        for (HashKey hashKey : unhashedSinks) {
            this.hashedSinkMap.remove(hashKey);
        }
        if (this.hashedSinkMap.isEmpty()) {
            this.hashedSinkMap = null;
        }
        fieldIndex.setHashed(false);
    }

    private FieldIndex registerFieldIndex(int index, InternalReadAccessor fieldExtractor) {
        FieldIndex fieldIndex = null;
        if (this.hashedFieldIndexes == null) {
            this.hashedFieldIndexes = new LinkedList();
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.hashedFieldIndexes.add(fieldIndex);
        }
        if (fieldIndex == null) {
            fieldIndex = this.findFieldIndex(index);
        }
        if (fieldIndex == null) {
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.hashedFieldIndexes.add(fieldIndex);
        }
        fieldIndex.increaseCounter();
        return fieldIndex;
    }

    private FieldIndex unregisterFieldIndex(int index) {
        FieldIndex fieldIndex = this.findFieldIndex(index);
        fieldIndex.decreaseCounter();
        if (fieldIndex.getCount() == 0) {
            this.hashedFieldIndexes.remove(fieldIndex);
            if (this.hashedFieldIndexes.isEmpty()) {
                this.hashedFieldIndexes = null;
            }
        }
        return fieldIndex;
    }

    private FieldIndex findFieldIndex(int index) {
        FieldIndex node = (FieldIndex)this.hashedFieldIndexes.getFirst();
        while (node != null) {
            if (node.getIndex() == index) {
                return node;
            }
            node = (FieldIndex)node.getNext();
        }
        return null;
    }

    public void propagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectSinkNode sink;
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            FieldIndex fieldIndex = (FieldIndex)this.hashedFieldIndexes.getFirst();
            while (fieldIndex != null) {
                int index;
                HashKey hashKey;
                AlphaNode sink2;
                if (fieldIndex.isHashed() && (sink2 = (AlphaNode)this.hashedSinkMap.get(hashKey = new HashKey(index = fieldIndex.getIndex(), object, fieldIndex.getFieldExtractor()))) != null) {
                    sink2.getSinkPropagator().propagateAssertObject(factHandle, context, workingMemory);
                }
                fieldIndex = (FieldIndex)fieldIndex.getNext();
            }
        }
        if (this.hashableSinks != null) {
            sink = this.hashableSinks.getFirst();
            while (sink != null) {
                this.doPropagateAssertObject(factHandle, context, workingMemory, sink);
                sink = sink.getNextObjectSinkNode();
            }
        }
        if (this.otherSinks != null) {
            sink = this.otherSinks.getFirst();
            while (sink != null) {
                this.doPropagateAssertObject(factHandle, context, workingMemory, sink);
                sink = sink.getNextObjectSinkNode();
            }
        }
    }

    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectSinkNode sink;
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            FieldIndex fieldIndex = (FieldIndex)this.hashedFieldIndexes.getFirst();
            while (fieldIndex != null) {
                int index;
                HashKey hashKey;
                AlphaNode sink2;
                if (fieldIndex.isHashed() && (sink2 = (AlphaNode)this.hashedSinkMap.get(hashKey = new HashKey(index = fieldIndex.getIndex(), object, fieldIndex.getFieldExtractor()))) != null) {
                    sink2.getSinkPropagator().propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
                }
                fieldIndex = (FieldIndex)fieldIndex.getNext();
            }
        }
        if (this.hashableSinks != null) {
            sink = this.hashableSinks.getFirst();
            while (sink != null) {
                this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, sink);
                sink = sink.getNextObjectSinkNode();
            }
        }
        if (this.otherSinks != null) {
            sink = this.otherSinks.getFirst();
            while (sink != null) {
                this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, sink);
                sink = sink.getNextObjectSinkNode();
            }
        }
    }

    protected void doPropagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, ObjectSink sink) {
        sink.assertObject(factHandle, context, workingMemory);
    }

    protected void doPropagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory, ObjectSink sink) {
        sink.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public BaseNode getMatchingNode(BaseNode candidate) {
        ObjectSinkNode sink;
        if (this.otherSinks != null) {
            sink = this.otherSinks.getFirst();
            while (sink != null) {
                if (candidate.equals(sink)) {
                    return (BaseNode)((Object)sink);
                }
                sink = sink.getNextObjectSinkNode();
            }
        }
        if (this.hashableSinks != null) {
            sink = this.hashableSinks.getFirst();
            while (sink != null) {
                if (candidate.equals(sink)) {
                    return (BaseNode)((Object)sink);
                }
                sink = sink.getNextObjectSinkNode();
            }
        }
        if (this.hashedSinkMap != null) {
            Iterator it = this.hashedSinkMap.newIterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                ObjectSink sink2 = (ObjectSink)entry.getValue();
                if (candidate.equals(sink2)) {
                    return (BaseNode)((Object)sink2);
                }
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
        }
        return null;
    }

    public ObjectSink[] getSinks() {
        ObjectSinkNode sink;
        ObjectSink[] sinks = new ObjectSink[this.size()];
        int at = 0;
        if (this.otherSinks != null) {
            sink = this.otherSinks.getFirst();
            while (sink != null) {
                sinks[at++] = sink;
                sink = sink.getNextObjectSinkNode();
            }
        }
        if (this.hashableSinks != null) {
            sink = this.hashableSinks.getFirst();
            while (sink != null) {
                sinks[at++] = sink;
                sink = sink.getNextObjectSinkNode();
            }
        }
        if (this.hashedSinkMap != null) {
            Iterator it = this.hashedSinkMap.newIterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                sinks[at++] = (ObjectSink)entry.getValue();
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
        }
        return sinks;
    }

    public int size() {
        return (this.otherSinks != null ? this.otherSinks.size() : 0) + (this.hashableSinks != null ? this.hashableSinks.size() : 0) + (this.hashedSinkMap != null ? this.hashedSinkMap.size() : 0);
    }

    public static class FieldIndex
    implements LinkedListNode {
        private static final long serialVersionUID = 400L;
        private int index;
        private InternalReadAccessor fieldExtactor;
        private int count;
        private boolean hashed;
        private LinkedListNode previous;
        private LinkedListNode next;

        public FieldIndex() {
        }

        public FieldIndex(int index, InternalReadAccessor fieldExtractor) {
            this.index = index;
            this.fieldExtactor = fieldExtractor;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = in.readInt();
            this.fieldExtactor = (InternalReadAccessor)in.readObject();
            this.count = in.readInt();
            this.hashed = in.readBoolean();
            this.previous = (LinkedListNode)in.readObject();
            this.next = (LinkedListNode)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.index);
            out.writeObject(this.fieldExtactor);
            out.writeInt(this.count);
            out.writeBoolean(this.hashed);
            out.writeObject(this.previous);
            out.writeObject(this.next);
        }

        public InternalReadAccessor getFieldExtractor() {
            return this.fieldExtactor;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCount() {
            return this.count;
        }

        public ReadAccessor getFieldExtactor() {
            return this.fieldExtactor;
        }

        public boolean isHashed() {
            return this.hashed;
        }

        public void setHashed(boolean hashed) {
            this.hashed = hashed;
        }

        public void increaseCounter() {
            ++this.count;
        }

        public void decreaseCounter() {
            --this.count;
        }

        public LinkedListNode getNext() {
            return this.next;
        }

        public LinkedListNode getPrevious() {
            return this.previous;
        }

        public void setNext(LinkedListNode next) {
            this.next = next;
        }

        public void setPrevious(LinkedListNode previous) {
            this.previous = previous;
        }
    }

    public static class HashKey
    implements Externalizable {
        private static final long serialVersionUID = 400L;
        private static final byte OBJECT = 1;
        private static final byte LONG = 2;
        private static final byte DOUBLE = 3;
        private static final byte BOOL = 4;
        private int index;
        private byte type;
        private Object ovalue;
        private long lvalue;
        private boolean bvalue;
        private double dvalue;
        private boolean isNull;
        private int hashCode;

        public HashKey() {
        }

        public HashKey(int index, FieldValue value, InternalReadAccessor extractor) {
            this.setValue(index, extractor, value);
        }

        public HashKey(int index, Object value, InternalReadAccessor extractor) {
            this.setValue(index, value, extractor);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = in.readInt();
            this.type = in.readByte();
            this.ovalue = in.readObject();
            this.lvalue = in.readLong();
            this.bvalue = in.readBoolean();
            this.dvalue = in.readDouble();
            this.isNull = in.readBoolean();
            this.hashCode = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.index);
            out.writeByte(this.type);
            out.writeObject(this.ovalue);
            out.writeLong(this.lvalue);
            out.writeBoolean(this.bvalue);
            out.writeDouble(this.dvalue);
            out.writeBoolean(this.isNull);
            out.writeInt(this.hashCode);
        }

        public int getIndex() {
            return this.index;
        }

        public void setValue(int index, Object value, InternalReadAccessor extractor) {
            this.index = index;
            ValueType vtype = extractor.getValueType();
            this.isNull = extractor.isNullValue(null, value);
            if (vtype.isBoolean()) {
                this.type = (byte)4;
                if (!this.isNull) {
                    this.bvalue = extractor.getBooleanValue(null, value);
                    this.setHashCode(this.bvalue ? 1231 : 1237);
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isIntegerNumber() || vtype.isChar()) {
                this.type = (byte)2;
                if (!this.isNull) {
                    this.lvalue = extractor.getLongValue(null, value);
                    this.setHashCode((int)(this.lvalue ^ this.lvalue >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isFloatNumber()) {
                this.type = (byte)3;
                if (!this.isNull) {
                    this.dvalue = extractor.getDoubleValue(null, value);
                    long temp = Double.doubleToLongBits(this.dvalue);
                    this.setHashCode((int)(temp ^ temp >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else {
                this.type = 1;
                if (!this.isNull) {
                    this.ovalue = extractor.getValue(null, value);
                    this.setHashCode(this.ovalue != null ? this.ovalue.hashCode() : 0);
                } else {
                    this.setHashCode(0);
                }
            }
        }

        public void setValue(int index, InternalReadAccessor extractor, FieldValue value) {
            this.index = index;
            this.isNull = value.isNull();
            ValueType vtype = extractor.getValueType();
            if (vtype.isBoolean()) {
                this.type = (byte)4;
                if (!this.isNull) {
                    this.bvalue = value.getBooleanValue();
                    this.setHashCode(this.bvalue ? 1231 : 1237);
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isIntegerNumber()) {
                this.type = (byte)2;
                if (!this.isNull) {
                    this.lvalue = value.getLongValue();
                    this.setHashCode((int)(this.lvalue ^ this.lvalue >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isFloatNumber()) {
                this.type = (byte)3;
                if (!this.isNull) {
                    this.dvalue = value.getDoubleValue();
                    long temp = Double.doubleToLongBits(this.dvalue);
                    this.setHashCode((int)(temp ^ temp >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else {
                this.type = 1;
                if (!this.isNull) {
                    this.ovalue = value.getValue();
                    this.setHashCode(this.ovalue != null ? this.ovalue.hashCode() : 0);
                } else {
                    this.setHashCode(0);
                }
            }
        }

        private void setHashCode(int hashSeed) {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + hashSeed;
            this.hashCode = result = 31 * result + this.index;
        }

        public boolean getBooleanValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return false;
                    }
                    if (this.ovalue instanceof Boolean) {
                        return (Boolean)this.ovalue;
                    }
                    if (this.ovalue instanceof String) {
                        return Boolean.valueOf((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a boolean value.");
                }
                case 2: {
                    throw new ClassCastException("Can't convert long to a boolean value.");
                }
                case 3: {
                    throw new ClassCastException("Can't convert double to a boolean value.");
                }
            }
            return false;
        }

        public long getLongValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? 1 : 0;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return 0L;
                    }
                    if (this.ovalue instanceof Number) {
                        return ((Number)this.ovalue).longValue();
                    }
                    if (this.ovalue instanceof String) {
                        return Long.parseLong((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a long value.");
                }
                case 2: {
                    return this.lvalue;
                }
                case 3: {
                    return (long)this.dvalue;
                }
            }
            return 0L;
        }

        public double getDoubleValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? 1 : 0;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return 0.0;
                    }
                    if (this.ovalue instanceof Number) {
                        return ((Number)this.ovalue).doubleValue();
                    }
                    if (this.ovalue instanceof String) {
                        return Double.parseDouble((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a double value.");
                }
                case 2: {
                    return this.lvalue;
                }
                case 3: {
                    return this.dvalue;
                }
            }
            return 0.0;
        }

        public Object getObjectValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? Boolean.TRUE : Boolean.FALSE;
                }
                case 1: {
                    return this.ovalue;
                }
                case 2: {
                    return new Long(this.lvalue);
                }
                case 3: {
                    return new Double(this.dvalue);
                }
            }
            return null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            HashKey other = (HashKey)object;
            if (this.isNull) {
                return other.isNull;
            }
            switch (this.type) {
                case 4: {
                    return this.index == other.index && this.bvalue == other.getBooleanValue();
                }
                case 2: {
                    return this.index == other.index && this.lvalue == other.getLongValue();
                }
                case 3: {
                    return this.index == other.index && this.dvalue == other.getDoubleValue();
                }
                case 1: {
                    Object otherValue = other.getObjectValue();
                    if (this.ovalue != null && this.ovalue instanceof Number && otherValue instanceof Number) {
                        return this.index == other.index && ((Number)this.ovalue).doubleValue() == ((Number)otherValue).doubleValue();
                    }
                    return this.index == other.index && (this.ovalue == null ? otherValue == null : this.ovalue.equals(otherValue));
                }
            }
            return false;
        }
    }
}

