/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleBasePartitionId;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.ConcurrentRightTuple;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MemoryVisitor;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleSink;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Behavior;
import org.drools.rule.BehaviorManager;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BetaNode
extends LeftTupleSource
implements LeftTupleSinkNode,
ObjectSinkNode,
RightTupleSink,
NodeMemory {
    protected LeftTupleSource leftInput;
    protected ObjectSource rightInput;
    protected BetaConstraints constraints;
    protected BehaviorManager behavior;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    protected boolean objectMemory = true;
    protected boolean tupleMemoryEnabled;
    protected boolean concurrentRightTupleMemory = false;

    public BetaNode() {
    }

    BetaNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints constraints, Behavior[] behaviors) {
        super(id, partitionId, partitionsEnabled);
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.constraints = constraints;
        this.behavior = new BehaviorManager(behaviors);
        if (this.constraints == null) {
            throw new RuntimeException("cannot have null constraints, must at least be an instance of EmptyBetaConstraints");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraints = (BetaConstraints)in.readObject();
        this.behavior = (BehaviorManager)in.readObject();
        this.leftInput = (LeftTupleSource)in.readObject();
        this.rightInput = (ObjectSource)in.readObject();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.previousObjectSinkNode = (ObjectSinkNode)in.readObject();
        this.nextObjectSinkNode = (ObjectSinkNode)in.readObject();
        this.objectMemory = in.readBoolean();
        this.tupleMemoryEnabled = in.readBoolean();
        this.concurrentRightTupleMemory = in.readBoolean();
        super.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraints);
        out.writeObject(this.behavior);
        out.writeObject(this.leftInput);
        out.writeObject(this.rightInput);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.previousObjectSinkNode);
        out.writeObject(this.nextObjectSinkNode);
        out.writeBoolean(this.objectMemory);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeBoolean(this.concurrentRightTupleMemory);
        super.writeExternal(out);
    }

    public BetaNodeFieldConstraint[] getConstraints() {
        LinkedList constraints = this.constraints.getConstraints();
        BetaNodeFieldConstraint[] array = new BetaNodeFieldConstraint[constraints.size()];
        int i = 0;
        LinkedListEntry entry = (LinkedListEntry)constraints.getFirst();
        while (entry != null) {
            array[i++] = (BetaNodeFieldConstraint)entry.getObject();
            entry = (LinkedListEntry)entry.getNext();
        }
        return array;
    }

    public Behavior[] getBehaviors() {
        return this.behavior.getBehaviors();
    }

    @Override
    public void attach() {
        this.rightInput.addObjectSink(this);
        this.leftInput.addTupleSink(this);
    }

    @Override
    public void networkUpdated() {
        this.rightInput.networkUpdated();
        this.leftInput.networkUpdated();
    }

    public List<String> getRules() {
        ArrayList<String> list = new ArrayList<String>();
        LeftTupleSink[] sinks = this.sink.getSinks();
        int i = 0;
        int length = sinks.length;
        while (i < length) {
            if (sinks[i] instanceof RuleTerminalNode) {
                list.add(((RuleTerminalNode)sinks[i]).getRule().getName());
            } else if (sinks[i] instanceof BetaNode) {
                list.addAll(((BetaNode)sinks[i]).getRules());
            }
            ++i;
        }
        return list;
    }

    public ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.source;
        }
        return (ObjectTypeNode)source;
    }

    @Override
    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int i = 0;
        int length = workingMemories.length;
        while (i < length) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.rightInput.updateSink(this, propagationContext, workingMemory);
            this.leftInput.updateSink(this, propagationContext, workingMemory);
            ++i;
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        if (!this.isInUse() || context.getCleanupAdapter() != null) {
            int i = 0;
            int length = workingMemories.length;
            while (i < length) {
                BetaMemory memory = null;
                Object object = workingMemories[i].getNodeMemory(this);
                memory = object instanceof AccumulateNode.AccumulateMemory ? ((AccumulateNode.AccumulateMemory)object).betaMemory : (BetaMemory)object;
                Iterator it = memory.getLeftTupleMemory().iterator();
                LeftTuple leftTuple = (LeftTuple)it.next();
                while (leftTuple != null) {
                    if (context.getCleanupAdapter() != null) {
                        LeftTuple child = leftTuple.firstChild;
                        while (child != null) {
                            if (child.getLeftTupleSink() == this) {
                                leftTuple.unlinkFromLeftParent();
                                leftTuple.unlinkFromRightParent();
                            } else {
                                context.getCleanupAdapter().cleanUp(child, workingMemories[i]);
                            }
                            child = child.getLeftParentNext();
                        }
                    }
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    leftTuple = (LeftTuple)it.next();
                }
                if (object instanceof AccumulateNode.AccumulateMemory) {
                    ((AccumulateNode)this).doRemove(workingMemories[i], (AccumulateNode.AccumulateMemory)object);
                }
                if (!this.isInUse()) {
                    it = memory.getRightTupleMemory().iterator();
                    RightTuple rightTuple = (RightTuple)it.next();
                    while (rightTuple != null) {
                        if (rightTuple.getBlocked() != null) {
                            LeftTuple leftTuple2 = rightTuple.getBlocked();
                            while (leftTuple2 != null) {
                                LeftTuple temp = leftTuple2.getBlockedNext();
                                leftTuple2.setBlocker(null);
                                leftTuple2.setBlockedPrevious(null);
                                leftTuple2.setBlockedNext(null);
                                leftTuple2.unlinkFromLeftParent();
                                leftTuple2 = temp;
                            }
                        }
                        rightTuple.unlinkFromRightParent();
                        rightTuple = (RightTuple)it.next();
                    }
                    workingMemories[i].clearNodeMemory(this);
                }
                ++i;
            }
            context.setCleanupAdapter(null);
        }
        this.rightInput.remove(context, builder, this, workingMemories);
        this.leftInput.remove(context, builder, this, workingMemories);
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple rightTuple = modifyPreviousTuples.removeRightTuple(this);
        if (rightTuple != null) {
            rightTuple.reAdd();
            this.modifyRightTuple(rightTuple, context, workingMemory);
        } else {
            this.assertObject(factHandle, context, workingMemory);
        }
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple leftTuple = modifyPreviousTuples.removeLeftTuple(this);
        if (leftTuple != null) {
            leftTuple.reAdd();
            this.modifyLeftTuple(leftTuple, context, workingMemory);
        } else {
            this.assertLeftTuple(new LeftTuple(factHandle, (LeftTupleSink)this, true), context, workingMemory);
        }
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemory;
    }

    public void setObjectMemoryEnabled(boolean objectMemory) {
        this.objectMemory = objectMemory;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public boolean isConcurrentRightTupleMemory() {
        return this.concurrentRightTupleMemory;
    }

    public void setConcurrentRightTupleMemory(boolean concurrentRightTupleMemory) {
        this.concurrentRightTupleMemory = concurrentRightTupleMemory;
    }

    @Override
    public String toString() {
        return "[ " + this.getClass().getSimpleName() + "(" + this.id + ") ]";
    }

    public void dumpMemory(InternalWorkingMemory workingMemory) {
        MemoryVisitor visitor = new MemoryVisitor(workingMemory);
        visitor.visit(this);
    }

    @Override
    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BetaNode)) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints);
    }

    @Override
    public Object createMemory(RuleBaseConfiguration config) {
        BetaMemory memory = this.constraints.createBetaMemory(config);
        memory.setBehaviorContext(this.behavior.createBehaviorContext());
        return memory;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public RightTuple createRightTuple(InternalFactHandle handle, RightTupleSink sink) {
        if (!this.concurrentRightTupleMemory) {
            return new RightTuple(handle, sink);
        }
        return new ConcurrentRightTuple(handle, sink);
    }
}

