/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.debug;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.drools.common.NetworkNode;
import org.drools.core.util.debug.DefaultNodeInfo;
import org.drools.core.util.debug.NodeInfo;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.Package;
import org.drools.rule.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulKnowledgeSessionInfo {
    private ReteooWorkingMemory session;
    private Map<NetworkNode, DefaultNodeInfo> nodesInfo = new TreeMap<NetworkNode, DefaultNodeInfo>(new Comparator<NetworkNode>(){

        @Override
        public int compare(NetworkNode o1, NetworkNode o2) {
            return o1.getId() - o2.getId();
        }
    });
    private List<String> log = new LinkedList<String>();
    private SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");

    public Package[] getPackages() {
        return this.session.getRuleBase().getPackages();
    }

    public int getNodeCount() {
        return ((ReteooRuleBase)this.session.getRuleBase()).getNodeCount();
    }

    public int getExternalFactCount() {
        return this.session.getObjectStore().size();
    }

    public void assign(NetworkNode snode, Rule rule) {
        DefaultNodeInfo info = this.nodesInfo.get(snode);
        info.assign(rule);
    }

    public boolean visited(NetworkNode node) {
        return this.nodesInfo.containsKey(node);
    }

    public DefaultNodeInfo getNodeInfo(NetworkNode node) {
        return this.nodesInfo.get(node);
    }

    public void addNodeInfo(NetworkNode node, DefaultNodeInfo dni) {
        this.nodesInfo.put(node, dni);
    }

    public void info(String msg) {
        this.log(msg, " [INFO] - ");
    }

    public void warn(String msg) {
        this.log(msg, " [WARN] - ");
    }

    public void error(String msg) {
        this.log(msg, " [ERRO] - ");
    }

    private void log(String msg, String lvl) {
        this.log.add(String.valueOf(this.df.format(System.currentTimeMillis())) + lvl + msg);
    }

    public List<String> getLog() {
        return this.log;
    }

    public Collection<? extends NodeInfo> getNodeInfos() {
        return this.nodesInfo.values();
    }

    public ReteooWorkingMemory getSession() {
        return this.session;
    }

    public void setSession(ReteooWorkingMemory session) {
        this.session = session;
    }
}

