/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.File;
import java.util.UUID;

public class FileManager {
    private File root;

    public void setUp() {
        this.root = this.getRootDirectory();
    }

    public void tearDown() {
        boolean result = false;
        int i = 0;
        while (i < 5 && !result) {
            System.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("This should never happen");
            }
            result = this.deleteDir(this.root);
            ++i;
        }
    }

    public File newFile(String name) {
        File file = new File(this.getRootDirectory(), name);
        return file;
    }

    public File newFile(File dir, String name) {
        File file = new File(dir, name);
        return file;
    }

    public File getRootDirectory() {
        if (this.root != null) {
            return this.root;
        }
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File f = new File(tmp, "__drools__" + UUID.randomUUID().toString());
        if (f.exists()) {
            if (f.isFile()) {
                throw new IllegalStateException("The temp directory exists as a file. Nuke it now !");
            }
            this.deleteDir(f);
            f.mkdir();
        } else {
            f.mkdir();
        }
        this.root = f;
        return this.root;
    }

    public boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            String[] stringArray = children = dir.list();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                File file = new File(dir, child);
                boolean success = this.deleteDir(file);
                if (!success) {
                    System.gc();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("This should never happen");
                    }
                    success = this.deleteDir(file);
                    if (!success) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return dir.delete();
    }
}

