/*
 * Decompiled with CFR 0.152.
 */
package org.drools.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalExecutorService
implements ExecutorService {
    private AtomicReference<ExecutorService> delegate;
    private TaskManager taskManager;
    private boolean shutdown;
    private ReentrantLock lock;
    private Condition isShutdown;

    public ExternalExecutorService(ExecutorService delegate) {
        this.delegate = new AtomicReference<ExecutorService>(delegate);
        this.shutdown = false;
        this.lock = new ReentrantLock();
        this.isShutdown = this.lock.newCondition();
        this.taskManager = new TaskManager();
    }

    public void waitUntilEmpty() {
        this.taskManager.waitUntilEmpty();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.lock.lockInterruptibly();
            if (!this.shutdown) {
                this.isShutdown.await();
            }
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void execute(Runnable command) {
        ExecutorService service = this.delegate.get();
        if (service != null) {
            service.execute(this.taskManager.trackTask(command));
            return;
        }
        throw new RejectedExecutionException("Execution service is terminated. No more tasks can be executed.");
    }

    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ExecutorService service = this.delegate.get();
        if (service != null) {
            return service.invokeAll(this.taskManager.trackTasks(tasks), timeout, unit);
        }
        throw new RejectedExecutionException("Execution service is terminated. No more tasks can be executed.");
    }

    public List invokeAll(Collection tasks) throws InterruptedException {
        ExecutorService service = this.delegate.get();
        if (service != null) {
            return service.invokeAll(this.taskManager.trackTasks(tasks));
        }
        throw new RejectedExecutionException("Execution service is terminated. No more tasks can be executed.");
    }

    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService service = this.delegate.get();
        if (service != null) {
            return service.invokeAny(tasks, timeout, unit);
        }
        throw new RejectedExecutionException("Execution service is terminated. No more tasks can be executed.");
    }

    public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        ExecutorService service = this.delegate.get();
        if (service != null) {
            return service.invokeAny(tasks);
        }
        throw new RejectedExecutionException("Execution service is terminated. No more tasks can be executed.");
    }

    @Override
    public boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isTerminated() {
        this.lock.lock();
        try {
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
            this.delegate.set(null);
            this.taskManager.cleanUpTasks();
            this.isShutdown.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        ExecutorService service = this.delegate.get();
        if (service != null) {
            return service.submit(this.taskManager.trackTask(task));
        }
        throw new RejectedExecutionException("Execution service is terminated. No more tasks can be executed.");
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        ExecutorService service = this.delegate.get();
        if (service != null) {
            return service.submit(this.taskManager.trackTask(task), result);
        }
        throw new RejectedExecutionException("Execution service is terminated. No more tasks can be executed.");
    }

    @Override
    public Future<?> submit(Runnable task) {
        ExecutorService service = this.delegate.get();
        if (service != null) {
            return service.submit(this.taskManager.trackTask(task));
        }
        throw new RejectedExecutionException("Execution service is terminated. No more tasks can be executed.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ObservableCallable<V>
    implements Callable<V>,
    ObservableTask {
        private final Callable<V> delegate;
        private final TaskObserver handler;
        private volatile boolean cancel;

        public ObservableCallable(Callable<V> delegate, TaskObserver handler) {
            this.delegate = delegate;
            this.handler = handler;
        }

        @Override
        public V call() throws Exception {
            if (!this.cancel) {
                try {
                    V result;
                    this.handler.beforeTaskStarts(this.delegate, Thread.currentThread());
                    V v = result = this.delegate.call();
                    return v;
                }
                finally {
                    this.handler.afterTaskFinishes(this.delegate, Thread.currentThread());
                }
            }
            return null;
        }

        @Override
        public ObservableTask.TaskType getType() {
            return ObservableTask.TaskType.CALLABLE;
        }

        @Override
        public void cancel() {
            this.cancel = true;
        }
    }

    protected static final class ObservableRunnable
    implements Runnable,
    ObservableTask {
        private final Runnable delegate;
        private final TaskObserver handler;
        private volatile boolean cancel;

        public ObservableRunnable(Runnable delegate, TaskObserver handler) {
            this.delegate = delegate;
            this.handler = handler;
            this.cancel = false;
        }

        public void run() {
            if (!this.cancel) {
                try {
                    try {
                        this.handler.beforeTaskStarts(this.delegate, Thread.currentThread());
                        this.delegate.run();
                    }
                    catch (Throwable t) {
                        this.handler.taskExceptionRaised(this.delegate, Thread.currentThread(), t);
                        this.handler.afterTaskFinishes(this.delegate, Thread.currentThread());
                    }
                }
                finally {
                    this.handler.afterTaskFinishes(this.delegate, Thread.currentThread());
                }
            }
        }

        public ObservableTask.TaskType getType() {
            return ObservableTask.TaskType.RUNNABLE;
        }

        public void cancel() {
            this.cancel = true;
        }
    }

    protected static interface ObservableTask {
        public TaskType getType();

        public void cancel();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TaskType {
            CALLABLE,
            RUNNABLE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TaskManager
    implements TaskObserver {
        private final Map<Object, ObservableTask> tasks;
        private Lock lock = new ReentrantLock();
        private Condition empty = this.lock.newCondition();

        public TaskManager() {
            this.tasks = new ConcurrentHashMap<Object, ObservableTask>();
        }

        public void waitUntilEmpty() {
            this.lock.lock();
            try {
                if (!this.tasks.isEmpty()) {
                    try {
                        this.empty.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void cleanUpTasks() {
            for (ObservableTask task : this.tasks.values()) {
                task.cancel();
            }
            this.tasks.clear();
        }

        public Runnable trackTask(Runnable task) {
            ObservableRunnable obs = new ObservableRunnable(task, this);
            this.tasks.put(task, obs);
            return obs;
        }

        public <T> Callable<T> trackTask(Callable<T> task) {
            ObservableCallable<T> obs = new ObservableCallable<T>(task, this);
            this.tasks.put(task, obs);
            return obs;
        }

        public Collection trackTasks(Collection tasksToTrack) {
            ArrayList results = new ArrayList(tasksToTrack.size());
            for (Callable task : tasksToTrack) {
                results.add(this.trackTask(task));
            }
            return results;
        }

        @Override
        public void afterTaskFinishes(Runnable task, Thread thread) {
            this.lock.lock();
            try {
                this.tasks.remove(task);
                if (this.tasks.isEmpty()) {
                    this.empty.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void afterTaskFinishes(Callable<?> task, Thread thread) {
            this.lock.lock();
            try {
                this.tasks.remove(task);
                if (this.tasks.isEmpty()) {
                    this.empty.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void beforeTaskStarts(Runnable task, Thread thread) {
        }

        @Override
        public void beforeTaskStarts(Callable<?> task, Thread thread) {
        }

        @Override
        public void taskExceptionRaised(Runnable task, Thread thread, Throwable t) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface TaskObserver {
        public void beforeTaskStarts(Runnable var1, Thread var2);

        public void beforeTaskStarts(Callable<?> var1, Thread var2);

        public void afterTaskFinishes(Runnable var1, Thread var2);

        public void afterTaskFinishes(Callable<?> var1, Thread var2);

        public void taskExceptionRaised(Runnable var1, Thread var2, Throwable var3);
    }
}

