/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.common.InternalRuleBase;
import org.drools.common.NodeMemories;
import org.drools.common.NodeMemory;

public class ConcurrentNodeMemories
implements NodeMemories {
    private static final long serialVersionUID = -2032997426288974117L;
    private AtomicReferenceArray<Object> memories;
    private Lock lock;
    private InternalRuleBase rulebase;

    public ConcurrentNodeMemories(InternalRuleBase rulebase) {
        this.rulebase = rulebase;
        this.memories = new AtomicReferenceArray(this.rulebase.getNodeCount());
        this.lock = new ReentrantLock();
    }

    public void clearNodeMemory(NodeMemory node) {
        this.memories.set(node.getId(), null);
    }

    public void clear() {
        this.memories = new AtomicReferenceArray(this.rulebase.getNodeCount());
    }

    public Object getNodeMemory(NodeMemory node) {
        Object memory;
        if (node.getId() >= this.memories.length()) {
            this.resize(node);
        }
        if ((memory = this.memories.get(node.getId())) == null) {
            memory = this.createNodeMemory(node);
        }
        return memory;
    }

    private Object createNodeMemory(NodeMemory node) {
        try {
            this.lock.lock();
            Object memory = this.memories.get(node.getId());
            if (memory == null) {
                memory = node.createMemory(this.rulebase.getConfiguration());
                if (!this.memories.compareAndSet(node.getId(), null, memory)) {
                    memory = this.memories.get(node.getId());
                }
            }
            Object object = memory;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void resize(NodeMemory node) {
        try {
            this.lock.lock();
            if (node.getId() >= this.memories.length()) {
                int size = Math.max(this.rulebase.getNodeCount(), node.getId() + 32);
                AtomicReferenceArray<Object> newMem = new AtomicReferenceArray<Object>(size);
                int i = 0;
                while (i < this.memories.length()) {
                    newMem.set(i, this.memories.get(i));
                    ++i;
                }
                this.memories = newMem;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRuleBaseReference(InternalRuleBase ruleBase) {
        this.rulebase = ruleBase;
    }
}

